//=============================================================================
// SoR_preemptiveWindow_MZ.js
// SoR License inherited from MIT License (C) 2020 蒼竜
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.10 (2020/03/28)
//=============================================================================
/*:ja
@plugindesc ＜先制・不意打ちメッセージウィンドウ＞ v1.10
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@help 戦闘開始時の、先制攻撃・エネミーによる不意打ち発生時の
メッセージ表示方式を変更します。デザイン優先の機能ですが、 
デフォルト戦闘システム通りにメッセージ機能を使わないゲームシステムでの
使用を想定しているため、戦闘開始時のゲームテンポの向上も期待できます。

@param Window_y-coordinate
@desc ウィンドウy座標 (default: 380)
@default 380
@type number
@param FontSize
@desc メッセージのフォントサイズ (default: 22)
@default 22
@type number

@param Preemptive_FontColor
@desc 先制攻撃メッセージのフォント色 (default: '#ffff66')
@default #ffff66
@type string
@param Surprised_FontColor
@desc 不意打ちメッセージのフォント色 (default: '#ff6666')
@default #ff6666
@type string

@param MessageWindow_duration
@desc ウィンドウ表示時間 (default: 200)
@default 200
@type number
*/
/*:
@plugindesc <Preemptive/Surprise Encounter Message Popup Window> v1.10
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help Alternate the format of preemptive/surprised message window 
at the beginning of battles.

@param Window_y-coordinate
@desc Y-coordinate of preemptive/surprised message window (default: 380)
@default 380
@type number
@param FontSize
@desc Font size of messages (default: 22)
@default 22
@type number

@param Preemptive_FontColor
@desc Font color for the text of preemptive message (default: '#ffff66')
@default #ffff66
@type string
@param Surprised_FontColor
@desc Font color for the text of surprised message (default: '#ff6666')
@default #ff6666
@type string

@param MessageWindow_duration
@desc Duration of preemptive/surprised message window (default: 200)
@default 200
@type number
*/


(function() {
const pluginName = "SoR_preemptiveWindow_MZ";
const Param = PluginManager.parameters(pluginName);

const Window_y_coord = Number(Param['Window_y-coordinate']) || 380; 
const FontSize = Number(Param['FontSize']) || 22;
const Preemptive_FontColor = String(Param['Preemptive_FontColor']); 
const Surprised_FontColor = String(Param['Surprised_FontColor']);
const MessageWindow_duration = Number(Param['MessageWindow_duration']) || 200;  


//battle start
const SoR_PEW_BM_displayStartMessages = BattleManager.displayStartMessages;
BattleManager.displayStartMessages = function() {
	SoR_PEW_BM_displayStartMessages.call(this);
	if (this._preemptive || this._surprise)   this._preemptiveMesWindow.popup();		
}

const SoR_PEW_BM_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
   SoR_PEW_BM_initMembers.call(this);
   this._preemptiveMesWindow = null;
}


//register
const SoR_PEW_SB_createAllWindows = Scene_Battle.prototype.createAllWindows;
Scene_Battle.prototype.createAllWindows = function() {
	SoR_PEW_SB_createAllWindows.call(this);
	this.createPreemptiveMesWindow();
}
//Create Window
Scene_Battle.prototype.createPreemptiveMesWindow = function() {
    this._preemptiveMesWindow = new Window_PreemptiveMes();
	this._preemptiveMesWindow.visible = true;
    this.addChild(this._preemptiveMesWindow);
}



const SoR_PEW_SB_createDisplayObjects = Scene_Battle.prototype.createDisplayObjects;
Scene_Battle.prototype.createDisplayObjects = function() {
	SoR_PEW_SB_createDisplayObjects.call(this);
	BattleManager.setPreemptiveMesWindow(this._preemptiveMesWindow);
}
//Set Window
BattleManager.setPreemptiveMesWindow = function(preemptiveMesWindow) {
    this._preemptiveMesWindow = preemptiveMesWindow;
}


function Window_PreemptiveMes() {
    this.initialize.apply(this, arguments);
}
Window_PreemptiveMes.prototype = Object.create(Window_Base.prototype);
Window_PreemptiveMes.prototype.constructor = Window_PreemptiveMes;


Window_PreemptiveMes.prototype.initialize = function() {
	this._text = '';
	this._timer = 0;
		
    const x = Graphics.width/2;
    const y = Window_y_coord;
    const width = 300;
    const height = 54;
	
    Window_Base.prototype.initialize.call(this, new Rectangle(x, y, width, height));
    this.openness = 0;
}


Window_PreemptiveMes.prototype.update  = function() {
	Window_Base.prototype.update.call(this);
	this._timer -= 1;
	if (this._timer === 0) this.close();
}

Window_PreemptiveMes.prototype.popup = function() {
	this.contents.clear();
	const padd = 24;
	let openflag = false;

	
	if(BattleManager._preemptive) this._text = TextManager.preemptive.format($gameParty.name());
	else if(BattleManager._surprise) this._text = TextManager.surprise.format($gameParty.name());

	if (this._text != '') {
	  this.contents.clear();
	  this.resetFontSettings();
	  this.contents.fontSize = FontSize;
      let width = this.textWidth(this._text);
	  this.width = width+padd*2;
	  this.x = Graphics.width/2 - this.width/2;
	  
	  this.contents = new Bitmap(this.width, this.innerHeight);
	  this.contents.fontSize = FontSize;
	  
	  this.resetFontSettings();
	  this.contents.fontSize = FontSize;

	  if(BattleManager._preemptive)	this.changeTextColor(Preemptive_FontColor);
	  else if(BattleManager._surprise) this.changeTextColor(Surprised_FontColor);
	  this.drawText(this._text, padd/2, -4, width, 'center');
	  this.contentsOpacity = 255;
	  openflag = true;
	}

	if (openflag) {
		this.open();
		this._timer = MessageWindow_duration;
	} else {
		this._timer = 1;
	}

}

}());