//=============================================================================
// SoR_VictoryResultScene_MZ_Gamma.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.11 (2021/11/06)
//=============================================================================
/*:ja
@plugindesc ＜戦闘勝利シーンγ＞ v1.11
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@orderAfter SoR_BattleTeminationRefactor_MZ
@orderBefore SoR_VictoryPerformance_MZ
@base SoR_BattleTeminationRefactor_MZ
@help ※要57.「戦闘終了処理ルーチン細分化」(SoR_BattleTeminationRefactor_MZ.js)

戦闘勝利後の戦闘結果表示演出を変更(戦闘シーン上での結果表示を廃止)し、
マップシーン復帰時に、マップ上でリザルト表示を行う方式を導入します。

スタイルによってスクリプトを分けています。
戦闘勝利シーンαまたはβのどちらかとは、本プラグインのプラグインコマンドによる
切り替えでマップ上・戦闘シーン上のリザルトシーンを切り替えることができます。
@param --基本--
@param BattleResult_Headtext
@desc 戦闘報酬メインウィンドウ見出しテキスト
@default Battle Result
@type string
@param WindowText_GetItem
@desc 取得アイテム欄見出しテキスト
@default Item
@type string
@param WindowText_NoGetItem
@desc 取得アイテム無し時のアイテム欄内表示テキスト
@default No Item
@type string
@param MainWindows_YPadd
@desc メイン報酬系ウィンドウ(アイテム・アクターEXP)y方向補正
@default 0
@min -9999
@type number

@param Duration_BattleResultScene
@desc リザルト画面が自動で終了するまでの(フレーム)時間
@default 600
@type number
@param PopupText_LevelUP
@desc レベルアップ時のポップアップ表示テキスト
@default Level Up!
@type string

@param BattleResultContents_YPadd
@desc 報酬系ウィンドウy方向補正
@default 0
@min -9999
@type number

@param TextColor_Rewards
@desc 報酬名テキスト描画カラー
@default #c0c0c0
@type string
@param ResultContents
@desc メイン報酬項目
@type struct<ResultContents>[]
@default ["{\"Name\":\"EXP\",\"ContentsID\":\"0\",\"ContentScript\":\"\",\"Unit\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"GOLD\",\"ContentsID\":\"1\",\"ContentScript\":\"\",\"Unit\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"TURN\",\"ContentsID\":\"2\",\"ContentScript\":\"\",\"Unit\":\"\",\"DigitsExtension\":\"false\"}"]

@param --音関係--
@param SE_Levelup
@desc アクターレベルアップ時の効果音
@type struct<SEDATA>
@default {"name":"Load1","volume":"100","pitch":"100","pan":"0"}

@command SuspendVRSShow
@text 戦闘リザルト一時停止[戦闘勝利シーンγ]
@desc 戦闘を含むイベント等で、一時的に戦闘リザルト処理を止めます。必ずイベント後に再度有効化する必要があります。
@command RestartVRSShow
@text 一時停止リザルト再開[戦闘勝利シーンγ]
@desc 一時停止した(せき止めている)戦闘リザルト処理を有効にします。有効にしなければEXP等が処理されないままとなります。
@command UseNormalResult
@text 通常リザルト切り替え[戦闘勝利シーンγ]
@desc 一時的に「通常の戦闘リザルトシーンの使用」に切り替えます。戦闘勝利シーンα/βにも切り替えられます。
@command RestoreMapResult
@text マップリザルト切り替え[戦闘勝利シーンγ]
@desc 一時的に戻した「通常の戦闘リザルトシーン」から「マップリザルトの使用」に切り替えます。
*/
/*~struct~SEDATA:
@type string
@param name
@dir audio/se/
@type file
@desc 効果音
@param volume
@desc 音量 [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc ピッチ [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc パン(位相) [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~ResultContents:
@param Name
@desc 表示するゲームデータに対応する表記名称。画像利用時は無効
@type string
@param ContentsID
@desc 表示ゲームデータ
@type select
@option 経験値
@value 0
@option お金
@value 1
@option ターン数
@value 2
@option 任意のスクリプト命令(ContentScriptに記述)
@value 3
@default 0
@param ContentScript
@desc 表示する特定ゲームデータ
@type string
@param Unit
@desc 末尾に付ける単位
@type string
@default 
@param DigitsExtension
@desc 値表示に記号部分が必要な項目の場合にtrueにする
@type boolean
@default false
*/
/*:
@plugindesc <Battle Result Scene - Gamma> v1.11
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@orderAfter SoR_BattleTeminationRefactor_MZ
@orderBefore SoR_VictoryPerformance_MZ
@base SoR_BattleTeminationRefactor_MZ
@help [Prerequisite] 57. SoR_BattleTeminationRefactor_MZ

This plugin replaces the battle result. 
Remove the default battle result and perform it on the map 
(after came back from the battle scene) instead.

This is Type-Gamma, neither works with Type-Alpha nor Beta in v1.00.
@param --General--
@param BattleResult_Headtext
@desc Title text of the Rewards main window
@default Battle Result
@type string
@param WindowText_GetItem
@desc Title text for obtained item window
@default Get Item
@type string
@param WindowText_NoGetItem
@desc Text in the obtained item window which indicates no obtained items
@default No Item
@type string

@param MainWindows_YPadd
@desc Padding of the obtained item / reward window for y-coordinate
@default 0
@min -9999
@type number

@param Duration_BattleResultScene
@desc Duration (frames) of map result scene
@default 600
@type number
@param PopupText_LevelUP
@desc A text shown above the SV_Actor which indicates level up
@default Level Up!
@type string

@param TextColor_Rewards
@desc Text color for the name of each reward
@default #c0c0c0
@type string

@param BattleResultContents_YPadd
@desc Padding of the result contents for y-coordinate
@default 0
@min -9999
@type number

@param ResultContents
@desc Setting of rewards shown upper of the screen. List one by one.
@type struct<ResultContentsE>[]
@default ["{\"Name\":\"EXP\",\"ContentsID\":\"0\",\"ContentScript\":\"\",\"Unit\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"GOLD\",\"ContentsID\":\"1\",\"ContentScript\":\"\",\"Unit\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"TURN\",\"ContentsID\":\"2\",\"ContentScript\":\"\",\"Unit\":\"\",\"DigitsExtension\":\"false\"}"]

@param --Sounds--
@param SE_Levelup
@desc SE playes at level up of each actor
@type struct<SEDATAE>
@default {"name":"Load1","volume":"100","pitch":"100","pan":"0"}

@command SuspendVRSShow
@text Suspend Result [Battle Result Scene - Gamma]
@desc Stop the result process on maps. For battles occurred in the event cut scene. Must re-activate after the event.
@command RestartVRSShow
@text Restart Result [Battle Result Scene - Gamma]
@desc Re-activate the suspended result process. If you forget this, actors never gain any rewards.
@command UseNormalResult
@text Use Normal Result [Battle Result Scene - Gamma]
@desc Temporary restore NORMAL result "on battle scene". Battle Result Scene - Alpha/Beta can be also used. 
@command RestoreMapResult
@text Restore Map Result [Battle Result Scene - Gamma]
@desc Restore map result after using normal battle result temporary.
*/
/*~struct~SEDATAE:
@type string
@param name
@dir audio/se/
@type file
@desc SE File
@param volume
@desc Voulme [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc Pitch [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc Pan [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~ResultContentsE:
@param Name
@desc Title text which corresponds to the game data which will be shown. This is ignored if the image is used.
@type string
@param ContentsID
@desc Target game data
@type select
@option EXP
@value 0
@option Gold
@value 1
@option Number of Turns
@value 2
@option Arbitrary script (Fill in ContentScript)
@value 3
@default 0
@param ContentScript
@desc Target game data via script
@type string
@param Unit
@desc Suffix of the value
@type string
@default 
@param DigitsExtension
@desc Set true if you use extended signs for the target value.
@type boolean
@default false
*/

(function() {
const pluginName = "SoR_VictoryResultScene_MZ_Gamma";
const Param = PluginManager.parameters(pluginName);

if(!PluginManager._scripts.includes("SoR_BattleTeminationRefactor_MZ")) throw new Error("[SoR_VictoryResultScene_MZ_Beta] This plugin REQUIRES 57. SoR_BattleTeminationRefactor_MZ.");

const BattleResult_Headtext = String(Param['BattleResult_Headtext']) || '';
const WindowText_GetItem = String(Param['WindowText_GetItem']) || '';
const WindowText_NoGetItem = String(Param['WindowText_NoGetItem']) || '';
const MainWindows_YPadd = Number(Param['MainWindows_YPadd']) || 0;
const ResultContents = convertJsonParams(Param['ResultContents']);

const Duration_BattleResultScene = Number(Param['Duration_BattleResultScene']) || 0;
const BattleResultContents_YPadd = Number(Param['BattleResultContents_YPadd']) || 0;
const PopupText_LevelUP = String(Param['PopupText_LevelUP']) || '';
const TextColor_Rewards = String(Param['TextColor_Rewards']) || '';

const ImageFile_ResultHeader = String(Param['ImageFile_ResultHeader']) || '';
const ImageFile_ITEMHeader = String(Param['ImageFile_ITEMHeader']) || '';

const SE_Levelup = convertJsonStruct(Param['SE_Levelup']);

function convertJsonParams(param) {
    if (param == undefined) return [];
    let arr = [];
        JSON.parse(param).map(function(param) {
            const obj = JSON.parse(param);
            obj.ContentsID = Number(obj.ContentsID);
            obj.DigitsExtension = obj.DigitsExtension==="true"? true: false;
            arr.push(obj);
        });
    return arr;
}

function convertJsonStruct(param) {
    const obj = JSON.parse(param);
    obj.volume = Number(obj.volume);
    obj.pan = Number(obj.pan);
    obj.pitch = Number(obj.pitch);
    return obj;
}

function convertJsonStrs(param) {
	if (param == undefined) return [];
	let arr = [];
		JSON.parse(param).map(function(param) {
			arr.push(param);
		});
	return arr; 
}

ImageManager.loadBattleHudSprite = function(filename) {
    return this.loadBitmap('img/SoRBatHUD/', filename, 0, true);
}
///////////////////////////////////////////////////////////////////////////////
const SoR_VRS_GS_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
    SoR_VRS_GS_initialize.call(this);
    this._UseNormalBattleResult = false;
    this._isSuspend_BattleResultOnMap = false;
}


PluginManager.registerCommand(pluginName, "SuspendVRSShow", args => {
    $gameSystem._isSuspend_BattleResultOnMap = true;
});
PluginManager.registerCommand(pluginName, "RestartVRSShow", args => {
    $gameSystem._isSuspend_BattleResultOnMap = false;
});
PluginManager.registerCommand(pluginName, "UseNormalResult", args => {
    $gameSystem._UseNormalBattleResult = true;
});
PluginManager.registerCommand(pluginName, "RestoreMapResult", args => {
    $gameSystem._UseNormalBattleResult = false;
});

function Check_GammaSync(){
    if(typeof $gameSystem._UseNormalBattleResult === "undefined") $gameSystem._UseNormalBattleResult = false;
    return $gameSystem._UseNormalBattleResult;
}

///////////////////////////////////////////////////////////////////////////////

    const SoR_VRS_BM_ProcessWinSounds = BattleManager.ProcessWinSounds;
    BattleManager.ProcessWinSounds = function(){
        if($gameSystem._UseNormalBattleResult == false) return;
        SoR_VRS_BM_ProcessWinSounds.call(this);
    }
    const SoR_VRS_BM_ProcessWin = BattleManager.ProcessWin;
    BattleManager.ProcessWin = function(){
        if($gameSystem._UseNormalBattleResult == false) return;
        SoR_VRS_BM_ProcessWin.call(this);
    }


if(!PluginManager._scripts.includes("SoR_VictoryResultScene_MZ_Alpha") && !PluginManager._scripts.includes("SoR_VictoryResultScene_MZ_Beta")){
    const SoR_VRS_BM_BattleWinTerminater = BattleManager.BattleWinTerminater;
    BattleManager.BattleWinTerminater = function(){//end
        this.BattleWinTerminater_GAMMA();
        SoR_VRS_BM_BattleWinTerminater.call(this);
    }
}

BattleManager.BattleWinTerminater_GAMMA = function(){//end
    if(!Check_GammaSync()){
        if(PluginManager._scripts.includes("SoR_BattleBGMManager_MZ")){
            if(!$gameTemp.restoreMapBGM_rightAfterBattles) this.ProcessWin_AfterSounds();////
        }
		else this.ProcessWin_AfterSounds();
		
        this.results_onMap = true;
        this._actorLvUPbyBattles = [];
    }
}


const SoR_VRS_SM_update = Scene_Map.prototype.update;
Scene_Map.prototype.update = function(){
    SoR_VRS_SM_update.call(this);

    if(BattleManager.results_onMap == true){
        if(typeof $gameSystem._isSuspend_BattleResultOnMap === "undefined") $gameSystem._isSuspend_BattleResultOnMap = false;
        if($gameSystem._isSuspend_BattleResultOnMap == false) this.createMapBattleResult();
    }
    else if(this._BatResonMap && typeof this._BatResonMap !== "undefined") this.updateMapBattleResult();
}


Scene_Map.prototype.createMapBattleResult = function(){
    this._BatResonMap = new Window_VictoryBattleLayout_GAMMA(BattleManager._rewards);
    for(const x of this._BatResonMap.windowElems) this.addChild(x);
    BattleManager.ProcessWinRewardsGain();
    BattleManager.results_onMap = false;

    if(BattleManager._actorLvUPbyBattles.length >=1){
        const spr = this._spriteset.findTargetSprite($gamePlayer);
        const lvupspr = new Sprite_VRSGPopup();
        spr.addChild(lvupspr);
        lvupspr.setup();
        AudioManager.playSe(SE_Levelup);
    }
}

Scene_Map.prototype.updateMapBattleResult = function(){
    if(this._BatResonMap._retreat == false){
        if(this._BatResonMap.update() == false){
        this._BatResonMap.prepareRetreat();
        this.removeChild(this._BatResonMap.result_exp);
        this.removeChild(this._BatResonMap.result_items);
        delete this._BatResonMap.result_exp;
        delete this._BatResonMap.result_items;
        }
    }
    else if(this._BatResonMap._retreat == true){
        if(this._BatResonMap.update() == false){
            this.removeChild(this._BatResonMap.window_resultDrops);
            this.removeChild(this._BatResonMap.result_items);
            delete this._BatResonMap.window_resultDrops;
            delete this._BatResonMap.window_resultMain;
            delete this._BatResonMap;
            this._BatResonMap = undefined;
        }
    }
}

//original levelup display
const SoR_VRS_GA_Terminate_displayLevelUp = Game_Actor.prototype.displayLevelUp;
Game_Actor.prototype.displayLevelUp = function(newSkills) {
    if(BattleManager.results_onMap == true){
        BattleManager.prepareBattleVictoryLvup_GAMMA(this, newSkills);
        return;
    }

    //regular levelup display
    SoR_VRS_GA_Terminate_displayLevelUp.call(this,...arguments);
}



BattleManager.prepareBattleVictoryLvup_GAMMA = function(actor, newSkls) {//suspended
    this._actorLvUPbyBattles.push({actor, newSkls});
}

//////////////////////////////////////////////////
function Window_VictoryBattleLayout_GAMMA() {
    this.initialize(...arguments);
}

Window_VictoryBattleLayout_GAMMA.prototype.constructor = Window_VictoryBattleLayout_GAMMA;
Window_VictoryBattleLayout_GAMMA.prototype.initialize = function(rewards) {
    this.duration = Duration_BattleResultScene;
    this._retreat = false;
    
    this.window_resultMain = new Window_VictoryBattleResultsMain_GAMMA(new Rectangle(Graphics.width,Graphics.height*0.25 + MainWindows_YPadd,300,Graphics.height*0.5),rewards);
    this.window_resultDrops = new Window_VictoryBattleResultsDrops_GAMMA(new Rectangle(-Graphics.width,Graphics.height*0.25 + MainWindows_YPadd,320,Graphics.height*0.5), rewards);
    this.window_actors = [];

    this.result_exp = new Window_VictoryMultipurpose_GAMMA(new Rectangle(0,Graphics.height*0.25 + MainWindows_YPadd,Graphics.width,80));
    this.result_exp.setEXPDefault();
    this.result_exp.x = Graphics.width - 320 +12;
    this.result_exp.y = Graphics.height*0.25 + MainWindows_YPadd-24;

    this.result_items = new Window_VictoryMultipurpose_GAMMA(new Rectangle(0,Graphics.height*0.25 + MainWindows_YPadd,Graphics.width,80));
    this.result_items.setITEMsDefault();
    this.result_items.x = 0;
    this.result_items.y = Graphics.height*0.25 + MainWindows_YPadd-24;

    this.windowElems = [];
    //for(const x of this.window_actors) this.windowElems.push(x);
    this.windowElems.push(this.window_resultDrops);
    this.windowElems.push(this.window_resultMain);
    this.windowElems.push(this.result_exp);
    this.windowElems.push(this.result_items);
}

Window_VictoryBattleLayout_GAMMA.prototype.update = function() {
    this.duration--;

    if(this.duration>0) return true;
    else return false;
}

Window_VictoryBattleLayout_GAMMA.prototype.prepareRetreat = function() {
    this.duration = 128;
    this._retreat = true;
    this.window_resultMain.start_retreat();
    this.window_resultDrops.start_retreat();
}


//////////////////////////////////////////////////
function Window_VictoryMultipurpose_GAMMA () {
    this.initialize(...arguments);
}
Window_VictoryMultipurpose_GAMMA.prototype = Object.create(Window_Base.prototype);
Window_VictoryMultipurpose_GAMMA.prototype.constructor = Window_VictoryMultipurpose_GAMMA;

Window_VictoryMultipurpose_GAMMA.prototype.initialize = function(rect) {
    Window_Base.prototype.initialize.call(this, rect);
}

Window_VictoryMultipurpose_GAMMA.prototype.setEXPDefault = function() {
    this.setBackgroundType(2);
    this.contents.fontSize = 24;
    this.changeTextColor(ColorManager.textColor(14));
    this.DrawHorizonLine(0,26,280,5,TextColor_Rewards);
    this.drawText(BattleResult_Headtext, 0, 0, this.width, "left");
    this.resetTextColor();
}

Window_VictoryMultipurpose_GAMMA.prototype.setITEMsDefault = function() {
    this.setBackgroundType(2);
    this.contents.fontSize = 24;
    this.changeTextColor(ColorManager.textColor(14));
    this.DrawHorizonLine(0,26,280,5,TextColor_Rewards);
    this.drawText(WindowText_GetItem, 0, 0, this.width, "left");
    this.resetTextColor();
}

Window_VictoryMultipurpose_GAMMA.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity 
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}




//////////////////////////////////////////////////
function Window_VictoryBattleResultsMain_GAMMA() {
    this.initialize(...arguments);
}
Window_VictoryBattleResultsMain_GAMMA.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleResultsMain_GAMMA.prototype.constructor = Window_VictoryBattleResultsMain_GAMMA;

Window_VictoryBattleResultsMain_GAMMA.prototype.initialize = function(rect, rewards) {
    this.rewards = rewards;
    this.mainwidth = 300;  //Columns_BattleResultContents
    this.dispnums = [];
    this.dispitem = [];
    this.createRewardContents();
    this.NDispItems = this.dispitem.length;

    Window_Base.prototype.initialize.call(this, rect);
    this.base = this.initialize_coordinatebase();
    this.setBackgroundType(1);
    this.refresh();
    this.open();
}


Window_VictoryBattleResultsMain_GAMMA.prototype.initialize_coordinatebase = function() {
    let px = 0, py = 12 + BattleResultContents_YPadd;
    return {x: px, y: py};
}

Window_VictoryBattleResultsMain_GAMMA.prototype.item_coordinateX = function(i,digit) {
    px = 6;
    if(digit==true) px+=Digits_XPadd;
    return px;
}
Window_VictoryBattleResultsMain_GAMMA.prototype.item_coordinateY = function(i,digit) {
    py = this.base.y + i * 32;
    if(digit==true) py+=Digits_YPadd;
    return py;
}

Window_VictoryBattleResultsMain_GAMMA.prototype.createRewardContents = function(rect, rewards) {
    const ncont = ResultContents.length;
    for(const x of ResultContents){
        let value;
        switch(x.ContentsID){
            case 0:
                value = this.rewards.exp;
            break;
            case 1:
                value = this.rewards.gold;
            break;
            case 2:
                value = $gameTroop._turnCount;
            break;
            case 3:
                value = SoR_Eval(x.ContentScript);
            break;
        }
    this.dispitem.push({name: x.Name, val: value, exdig: x.DigitsExtension, unit: x.Unit});
    this.dispnums.push(0);
    }
}

Window_VictoryBattleResultsMain_GAMMA.prototype.refresh = function() {
        this.contents.clear();
        this.contents.fontSize = 18;
        for(let i=0; i<this.NDispItems; i++) this.dispItem(i);
}


/////////////////////////////////////////////////////
Window_VictoryBattleResultsMain_GAMMA.prototype.dispItem = function(idx) {
   const px = this.item_coordinateX(idx,false);
   const py = this.item_coordinateY(idx,false);

   this.changeTextColor(ColorManager.textColor(14));
   this.DrawHorizonLine(px,py+24,260,4,TextColor_Rewards);
   this.drawText(this.dispitem[idx].name, px+8,py, 260 , "left");
   this.resetTextColor();

   const txt = this.dispnums[idx];
   let dispnum =  this.dispitem[idx].exdig? txt.toFixed(2) : txt;
   dispnum = dispnum + this.dispitem[idx].unit;
   this.drawText(dispnum, px,py, 250, "right");
}

Window_VictoryBattleResultsMain_GAMMA.prototype.update = function() {
    let isrequired = false;

    for(let i=0; i<this.NDispItems; i++){

        if(isNaN(this.dispitem[i].val)) this.dispnums[i] = this.dispitem[i].val;
        else{
            const ret = CalcSlideStatusDiff(this.dispitem[i].val,this.dispnums[i], this.dispitem[i].exdig);
            if(this.dispnums[i] != ret) isrequired = true;
            this.dispnums[i] = ret;
        }
    }

    if(isrequired == true) this.refresh();

    if(this.retreating){
        if(this.x < Graphics.width+32) this.x -= (this.x - Graphics.width-32)/8;
        else this.x = Graphics.width+32;
    }
    else{
        if(this.x > Graphics.width - this.mainwidth) this.x += ((Graphics.width-this.mainwidth) - this.x)/4;
        else this.x = Graphics.width - this.mainwidth;
    }
}

Window_VictoryBattleResultsMain_GAMMA.prototype.start_retreat = function() {
    this.retreating = true;
}



function CalcSlideStatusDiff(param, disp, exflag){
	if(param == disp) return disp;
	const diff = disp-param;
    if(exflag && Math.abs(diff)<0.0001) return disp;
    const spd = exflag ? 0.08 : 1 + Math.abs(diff)/8.0;

	if(diff>0){
	    disp-=spd;
		if(disp < param) disp = param;
	}
	else{
	    disp+=spd;
		if(disp > param) disp = param;
    }

	return exflag ? disp : Math.floor(disp);
}


Window_VictoryBattleResultsMain_GAMMA.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity 
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}

Bitmap.prototype.FillRoundedRect = function(x, y, width, height, radius, color) {
    var context = this._context;
    var pi = Math.PI;
    context.save();
    context.fillStyle = color;
    context.beginPath();
    context.arc(x + radius, y + radius, radius, -pi, -0.5 * pi, false);
    context.arc(x + width - radius, y + radius, radius, -0.5 * pi, 0, false);
    context.arc(x + width - radius, y + height - radius, radius, 0, 0.5 * pi, false);
    context.arc(x + radius, y + height - radius, radius, 0.5 * pi, pi, false);
    context.fill();
    context.restore();
}




//////////////////////////////////////////////////
function Window_VictoryBattleResultsDrops_GAMMA() {
    this.initialize(...arguments);
}
Window_VictoryBattleResultsDrops_GAMMA.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleResultsDrops_GAMMA.prototype.constructor = Window_VictoryBattleResultsDrops_GAMMA;

Window_VictoryBattleResultsDrops_GAMMA.prototype.initialize = function(rect,rewards) {
    this.items = rewards.items;
    this.itemsNumArr = [];
    this.checkDuplicate();
    this.nitem = this.items.length;
    const nL = this.nitem;
    //rect.height = this.fittingHeight(nL);
    Window_Base.prototype.initialize.call(this, rect);

    this.setBackgroundType(1);
    this.open();
    this.refresh();
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.checkDuplicate = function() {
    for(let i=0; i<this.items.length; i++){
        const cand = this.items[i];
        this.itemsNumArr[i] = 1;
        for(let j=i+1; j<this.items.length; j++){
            const test = this.items[j];
            if(cand.id == test.id){
                if(cand.itypeId){
                    if(test.itypeId && cand.itypeId == test.itypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
                else if(cand.atypeId){
                    if(test.atypeId && cand.atypeId == test.atypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
                else if(cand.wtypeId){
                    if(test.wtypeId && cand.wtypeId == test.wtypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
            }
        }
    }
}            

Window_VictoryBattleResultsDrops_GAMMA.prototype.update = function() {
    if(this.retreating){
        if(this.x>-324) this.x += (-324-this.x)/8;
        else this.x = -324;
    }
    else{
        if(this.x<0) this.x -= (this.x/4-1);
        else this.x = 0;
    }
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.start_retreat = function() {
    this.retreating = true;
}


Window_VictoryBattleResultsDrops_GAMMA.prototype.refresh = function() {
   this.contents.clear();

   this.contents.fontSize = 20;
   if(this.nitem==0){
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(WindowText_NoGetItem, 15, 12, 280);
   }
   for(let i=0; i<this.nitem; i++) this.dispItem(i);
   //AudioManager.playSe(SE_ItemWindow);
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity 
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.dispItem = function(index) {
    const item = this.items[index];
    const numberWidth = this.numberWidth();
    const textMargin = ImageManager.iconWidth + 4;
    const itemWidth = Math.max(0, this.itemWidth() - textMargin);
    const rect = this.itemLineRect(index);
    this.drawItemName(item, rect.x, rect.y+12, rect.width - numberWidth - 8);
    //if(this.itemsNumArr[index]>=2) 
    this.drawItemNumber(this.itemsNumArr[index], rect.x, rect.y+12, rect.width);
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.drawItemNumber = function(tx, x, y, width) {
    this.drawText("x", x, y, 8+ width - this.textWidth("00"), "right");
    this.drawText(tx, x, y, 8+ width, "right");
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.itemLineRect = function(index) {
    const rect = this.itemRectWithPadding(index);
    const padding = (rect.height - this.lineHeight()) / 2;
    rect.y += padding;
    rect.height -= padding * 2;
    return rect;
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.itemRectWithPadding = function(index) {
    const rect = this.itemRect(index);
    const padding = this.itemPadding();
    rect.x += padding;
    rect.width -= padding * 2;
    return rect;
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.itemRect = function(index) {
    const maxCols = this.maxCols();
    const itemWidth = this.itemWidth();
    const itemHeight = this.itemHeight();
    const colSpacing = 8;
    const rowSpacing = 4;
    const col = index % maxCols;
    const row = Math.floor(index / maxCols);
    const x = col * itemWidth + colSpacing / 2;
    const y = row * itemHeight + rowSpacing / 2;
    const width = itemWidth - colSpacing;
    const height = itemHeight - rowSpacing;
    return new Rectangle(x, y, width, height);
}

Window_VictoryBattleResultsDrops_GAMMA.prototype.numberWidth = function() { return this.textWidth("000"); }
Window_VictoryBattleResultsDrops_GAMMA.prototype.maxCols = function() { return 1; }
Window_VictoryBattleResultsDrops_GAMMA.prototype.itemWidth = function() { return this.width-24;}
Window_VictoryBattleResultsDrops_GAMMA.prototype.itemHeight = function() { return 36;}

//////////////////////////////////////////////////
function Sprite_VRSGPopup() {
    this.initialize(...arguments);
}

Sprite_VRSGPopup.prototype = Object.create(Sprite.prototype);
Sprite_VRSGPopup.prototype.constructor = Sprite_VRSGPopup;

Sprite_VRSGPopup.prototype.initialize = function() {
    Sprite.prototype.initialize.call(this);
    this._duration = 240;
    this._flashColor = [0, 0, 0, 0];
    this._flashDuration = 0;
    this._colorType = 0;
}

Sprite_VRSGPopup.prototype.destroy = function(options) {
    for (const child of this.children) {
        if (child.bitmap) {
            child.bitmap.destroy();
        }
    }
    Sprite.prototype.destroy.call(this, options);
}

Sprite_VRSGPopup.prototype.setup = function() {
    this.createLvUP();
    this.setupLVUPEffect();
}

Sprite_VRSGPopup.prototype.setupLVUPEffect = function() {
    this._flashColor = [255, 0, 0, 160];
    this._flashDuration = 60;
}

Sprite_VRSGPopup.prototype.fontFace = function() {
    return $gameSystem.numberFontFace();
}

Sprite_VRSGPopup.prototype.fontSize = function() {
    return $gameSystem.mainFontSize() + 4;
}

Sprite_VRSGPopup.prototype.damageColor = function() {
    return ColorManager.damageColor(this._colorType);
}

Sprite_VRSGPopup.prototype.outlineColor = function() {
    return "rgba(0, 0, 0, 0.7)";
}

Sprite_VRSGPopup.prototype.outlineWidth = function() {
    return 4;
}

Sprite_VRSGPopup.prototype.createLvUP = function() {
    const h = this.fontSize() * 2;
    const w = Math.floor(h * 4.0);
    const sprite = this.createChildSprite(w, h);
    sprite.bitmap.drawText(PopupText_LevelUP, 0, 0, w, h, "center");
    sprite.dy = 0;
}

Sprite_VRSGPopup.prototype.createChildSprite = function(width, height) {
    const sprite = new Sprite();
    sprite.bitmap = this.createBitmap(width, height);
    sprite.anchor.x = 0.5;
    sprite.anchor.y = 1;
    sprite.y = -40;
    sprite.ry = sprite.y;
    this.addChild(sprite);
    return sprite;
}

Sprite_VRSGPopup.prototype.createBitmap = function(width, height) {
    const bitmap = new Bitmap(width, height);
    bitmap.fontFace = this.fontFace();
    bitmap.fontSize = this.fontSize();
    bitmap.textColor = this.damageColor();
    bitmap.outlineColor = this.outlineColor();
    bitmap.outlineWidth = this.outlineWidth();
    return bitmap;
}

Sprite_VRSGPopup.prototype.update = function() {
    Sprite.prototype.update.call(this);
    if (this._duration > 0) {
        this._duration--;
        for (const child of this.children) {
            this.updateChild(child);
        }
    }
    this.updateFlash();
    this.updateOpacity();
}

Sprite_VRSGPopup.prototype.updateChild = function(sprite) {
    sprite.dy += 0.5;
    sprite.ry += sprite.dy;
    if (sprite.ry >= 0) {
        sprite.ry = 0;
        sprite.dy *= -0.6;
    }
    sprite.y = Math.round(sprite.ry) - 40;
    sprite.setBlendColor(this._flashColor);
}

Sprite_VRSGPopup.prototype.updateFlash = function() {
    if (this._flashDuration > 0) {
        const d = this._flashDuration--;
        this._flashColor[3] *= (d - 1) / d;
    }
}

Sprite_VRSGPopup.prototype.updateOpacity = function() {
    if (this._duration < 10) {
        this.opacity = (255 * this._duration) / 10;
    }
    else this.opacity = 255;
}

Sprite_VRSGPopup.prototype.isPlaying = function() {
    return this._duration > 0;
}

/////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    
    return res;
}
})();