//=============================================================================
// SoR_VictoryResultScene_MZ_Beta.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.13 (2021/07/16)
//=============================================================================
/*:ja
@plugindesc ＜戦闘勝利シーンβ＞ v1.13
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@orderAfter SoR_BattleTeminationRefactor_MZ
@orderBefore SoR_VictoryPerformance_MZ
@base SoR_BattleTeminationRefactor_MZ
@help ※要 57.「戦闘終了処理ルーチン細分化」(SoR_BattleTeminationRefactor_MZ.js)

戦闘勝利後の戦闘結果表示演出を変更します。
スタイルによってスクリプトを分けています。戦闘勝利シーンαとは共用できません。
(γとはγ側のプラグインコマンドによる切り替えで両立します)
@param --基本--
@param BattleResult_Headtext
@desc 戦闘結果画面上部ヘッダーテキスト
@default Battle Result
@type string

@param WindowText_GetEXP
@desc アクター経験値欄見出しテキスト
@default EXP
@type string
@param WindowText_GetItem
@desc 取得アイテム欄見出しテキスト
@default Item
@type string
@param WindowText_NoGetItem
@desc 取得アイテム無し時のアイテム欄内表示テキスト
@default No Item
@type string
@param MainWindows_YPadd
@desc メイン報酬系ウィンドウ(アイテム・アクターEXP)y方向補正
@default 0
@min -9999
@type number

@param PopupText_LevelUP
@desc レベルアップ時のポップアップ表示テキスト
@default Level Up!
@type string

@param Columns_BattleResultContents
@desc 画面下部・各報酬項目を表示する列数
@type select
@option 1列(左端)
@value 1
@option 2列(両端)
@value 2
@default 2
@param BattleResultContents_YPadd
@desc 報酬系ウィンドウy方向補正
@default 0
@min -9999
@type number

@param TextColor_Rewards
@desc 報酬名テキスト描画カラー
@default #c0c0c0
@type string

@param ShowAllPartyMembers
@desc true: 獲得経験値情報を控えメンバーも含めて表示する (default: false)
@default false
@type boolean
@param ResultContents
@desc 画面上部・報酬項目
@type struct<ResultContents>[]
@default ["{\"Name\":\"GOLD\",\"ContentsID\":\"1\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"Turns\",\"ContentsID\":\"2\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}"]

@param --ゲージ画像(必須)--
@param ImageFile_GaugeBase
@desc 経験値ゲージ土台画像
@type file
@dir img/SoRBatHUD/
@default gauge_base
@param ImageFile_GaugeTop
@desc 経験値ゲージ本体画像
@type file
@dir img/SoRBatHUD/
@default gauge_top

@param GaugeTop_XPadd
@desc 経験値ゲージ本体描画位置x方向補正
@default 4
@min -9999
@type number
@param GaugeTop_YPadd
@desc 経験値ゲージ本体描画位置y方向補正
@default 0
@min -9999
@type number

@param --一般画像関係--
@param UseImages_ForContents
@desc true: 獲得経験値・獲金等表示を画像UIで構成する。falseの場合以下無効 (default: false)
@default false
@type boolean

@param ImageFile_Header
@desc 戦闘結果画面上部ヘッダー画像
@type file
@dir img/SoRBatHUD/
@param ImageFile_EXPHeader
@desc 戦闘結果アクター経験値部分ヘッダー画像
@type file
@dir img/SoRBatHUD/
@param ImageFile_ITEMHeader
@desc 戦闘結果アイテムリスト部分ヘッダー画像
@type file
@dir img/SoRBatHUD/


@param ImageFile_Rewards
@desc 各報酬用背景画像。背景＋項目テキスト入りを想定(ResultContentsの登録順に対応)
@type file[]
@default [""]
@dir img/SoRBatHUD/

@param ImageFile_Digits
@desc 数値画像
@type file
@dir img/SoRBatHUD/
@param DigitImageFormat
@desc 数値画像の形式
@type select
@option 通常(0123456789)
@value 10
@option 記号拡張(0123456789+-.:/*)
@value 16
@default 10

@param Digits_XPadd
@desc 数値描画位置x方向補正
@default 0
@type number
@param Digits_YPadd
@desc 数値描画位置y方向補正
@default 0
@type number
@param Digits_AlignWidth
@desc 数値の桁と桁の描画間隔補正(default: -2)
@default -2
@type number
@min -9999

@param --音関係--
@param SE_Levelup
@desc アクターレベルアップ時の効果音
@type struct<SEDATA>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
*/
/*~struct~SEDATA:
@type string
@param name
@dir audio/se/
@type file
@desc 効果音
@param volume
@desc 音量 [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc ピッチ [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc パン(位相) [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~ResultContents:
@param Name
@desc 表示するゲームデータに対応する表記名称。画像利用時は無効
@type string
@param ContentsID
@desc 表示ゲームデータ
@type select
@option 経験値
@value 0
@option お金
@value 1
@option ターン数
@value 2
@option 任意のスクリプト命令(ContentScriptに記述)
@value 3
@default 0
@param ContentScript
@desc 表示する特定ゲームデータ
@type string
@param DigitsExtension
@desc 値表示に記号部分が必要な項目の場合にtrueにする
@type boolean
@default false
*/
/*:
@plugindesc <Battle Result Scene - Beta> v1.13
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@orderAfter SoR_BattleTeminationRefactor_MZ
@orderBefore SoR_VictoryPerformance_MZ
@base SoR_BattleTeminationRefactor_MZ
@help [Prerequisite] 57. SoR_BattleTeminationRefactor_MZ

This plugin replaces the battle result show as
a pseudo result scene inspired by "Trails" series.

This is Type-Beta, which cannot work with Type-Alpha,
but compatible with Type-Gamma by switching the flag
via the plugin command in Gamma.
@param --General--
@param BattleResult_Headtext
@desc Title text of the result scene shown upper of the screen
@default Battle Result
@type string

@param WindowText_GetEXP
@desc Header text for battler EXP results
@default EXP
@type string
@param WindowText_GetItem
@desc Header text for obtained item window
@default Get Item
@type string
@param WindowText_NoGetItem
@desc Text in the obtained item window which indicates no obtained items
@default No Item
@type string

@param MainWindows_YPadd
@desc Padding of the obtained item / actor exp window for y-coordinate
@default 0
@min -9999
@type number

@param PopupText_LevelUP
@desc A text shown above the SV_Actor which indicates level up
@default Level Up!
@type string

@param Columns_BattleResultContents
@desc Number of columns showing result contents at the bottom of the screen
@type select
@option 1 column (left side)
@value 1
@option 2 column (both side)
@value 2
@default 2
@param BattleResultContents_YPadd
@desc Padding of the result contents for y-coordinate
@default 0
@min -9999
@type number

@param TextColor_Rewards
@desc Text color for the name of each reward
@default #c0c0c0
@type string

@param ShowAllPartyMembers
@desc If true, exp gain of all party members including reserved members are shown. (default: false)
@default false
@type boolean

@param ResultContents
@desc Setting of rewards shown upper of the screen. List one by one.
@type struct<ResultContentsE>[]
@default ["{\"Name\":\"GOLD\",\"ContentsID\":\"1\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"Turns\",\"ContentsID\":\"2\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}"]

@param -Guage Image (Mandatory)-
@param ImageFile_GaugeBase
@desc Base image of EXP gauge
@type file
@dir img/SoRBatHUD/
@default gauge_base
@param ImageFile_GaugeTop
@desc Top image of EXP gauge covering the base
@type file
@dir img/SoRBatHUD/
@default gauge_top

@param GaugeTop_XPadd
@desc Padding of Top image of EXP gauge for x-coordinate
@default 4
@min -9999
@type number
@param GaugeTop_YPadd
@desc Padding of Top image of EXP gauge for y-coordinate
@default 0
@min -9999
@type number

@param -Original Images (optional)-
@param UseImages_ForContents
@desc IF true, result contents are composed by original images. (default: false)
@default false
@type boolean

@param ImageFile_Header
@desc Title image of the result scene shown upper of the screen
@type file
@dir img/SoRBatHUD/
@param ImageFile_EXPHeader
@desc Header image of the actor EXP
@type file
@dir img/SoRBatHUD/
@param ImageFile_ITEMHeader
@desc Header image of the obtained items
@type file
@dir img/SoRBatHUD/

@param ImageFile_Rewards
@desc Images for each reward item in the contents. (Corresponding to the order in ResultContents)
@type file[]
@default [""]
@dir img/SoRBatHUD/

@param ImageFile_Digits
@desc Image of digits aligned in a row
@type file
@dir img/SoRBatHUD/
@param DigitImageFormat
@desc Format of digits
@type select
@option Regular (0123456789)
@value 10
@option Extended (0123456789+-.:/*)
@value 16
@default 10

@param Digits_XPadd
@desc Padding of values corresponding to the reward item for x-coordinate
@default 0
@type number
@param Digits_YPadd
@desc Padding of values corresponding to the reward item for y-coordinate
@default 0
@type number
@param Digits_AlignWidth
@desc Correction of span among each digit image (default: -2)
@default -2
@type number
@min -9999

@param --Sounds--
@param SE_Levelup
@desc SE playes at level up of each actor
@type struct<SEDATAE>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
*/
/*~struct~SEDATAE:
@type string
@param name
@dir audio/se/
@type file
@desc SE File
@param volume
@desc Voulme [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc Pitch [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc Pan [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~ResultContentsE:
@param Name
@desc Title text which corresponds to the game data which will be shown. This is ignored if the image is used.
@type string
@param ContentsID
@desc Target game data
@type select
@option EXP
@value 0
@option Gold
@value 1
@option Number of Turns
@value 2
@option Arbitrary script (Fill in ContentScript)
@value 3
@default 0
@param ContentScript
@desc Target game data via script
@type string
@param DigitsExtension
@desc Set true if you use extended signs for the target value.
@type boolean
@default false
*/

(function() {
const pluginName = "SoR_VictoryResultScene_MZ_Beta";
const Param = PluginManager.parameters(pluginName);

if(!PluginManager._scripts.includes("SoR_BattleTeminationRefactor_MZ")) throw new Error("[SoR_VictoryResultScene_MZ_Beta] This plugin REQUIRES SoR_BattleTeminationRefactor_MZ.");
if(PluginManager._scripts.includes("SoR_VictoryResultScene_MZ_Alpha")) throw new Error("[SoR_VictoryResultScene_MZ_Beta] Do not use this plugin with SoR_VictoryResultScene_MZ_Alpha.");

let Synchronize_Gamma;
if(PluginManager._scripts.includes("SoR_VictoryResultScene_MZ_Gamma")) Synchronize_Gamma = true;

const BattleResult_Headtext = String(Param['BattleResult_Headtext']) || '';
const WindowText_GetItem = String(Param['WindowText_GetItem']) || '';
const WindowText_NoGetItem = String(Param['WindowText_NoGetItem']) || '';
const ShowAllPartyMembers = Boolean(Param['ShowAllPartyMembers'] === 'true' || false);
const MainWindows_YPadd = Number(Param['MainWindows_YPadd']) || 0;
const ResultContents = convertJsonParams(Param['ResultContents']);

const Columns_BattleResultContents = Number(Param['Columns_BattleResultContents']) || 0;
const BattleResultContents_YPadd = Number(Param['BattleResultContents_YPadd']) || 0;
const PopupText_LevelUP = String(Param['PopupText_LevelUP']) || '';
const TextColor_Rewards = String(Param['TextColor_Rewards']) || '';

const ImageFile_GaugeBase = String(Param['ImageFile_GaugeBase']) || '';
const ImageFile_GaugeTop = String(Param['ImageFile_GaugeTop']) || '';
const GaugeTop_XPadd = Number(Param['GaugeTop_XPadd']) || 0;
const GaugeTop_YPadd = Number(Param['GaugeTop_YPadd']) || 0;

const UseImages_ForContents = Boolean(Param['UseImages_ForContents'] === 'true' || false);
const ImageFile_Header = String(Param['ImageFile_Header']) || '';
const ImageFile_EXPHeader = String(Param['ImageFile_EXPHeader']) || '';
const ImageFile_ITEMHeader = String(Param['ImageFile_ITEMHeader']) || '';


const ImageFile_Rewards = convertJsonStrs(Param['ImageFile_Rewards']);
const ImageFile_Digits = String(Param['ImageFile_Digits']) || '';
const DigitImageFormat = Number(Param['DigitImageFormat']) || 10;
const Digits_XPadd = Number(Param['Digits_XPadd']) || 0;
const Digits_YPadd = Number(Param['Digits_YPadd']) || 0;
const Digits_AlignWidth = Number(Param['Digits_AlignWidth']) || 0;

const SE_Levelup = convertJsonStruct(Param['SE_Levelup']);

//v1.11
const WindowText_GetEXP = String(Param['WindowText_GetEXP']) || '';

function convertJsonParams(param) {
    if (param == undefined) return [];
    let arr = [];
        JSON.parse(param).map(function(param) {
            const obj = JSON.parse(param);
            obj.ContentsID = Number(obj.ContentsID);
            obj.DigitsExtension = obj.DigitsExtension==="true"? true: false;
            arr.push(obj);
        });
    return arr;
}

function convertJsonStruct(param) {
    const obj = JSON.parse(param);
    obj.volume = Number(obj.volume);
    obj.pan = Number(obj.pan);
    obj.pitch = Number(obj.pitch);
    return obj;
}

function convertJsonStrs(param) {
	if (param == undefined) return [];
	let arr = [];
		JSON.parse(param).map(function(param) {
			arr.push(param);
		});
	return arr;
}

ImageManager.loadBattleHudSprite = function(filename) {
    return this.loadBitmap('img/SoRBatHUD/', filename, 0, true);
}

function Check_GammaSync(){
    if(!Synchronize_Gamma) return false;
    if(typeof $gameSystem._UseNormalBattleResult === "undefined") $gameSystem._UseNormalBattleResult = false;
    if(Synchronize_Gamma && $gameSystem._UseNormalBattleResult == false) return true;
    return false;
}
///////////////////////////////////////////////////////////////////////////////

const SoR_VRS_BM_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
    SoR_VRS_BM_initMembers.call(this);
    this._VictoryResult = null;
    for(const x of ImageFile_Rewards) ImageManager.loadBattleHudSprite(x);
    ImageManager.loadBattleHudSprite(ImageFile_Digits);
    ImageManager.loadBattleHudSprite(ImageFile_GaugeBase);
    ImageManager.loadBattleHudSprite(ImageFile_GaugeTop);
    ImageManager.loadBattleHudSprite(ImageFile_Header);
    ImageManager.loadBattleHudSprite(ImageFile_EXPHeader);
    ImageManager.loadBattleHudSprite(ImageFile_ITEMHeader);
    this._victoryProcesses = [this.main_resultshow];
}


const SoR_VRS_BM_ProcessWinSounds = BattleManager.ProcessWinSounds;
BattleManager.ProcessWinSounds = function(){//sound
    if(this._VictoryResult == null) SoR_VRS_BM_ProcessWinSounds.call(this);
}


BattleManager.ProcessWinMessage = function(){//winmes,rewards
    if(Check_GammaSync()) return;
    if(this._VictoryResult == null){
        this.makeRewards();
        this.FinalizeBattleRewards();
        this._VictoryResult = new Window_VictoryBattleLayout(this._rewards);
        for(const w of this._VictoryResult.windowElems) SceneManager._scene.addChild(w);
        this.gainRewards();
    }
}

const BM_VRS_BM_PrepareBattleRewards = BattleManager.PrepareBattleRewards;
BattleManager.PrepareBattleRewards = function(){
    if(Check_GammaSync()) BM_VRS_BM_PrepareBattleRewards.call(this);
}
const BM_VRS_BM_ProcessWinRewards = BattleManager.ProcessWinRewards;
BattleManager.ProcessWinRewards = function(){
    if(Check_GammaSync()) BM_VRS_BM_ProcessWinRewards.call(this);
}
const BM_VRS_BM_gainExp = BattleManager.gainExp;
BattleManager.gainExp = function() {
    if(Check_GammaSync()) BM_VRS_BM_gainExp.call(this);
}
const BM_VRS_BM_ProcessWinRewardsGain = BattleManager.ProcessWinRewardsGain;
BattleManager.ProcessWinRewardsGain = function(){
    if(Check_GammaSync()) BM_VRS_BM_ProcessWinRewardsGain.call(this);
}

const SoR_VRS_BM_Terminate_BattleWinTerminater = BattleManager.BattleWinTerminater;
BattleManager.BattleWinTerminater = function() {//end
    if(!Check_GammaSync()){
        if(this.SuspendTerminate_ResultsShow()) return;
    }
    else this.BattleWinTerminater_GAMMA();

    SoR_VRS_BM_Terminate_BattleWinTerminater.call(this);
}

BattleManager.SuspendTerminate_ResultsShow = function() {
    if(this._victoryProcesses.length==0) return false;
    if(this._victoryProcesses[0].call(this) == false) this._victoryProcesses.shift();
    return true;
}

BattleManager.main_resultshow = function() {
    if(TouchInput.isTriggered() || Input.isTriggered("ok")){
        if(this._VictoryResult.allfinished()) return false; //terminate
        else if(!this._VictoryResult.canskip) this._VictoryResult.skiporder_allexp();
    }

    return true; //keep
}




//original levelup display
const SoR_VRS_GA_Terminate_displayLevelUp = Game_Actor.prototype.displayLevelUp;
Game_Actor.prototype.displayLevelUp = function(newSkills) {

    if(!Check_GammaSync()){
        if($gameParty.inBattle()){
            BattleManager.prepareBattleVictoryLvup(this, newSkills);
            return;
        }
    }
    else{
        if(BattleManager.results_onMap == true){
            BattleManager.prepareBattleVictoryLvup_GAMMA(this, newSkills);
            return;
        }
    }

    //regular levelup display
    SoR_VRS_GA_Terminate_displayLevelUp.call(this,...arguments);
}

BattleManager.prepareBattleVictoryLvup = function(actor, newSkls) {//suspended
    this._VictoryResult.pushLvup_items(actor, newSkls);
}

//////////////////////////////////////////////////
function Window_VictoryBattleLayout() {
    this.initialize(...arguments);
}

Window_VictoryBattleLayout.prototype.constructor = Window_VictoryBattleLayout;
Window_VictoryBattleLayout.prototype.initialize = function(rewards) {
    this.skiporder = false;
    this.canskip = false;
    this.window_resultMain = new Window_VictoryBattleResultsMain(new Rectangle(0,0,Graphics.width,Graphics.height),rewards);
    this.window_resultDrops = new Window_VictoryBattleResultsDrops(new Rectangle(-Graphics.width,128 + MainWindows_YPadd,Graphics.width*0.33,Graphics.height*0.5), rewards);
    this.window_actors = [];

    const nBM = ShowAllPartyMembers ? $gameParty.allMembers().length : $gameParty.battleMembers().length;
    for(let i=0; i<nBM; i++){
        this.window_actors.push(new Window_VictoryBattleActors(i, $gameParty.allMembers()[i]));
    }


    if(UseImages_ForContents && ImageFile_Header!="") this.result_header = new Sprite(ImageManager.loadBattleHudSprite(ImageFile_Header));
    else{
        this.result_header = new Window_Base(new Rectangle(0,0,Graphics.width,64));
        this.result_header.setBackgroundType(0);
        this.result_header.drawText(BattleResult_Headtext, 0, 0, this.result_header.width, "center");
    }


    ///////
    if(UseImages_ForContents && ImageFile_EXPHeader !=""){
      this.result_exp = new Sprite(ImageManager.loadBattleHudSprite(ImageFile_EXPHeader));
      this.result_exp.x = Graphics.width - this.result_exp.bitmap.width;
    }
    else{
        this.result_exp = new Window_VictoryMultipurpose(new Rectangle(0,0,Graphics.width,80));
        this.result_exp.setEXPDefault();
        this.result_exp.x = Graphics.width - 380 + 32;
    }
    this.result_exp.y = 96 + MainWindows_YPadd;



    if(UseImages_ForContents && ImageFile_ITEMHeader !="") this.result_items = new Sprite(ImageManager.loadBattleHudSprite(ImageFile_ITEMHeader));
    else{
        this.result_items = new Window_VictoryMultipurpose(new Rectangle(0,0,Graphics.width,80));
        this.result_items.setITEMsDefault();
    }
    this.result_items.x = 0;
    this.result_items.y = 96 + MainWindows_YPadd;



    this.windowElems = [];
    for(const x of this.window_actors) this.windowElems.push(x);
    this.windowElems.push(this.window_resultDrops);
    this.windowElems.push(this.window_resultMain);

    SceneManager._scene.addChild(this.result_exp);
    SceneManager._scene.addChild(this.result_items);
    SceneManager._scene.addChild(this.result_header);
}

Window_VictoryBattleLayout.prototype.pushLvup_items = function(actor, newSkls) {
    const idx = actor.indexALL();
    this.window_actors[idx].makeLevelUPtxt();
}

Game_Actor.prototype.indexALL = function() {
    return $gameParty.allMembers().indexOf(this);
}

Window_VictoryBattleLayout.prototype.skiporder_allexp = function() {
    let flag = false;

    this.skiporder = true;
    for(const x of this.window_actors){
       flag = x.skiporder() || flag;
    }

    this.canskip = !!flag;
}

Window_VictoryBattleLayout.prototype.allfinished = function() {
    return this.window_actors.every(x=> x.finished === true);
}

//////////////////////////////////////////////////
function Window_VictoryMultipurpose () {
    this.initialize(...arguments);
}
Window_VictoryMultipurpose.prototype = Object.create(Window_Base.prototype);
Window_VictoryMultipurpose.prototype.constructor = Window_VictoryMultipurpose;

Window_VictoryMultipurpose.prototype.initialize = function(rect) {
    Window_Base.prototype.initialize.call(this, rect);
}

Window_VictoryMultipurpose.prototype.setEXPDefault = function() {
    this.setBackgroundType(2);
    this.changeTextColor(ColorManager.textColor(14));
    this.DrawHorizonLine(0,26,360,6,TextColor_Rewards);
    this.drawText(WindowText_GetEXP, 0, 0, this.width, "left");
    this.resetTextColor();
}

Window_VictoryMultipurpose.prototype.setITEMsDefault = function() {
    this.setBackgroundType(2);
    this.changeTextColor(ColorManager.textColor(14));
    this.DrawHorizonLine(0,26,Graphics.width*0.33,6,TextColor_Rewards);
    this.drawText(WindowText_GetItem, 0, 0, this.width, "left");
    this.resetTextColor();
}

Window_VictoryMultipurpose.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}



//////////////////////////////////////////////////
function Window_VictoryBattleActors() {
    this.initialize(...arguments);
}

Window_VictoryBattleActors.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleActors.prototype.constructor = Window_VictoryBattleActors;

Window_VictoryBattleActors.prototype.initialize = function(i, actor) {
    //this.rewards = rewards;
    this.idx = i;
    this.act = actor;
    this.mainwidth = 380;  //Columns_BattleResultContents
    this.dispexpnum = 0;
    this.actual_expval = typeof this.act._IndividualExp != "undefined" ? this.act._IndividualExp : BattleManager._rewards.exp;
    this.expMeter_base = new Sprite(ImageManager.loadBattleHudSprite(ImageFile_GaugeBase));
    this.expMeter_top = new Sprite(ImageManager.loadBattleHudSprite(ImageFile_GaugeTop));
    this.show_lvup = false;
    this.skip_ordered = false;

    //ふっきんさん改造、獲得経験値をパーティーメンバー人数で割る
    this.actual_expval = Math.floor(this.actual_expval / $gameParty.battleMembers().length);

    console.log(this.act._IndividualExp,this.actual_expval,this.dispexpnum)
/*
    if(UseImages_ForContents){
        this.sprRewards_back = [];
        for(const x of ImageFile_Rewards) this.sprRewards_back.push(new Sprite(ImageManager.loadBattleHudSprite(x)));
        this.bmpRewards_digits = ImageManager.loadBattleHudSprite(ImageFile_Digits);
        this.sprRewards_digits = [];

        for(const x of this.sprRewards_back){
            x.visible = false;
            SceneManager._scene.addChild(x);
        }
    }
*/
    Window_Base.prototype.initialize.call(this, new Rectangle(Graphics.width - this.mainwidth + 32, 128 + MainWindows_YPadd + 78*i,this.mainwidth+12,88));
    this.setBackgroundType(1);
    this.refresh();
    this.open();

    this.expMeter_base.x = 132;
    this.expMeter_base.y = 22;
    this.expMeter_base.setFrame(0,0, this.expMeter_base.bitmap.width, this.expMeter_base.bitmap.height);
    this.expMeter_top.x = 132+GaugeTop_XPadd;
    this.expMeter_top.y = 22+GaugeTop_YPadd;
    this.addChild(this.expMeter_base);
    this.addChild(this.expMeter_top);
}



Window_VictoryBattleActors.prototype.refresh = function() {
   this.contents.clear();
   const idx = this.idx;
   this.contents.fontSize = 20;

   this.drawText(this.act._name, 0, 8, 140 , "left");
   this.contents.fontSize = 15;
   const lvtx = TextManager.levelA + " " + this.act.level;
   this.drawText(lvtx, 120, -10, 190 , "right");
   if(this.show_lvup) this.processLVUPtxt();

   this.contents.fontSize = 16;
   this.changeTextColor(ColorManager.textColor(3));
   this.drawText(TextManager.exp, 122, 25, 120 , "left");
   this.drawText(this.dispexpnum, 122, 25, 190 , "right");
   this.resetTextColor();

   if(this.act.isMaxLevel()) SetStatusMeter(this.expMeter_top,1,1,1);
   else {
       const cur = this.act.currentLevelExp();
       const nowexp = this.act.currentExp() - cur;
       const nextexp = this.act.nextLevelExp() - cur;
       SetStatusMeter(this.expMeter_top,nowexp,nextexp,1);
   }
   //this.changeTextColor(ColorManager.textColor(14));
   //this.DrawHorizonLine(px,py+30,360,8,'#c0c0c0');
   //this.drawText(this.dispitem[idx].name, px,py, 320 , "left");
   //this.resetTextColor();

   //const txt = this.dispnums[idx];
   //const dispnum =  this.dispitem[idx].exdig? txt.toFixed(2) : txt;

   //this.drawText(dispnum, px,py, 320, "right");
/*
    if(UseImages_ForContents){
        this.showbaseSprites();
        this.showitemDigits();
    }
    else{//normal
        this.contents.clear();
        this.contents.fontSize = 36;
        for(let i=0; i<this.NDispItems; i++) this.dispItem(i);
    }
*/
}

function SetStatusMeter(spr,val,valMax,color_type) {
	const wd = spr.bitmap.width;  // gauge_length x3
	const ht = spr.bitmap.height;
    const rate = wd *(val/valMax);
	spr.setFrame(0,0, rate, ht);
}

Window_VictoryBattleActors.prototype.update = function() {
    let isrequired = false;

    if(this.skip_ordered == false){
        const ret = CalcSlideStatusDiff(this.actual_expval,this.dispexpnum, false);
        if(this.dispexpnum != ret){
            isrequired = true;
            this.act.gainExp(ret-this.dispexpnum);
        }
        else this.finished = true;
        this.dispexpnum = ret;
    }
    else{
        const leftdiff = this.actual_expval - this.dispexpnum;
        isrequired = true;
        this.act.gainExp(leftdiff);
        this.skip_ordered = false;
        this.finished = true;
        this.dispexpnum = this.actual_expval;
    }

    if(isrequired == true) this.refresh();
}

Window_VictoryBattleActors.prototype.makeLevelUPtxt = function() {
    this.show_lvup = true;
    this.lvuptxt_paddy = 24;
    AudioManager.playSe(SE_Levelup);
}

Window_VictoryBattleActors.prototype.processLVUPtxt = function() {
    if(this.finished==true) this.lvuptxt_paddy = 0;

    this.changeTextColor(ColorManager.textColor(14));
    this.drawText(PopupText_LevelUP, 120, -10 + this.lvuptxt_paddy, 128 , "left");
    this.lvuptxt_paddy = this.lvuptxt_paddy > 0? this.lvuptxt_paddy-1 : 0;
}

Window_VictoryBattleActors.prototype.skiporder = function() {
    if(this.finished == true) return false;
    this.skip_ordered = true;
    return true;
}





//////////////////////////////////////////////////
function Window_VictoryBattleResultsMain() {
    this.initialize(...arguments);
}
Window_VictoryBattleResultsMain.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleResultsMain.prototype.constructor = Window_VictoryBattleResultsMain;

Window_VictoryBattleResultsMain.prototype.initialize = function(rect, rewards) {
    this.rewards = rewards;
    this.mainwidth = 380;  //Columns_BattleResultContents

    this.dispnums = [];
    this.dispitem = [];
    this.createRewardContents();
    this.NDispItems = this.dispitem.length;

    if(UseImages_ForContents){
        this.sprRewards_back = [];
        for(const x of ImageFile_Rewards) this.sprRewards_back.push(new Sprite(ImageManager.loadBattleHudSprite(x)));
        this.bmpRewards_digits = ImageManager.loadBattleHudSprite(ImageFile_Digits);
        this.sprRewards_digits = [];

        for(const x of this.sprRewards_back){
            x.visible = false;
            SceneManager._scene.addChild(x);
        }
    }

    Window_Base.prototype.initialize.call(this, rect);
    this.base = this.initialize_coordinatebase();
    this.setBackgroundType(2);
    this.refresh();
    this.open();
}


Window_VictoryBattleResultsMain.prototype.initialize_coordinatebase = function() {
    let px = 0, py = 600 + BattleResultContents_YPadd;
    return {x: px, y: py};
}

Window_VictoryBattleResultsMain.prototype.item_coordinateX = function(i,digit) {
    let px = i%2==0 ? 0 : Graphics.width-this.mainwidth-24; //this.base.x+16+(this.mainwidth+24)*idx;
    if(Columns_BattleResultContents == 1) px = 0;

    if(digit==true) px+=Digits_XPadd;
    return px;
}
Window_VictoryBattleResultsMain.prototype.item_coordinateY = function(i,digit) {
    let py = this.base.y + Math.floor(i/2) * 50;
    if(Columns_BattleResultContents == 1) py = this.base.y + i * 50;

    if(digit==true) py+=Digits_YPadd;
    return py;
}

Window_VictoryBattleResultsMain.prototype.createRewardContents = function(rect, rewards) {
    const ncont = ResultContents.length;
    for(const x of ResultContents){
        let value;
        switch(x.ContentsID){
            case 0:
                value = this.rewards.exp;
            break;
            case 1:
                value = this.rewards.gold;
            break;
            case 2:
                value = $gameTroop._turnCount;
            break;
            case 3:
                value = SoR_Eval(x.ContentScript);
            break;
        }
    this.dispitem.push({name: x.Name, val: value, exdig: x.DigitsExtension, unit: ""});
    this.dispnums.push(0);
    }
}

Window_VictoryBattleResultsMain.prototype.refresh = function() {
    if(UseImages_ForContents){
        this.showbaseSprites();
        this.showitemDigits();
    }
    else{//normal
        this.contents.clear();
        this.contents.fontSize = 24;
        for(let i=0; i<this.NDispItems; i++) this.dispItem(i);
    }
}

Window_VictoryBattleResultsMain.prototype.showbaseSprites = function() {
    if(this.sprRewards_back[0].visible == true) return;

    const nitems = this.NDispItems;
    for(let i=0; i<nitems; i++){
        item = this.sprRewards_back[i];
        item.visible = true;
        item.x = this.item_coordinateX(i,false);
        item.y = this.item_coordinateY(i,false);
    }
}

Window_VictoryBattleResultsMain.prototype.showitemDigits = function() {
    const nitems = this.NDispItems;

    if(this.sprRewards_digits.length!=0){
        for(let i=0; i<this.sprRewards_digits.length; i++){
            for(const n of this.sprRewards_digits[i]) SceneManager._scene.removeChild(n);
        }
    }

    for(let i=0; i<nitems; i++){
        this.sprRewards_digits[i] = LoadDivNumbersFromImage(this.bmpRewards_digits, this.dispnums[i],this.item_coordinateX(i,true),this.item_coordinateY(i,true), this.dispitem[i].exdig);
        for(const n of this.sprRewards_digits[i]) SceneManager._scene.addChild(n);
    }
}

function LoadDivNumbersFromImage(bmp, param, baseX, baseY, exdig){
	const obj_arr = [];
	const Numimg = bmp;
	const wd = Numimg.width / DigitImageFormat;
	const ht = Numimg.height;

    let numarr;
    if(exdig){
        numarr = param.toFixed(2).split("");
        if(param>=0.0) numarr.unshift("+");
    }
    else if(isNaN(param)) numarr = param.split("");
	else numarr = Math.abs(param).toString().split("");//split status

	for (let i = 0; i < numarr.length; i++) {
		let ndigit;
        if(DigitImageFormat==16){
            if(numarr[i] == "+") ndigit = 10;
            else if(numarr[i] == "-") ndigit = 11;
            else if(numarr[i] == ".") ndigit = 12;
            else if(numarr[i] == ":") ndigit = 13;
            else if(numarr[i] == "/") ndigit = 14;
            else if(numarr[i] == "*") ndigit = 15;
            else ndigit = Number(numarr[i]);
        }
        else ndigit = Number(numarr[i]);

		obj_arr[i] = new Sprite(Numimg);
		obj_arr[i].setFrame(ndigit * wd, 0, wd, ht);
        obj_arr[i].x = baseX + (i*(wd+Digits_AlignWidth)) - Math.floor(((numarr.length-1) * (wd+Digits_AlignWidth)));
        obj_arr[i].y = baseY;
		obj_arr[i].anchor.x = 0.5;
		obj_arr[i].anchor.y = 0.5;
		obj_arr[i].scale.x = 1.0;
		obj_arr[i].scale.y = 1.0;
		obj_arr[i].wd = wd; //width one digit
	}

	return obj_arr;
}


/////////////////////////////////////////////////////
Window_VictoryBattleResultsMain.prototype.dispItem = function(idx) {
   const px = this.item_coordinateX(idx,false);
   const py = this.item_coordinateY(idx,false);

   this.changeTextColor(ColorManager.textColor(14));
   this.DrawHorizonLine(px,py+30,250,8,TextColor_Rewards);
   this.drawText(this.dispitem[idx].name, px,py, 380 , "left");
   this.resetTextColor();

   const txt = this.dispnums[idx];
   const dispnum =  this.dispitem[idx].exdig? txt.toFixed(2) : txt;

   this.drawText(dispnum, px,py, 220, "right");
}

Window_VictoryBattleResultsMain.prototype.update = function() {
    let isrequired = false;

    for(let i=0; i<this.NDispItems; i++){

        if(isNaN(this.dispitem[i].val)) this.dispnums[i] = this.dispitem[i].val;
        else{
            const ret = CalcSlideStatusDiff(this.dispitem[i].val,this.dispnums[i], this.dispitem[i].exdig);
            if(this.dispnums[i] != ret) isrequired = true;
            this.dispnums[i] = ret;
        }
    }

    if(isrequired == true) this.refresh();
}

function CalcSlideStatusDiff(param, disp, exflag){
	if(param == disp) return disp;
	const diff = disp-param;
    if(exflag && Math.abs(diff)<0.0001) return disp;
    const spd = exflag ? 0.06 : 1 + Math.abs(diff)/32.0;

	if(diff>0){
	    disp-=spd;
		if(disp < param) disp = param;
	}
	else{
	    disp+=spd;
		if(disp > param) disp = param;
    }

	return exflag ? disp : Math.floor(disp);
}


Window_VictoryBattleResultsMain.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}

Bitmap.prototype.FillRoundedRect = function(x, y, width, height, radius, color) {
    var context = this._context;
    var pi = Math.PI;
    context.save();
    context.fillStyle = color;
    context.beginPath();
    context.arc(x + radius, y + radius, radius, -pi, -0.5 * pi, false);
    context.arc(x + width - radius, y + radius, radius, -0.5 * pi, 0, false);
    context.arc(x + width - radius, y + height - radius, radius, 0, 0.5 * pi, false);
    context.arc(x + radius, y + height - radius, radius, 0.5 * pi, pi, false);
    context.fill();
    context.restore();
}




//////////////////////////////////////////////////
function Window_VictoryBattleResultsDrops() {
    this.initialize(...arguments);
}
Window_VictoryBattleResultsDrops.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleResultsDrops.prototype.constructor = Window_VictoryBattleResultsDrops;

Window_VictoryBattleResultsDrops.prototype.initialize = function(rect,rewards) {
    this.items = rewards.items;
    this.itemsNumArr = [];
    this.checkDuplicate();
    this.nitem = this.items.length;
    const nL = this.nitem;
    //rect.height = this.fittingHeight(nL);
    Window_Base.prototype.initialize.call(this, rect);

    this.setBackgroundType(1);
    this.open();
    this.refresh();
}

Window_VictoryBattleResultsDrops.prototype.checkDuplicate = function() {
    for(let i=0; i<this.items.length; i++){
        const cand = this.items[i];
        this.itemsNumArr[i] = 1;
        for(let j=i+1; j<this.items.length; j++){
            const test = this.items[j];
            if(cand.id == test.id){
                if(cand.itypeId){
                    if(test.itypeId && cand.itypeId == test.itypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
                else if(cand.atypeId){
                    if(test.atypeId && cand.atypeId == test.atypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
                else if(cand.wtypeId){
                    if(test.wtypeId && cand.wtypeId == test.wtypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
            }
        }
    }
}

Window_VictoryBattleResultsDrops.prototype.update = function() {
    if(this.x<0) this.x -= (this.x/2-1);
    else this.x = 0;
}


Window_VictoryBattleResultsDrops.prototype.refresh = function() {
   this.contents.clear();
/*
   this.contents.fontSize = 18;
   this.changeTextColor(ColorManager.textColor(14));
   this.DrawHorizonLine(4,18,240,3,'#c0c0c0');
   this.drawText(WindowText_GetItem, 16,-5, 240,"left");
*/

   this.contents.fontSize = 20;
   if(this.nitem==0){
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(WindowText_NoGetItem, 15, 12, Graphics.boxWidth/3);
   }
   for(let i=0; i<this.nitem; i++) this.dispItem(i);
   //AudioManager.playSe(SE_ItemWindow);
}

Window_VictoryBattleResultsDrops.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}

Window_VictoryBattleResultsDrops.prototype.dispItem = function(index) {
    const item = this.items[index];
    const numberWidth = this.numberWidth();
    const textMargin = ImageManager.iconWidth + 4;
    const itemWidth = Math.max(0, this.itemWidth() - textMargin);
    const rect = this.itemLineRect(index);
    this.drawItemName(item, rect.x, rect.y+12, rect.width - numberWidth - 8);
    //if(this.itemsNumArr[index]>=2)
    this.drawItemNumber(this.itemsNumArr[index], rect.x, rect.y+12, rect.width);
}

Window_VictoryBattleResultsDrops.prototype.drawItemNumber = function(tx, x, y, width) {
    this.drawText("x", x, y, 8+ width - this.textWidth("00"), "right");
    this.drawText(tx, x, y, 8+ width, "right");
}

Window_VictoryBattleResultsDrops.prototype.itemLineRect = function(index) {
    const rect = this.itemRectWithPadding(index);
    const padding = (rect.height - this.lineHeight()) / 2;
    rect.y += padding;
    rect.height -= padding * 2;
    return rect;
}

Window_VictoryBattleResultsDrops.prototype.itemRectWithPadding = function(index) {
    const rect = this.itemRect(index);
    const padding = this.itemPadding();
    rect.x += padding;
    rect.width -= padding * 2;
    return rect;
}

Window_VictoryBattleResultsDrops.prototype.itemRect = function(index) {
    const maxCols = this.maxCols();
    const itemWidth = this.itemWidth();
    const itemHeight = this.itemHeight();
    const colSpacing = 8;
    const rowSpacing = 4;
    const col = index % maxCols;
    const row = Math.floor(index / maxCols);
    const x = col * itemWidth + colSpacing / 2;
    const y = row * itemHeight + rowSpacing / 2;
    const width = itemWidth - colSpacing;
    const height = itemHeight - rowSpacing;
    return new Rectangle(x, y, width, height);
}

Window_VictoryBattleResultsDrops.prototype.numberWidth = function() { return this.textWidth("000"); }
Window_VictoryBattleResultsDrops.prototype.maxCols = function() { return 1; }
Window_VictoryBattleResultsDrops.prototype.itemWidth = function() { return this.width-24;}
Window_VictoryBattleResultsDrops.prototype.itemHeight = function() { return 36;}


/////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)();

    return res;
}
})();
