//=============================================================================
// SoR_VictoryResultScene_MZ_Alpha.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.12 (2021/07/16)
//=============================================================================
/*:ja
@plugindesc ＜戦闘勝利シーンα＞ v1.12
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@orderAfter SoR_BattleTeminationRefactor_MZ
@orderBefore SoR_VictoryPerformance_MZ
@base SoR_BattleTeminationRefactor_MZ
@help ※要 57.「戦闘終了処理ルーチン細分化」(SoR_BattleTeminationRefactor_MZ.js)

戦闘勝利後の戦闘結果表示演出を変更します。
スタイルによってスクリプトを分けています。戦闘勝利シーンβとは共用できません。
(γとはγ側のプラグインコマンドによる切り替えで両立します)
@param --基本--
@param WindowText_GetItem
@desc 取得アイテム欄見出しテキスト
@default Get Item
@type string
@param WindowText_NoGetItem
@desc 取得アイテム無し時のアイテム欄内表示テキスト
@default No Item
@type string

@param WindowBasePosition_Ypadd
@desc 取得アイテム・スキル習得表示ウィンドウy座標補正
@default 0
@type number

@param Duration_BattleResultScene
@desc リザルト画面が自動で終了するまでの(フレーム)時間
@default 600
@type number
@param Key_SuspendTermination
@desc 押し続けにより戦闘勝利シーンを終了させないキー
@default control
@type string

@param PopupText_LevelUP
@desc レベルアップ時のポップアップ表示テキスト
@default No Item
@type Level Up!

@param Columns_BattleResultContents
@desc 画面上部・報酬項目を表示する列数
@type select
@option 1列
@value 1
@option 2列
@value 2
@option 3列(※要ツクールデフォルト画面サイズでは不可)
@value 3
@default 1

@param TextColor_Rewards
@desc 報酬名テキスト描画カラー
@default #c0c0c0
@type string

@param ResultContents
@desc 画面上部・報酬項目
@type struct<ResultContents>[]
@default ["{\"Name\":\"EXP\",\"ContentsID\":\"0\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"GOLD\",\"ContentsID\":\"1\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}"]
@param --画像関係--
@param UseImages_ForContents
@desc true: 獲得経験値・金などの表示を画像UIで構成する。falseの場合以下無効 (default: false)
@default false
@type boolean
@param ImageFile_Rewards
@desc 各報酬用背景画像。背景＋項目テキスト入りを想定(ResultContentsの登録順に対応)
@type file[]
@default [""]
@dir img/SoRBatHUD/

@param ImageFile_Digits
@desc 数値画像
@type file
@dir img/SoRBatHUD/
@param DigitImageFormat
@desc 数値画像の形式
@type select
@option 通常(0123456789)
@value 10
@option 記号拡張(0123456789+-.:/*)
@value 16
@default 10

@param Digits_XPadd
@desc 数値描画位置x方向補正
@default 0
@type number
@param Digits_YPadd
@desc 数値描画位置y方向補正
@default 0
@type number
@param Digits_AlignWidth
@desc 数値の桁と桁の描画間隔補正(default: -2)
@default -2
@type number
@min -9999

@param --音関係--
@param SE_Levelup
@desc アクターレベルアップ時の効果音
@type struct<SEDATA>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
@param SE_ItemWindow
@desc 取得アイテムウィンドウ出現時の効果音
@type struct<SEDATA>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
@param SE_SkillLearned
@desc スキル習得等表示ウィンドウ出現時の効果音
@type struct<SEDATA>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
*/
/*~struct~SEDATA:
@type string
@param name
@dir audio/se/
@type file
@desc 効果音
@param volume
@desc 音量 [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc ピッチ [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc パン(位相) [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~ResultContents:
@param Name
@desc 表示するゲームデータに対応する表記名称。画像利用時は無効
@type string
@param ContentsID
@desc 表示ゲームデータ
@type select
@option 経験値
@value 0
@option お金
@value 1
@option ターン数
@value 2
@option 任意のスクリプト命令(ContentScriptに記述)
@value 3
@default 0
@param ContentScript
@desc 表示する特定ゲームデータ
@type string
@param DigitsExtension
@desc 値表示に記号部分が必要な項目の場合にtrueにする
@type boolean
@default false
*/
/*:
@plugindesc <Battle Result Scene - Alpha> v1.12
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@orderAfter SoR_BattleTeminationRefactor_MZ
@orderBefore SoR_VictoryPerformance_MZ
@base SoR_BattleTeminationRefactor_MZ
@help [Prerequisite] 57. SoR_BattleTeminationRefactor_MZ

This plugin replaces the battle result show as
a pseudo result scene inspired by "Tales of" series.

This is Type-Alpha ("Tales of" style), which cannot work with Type-Beta,
but compatible with Type-Gamma by switching the flag
via the plugin command in Gamma.
@param --General--
@param WindowText_GetItem
@desc Header text for obtained item window
@default Get Item
@type string
@param WindowText_NoGetItem
@desc Text in the obtained item window which indicates no obtained items
@default No Item
@type string

@param WindowBasePosition_Ypadd
@desc Padding of the obtained item window for y-coordinate
@default 0
@type number

@param Duration_BattleResultScene
@desc Duration (frames) of battle result scene. Battles end automatically after this time.
@default 600
@type number
@param Key_SuspendTermination
@desc A key to suspend the result by holding down.
@default control
@type string

@param PopupText_LevelUP
@desc A text shown above the SV_Actor which indicates level up
@default Level Up!
@type string

@param Columns_BattleResultContents
@desc Number of columns showing battle rewards
@type select
@option 1
@value 1
@option 2
@value 2
@option 3 (Must expand the screen size)
@value 3
@default 1

@param TextColor_Rewards
@desc Text color for the name of each reward
@default #c0c0c0
@type string

@param ResultContents
@desc Setting of rewards shown upper of the screen. List one by one.
@type struct<ResultContentsE>[]
@default ["{\"Name\":\"EXP\",\"ContentsID\":\"0\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}","{\"Name\":\"GOLD\",\"ContentsID\":\"1\",\"ContentScript\":\"\",\"DigitsExtension\":\"false\"}"]
@param --Original Images--
@param UseImages_ForContents
@desc IF true, result contents are composed by original images. (default: false)
@default false
@type boolean
@param ImageFile_Rewards
@desc Images for each reward item in the contents. (Corresponding to the order in ResultContents)
@type file[]
@default [""]
@dir img/SoRBatHUD/

@param ImageFile_Digits
@desc Image of digits aligned in a row
@type file
@dir img/SoRBatHUD/
@param DigitImageFormat
@desc Format of digits
@type select
@option Regular (0123456789)
@value 10
@option Extended (0123456789+-.:/*)
@value 16
@default 10

@param Digits_XPadd
@desc Padding of values corresponding to the reward item for x-coordinate
@default 0
@type number
@param Digits_YPadd
@desc Padding of values corresponding to the reward item for y-coordinate
@default 0
@type number
@param Digits_AlignWidth
@desc Correction of span among each digit image (default: -2)
@default -2
@type number
@min -9999

@param --Sounds--
@param SE_Levelup
@desc SE playes at level up of each actor
@type struct<SEDATAE>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
@param SE_ItemWindow
@desc SE playes when the obtained item window appears
@type struct<SEDATAE>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
@param SE_SkillLearned
@desc SE playes when the skill obtained indicator appears
@type struct<SEDATAE>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}
*/
/*~struct~SEDATAE:
@type string
@param name
@dir audio/se/
@type file
@desc SE File
@param volume
@desc Voulme [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc Pitch [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc Pan [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~ResultContentsE:
@param Name
@desc Title text which corresponds to the game data which will be shown. This is ignored if the image is used.
@type string
@param ContentsID
@desc Target game data
@type select
@option EXP
@value 0
@option Gold
@value 1
@option Number of Turns
@value 2
@option Arbitrary script (Fill in ContentScript)
@value 3
@default 0
@param ContentScript
@desc Target game data via script
@type string
@param DigitsExtension
@desc Set true if you require extended signs for the target value.
@type boolean
@default false
*/

(function() {
const pluginName = "SoR_VictoryResultScene_MZ_Alpha";
const Param = PluginManager.parameters(pluginName);

if(!PluginManager._scripts.includes("SoR_BattleTeminationRefactor_MZ")) throw new Error("[SoR_VictoryResultScene_MZ_Alpha] This plugin REQUIRES SoR_BattleTeminationRefactor_MZ.");
if(PluginManager._scripts.includes("SoR_VictoryResultScene_MZ_Beta")) throw new Error("[SoR_VictoryResultScene_MZ_Alpha] Do not use this plugin with SoR_VictoryResultScene_MZ_Beta.");

let Synchronize_Gamma;
if(PluginManager._scripts.includes("SoR_VictoryResultScene_MZ_Gamma")) Synchronize_Gamma = true;


const WindowText_GetItem = String(Param['WindowText_GetItem']) || '';
const WindowText_NoGetItem = String(Param['WindowText_NoGetItem']) || '';
const WindowBasePosition_Ypadd = Number(Param['WindowBasePosition_Ypadd']) || 0;
const Duration_BattleResultScene = Number(Param['Duration_BattleResultScene']) || 0;
const Columns_BattleResultContents = Number(Param['Columns_BattleResultContents']) || 0;
const ResultContents = convertJsonParams(Param['ResultContents']);

const PopupText_LevelUP = String(Param['PopupText_LevelUP']) || '';
const TextColor_Rewards = String(Param['TextColor_Rewards']) || '';
const Key_SuspendTermination = String(Param['Key_SuspendTermination']) || '';

const UseImages_ForContents = Boolean(Param['UseImages_ForContents'] === 'true' || false);
const ImageFile_Rewards = convertJsonStrs(Param['ImageFile_Rewards']);
const ImageFile_Digits = String(Param['ImageFile_Digits']) || '';
const DigitImageFormat = Number(Param['DigitImageFormat']) || 10;
const Digits_XPadd = Number(Param['Digits_XPadd']) || 0;
const Digits_YPadd = Number(Param['Digits_YPadd']) || 0;
const Digits_AlignWidth = Number(Param['Digits_AlignWidth']) || 0;


const SE_Levelup = convertJsonStruct(Param['SE_Levelup']);
const SE_ItemWindow = convertJsonStruct(Param['SE_ItemWindow']);
const SE_SkillLearned = convertJsonStruct(Param['SE_SkillLearned']);


function convertJsonParams(param) {
    if (param == undefined) return [];
    let arr = [];
        JSON.parse(param).map(function(param) {
            const obj = JSON.parse(param);
            obj.ContentsID = Number(obj.ContentsID);
            obj.DigitsExtension = obj.DigitsExtension==="true"? true: false;
            arr.push(obj);
        });
    return arr;
}

function convertJsonStruct(param) {
    const obj = JSON.parse(param);
    obj.volume = Number(obj.volume);
    obj.pan = Number(obj.pan);
    obj.pitch = Number(obj.pitch);
    return obj;
}

function convertJsonStrs(param) {
	if (param == undefined) return [];
	let arr = [];
		JSON.parse(param).map(function(param) {
			arr.push(param);
		});
	return arr; 
}

ImageManager.loadBattleHudSprite = function(filename) {
    return this.loadBitmap('img/SoRBatHUD/', filename, 0, true);
}
///////////////////////////////////////////////////////////////////////////////

function Check_GammaSync(){
    if(!Synchronize_Gamma) return false;
    if(typeof $gameSystem._UseNormalBattleResult === "undefined") $gameSystem._UseNormalBattleResult = false;
    if(Synchronize_Gamma && $gameSystem._UseNormalBattleResult == false) return true;
    return false;
}
///////////////////////////////////////////////////////////////////////////////

const SoR_VRS_BM_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
    SoR_VRS_BM_initMembers.call(this);
    this._VictoryResult = null;
    for(const x of ImageFile_Rewards) ImageManager.loadBattleHudSprite(x);
    ImageManager.loadBattleHudSprite(ImageFile_Digits);
    this._victoryProcesses = [this.main_resultshow];
}

const SoR_VRS_BM_ProcessWinSounds = BattleManager.ProcessWinSounds;
BattleManager.ProcessWinSounds = function(){//sound
    if(this._VictoryResult == null) SoR_VRS_BM_ProcessWinSounds.call(this);
}

BattleManager.ProcessWinMessage = function(){//winmes,rewards
    if(Check_GammaSync()) return;
    if( this._VictoryResult == null){
        this.makeRewards();
        this.FinalizeBattleRewards();
        this._VictoryResult = new Window_VictoryBattleLayout(this._rewards);
        for(const w of this._VictoryResult.windowElems) SceneManager._scene.addChild(w);
        this.gainRewards();
    }
}

const BM_VRS_BM_PrepareBattleRewards = BattleManager.PrepareBattleRewards;
BattleManager.PrepareBattleRewards = function(){
    if(Check_GammaSync()) BM_VRS_BM_PrepareBattleRewards.call(this);
}
const BM_VRS_BM_ProcessWinRewards = BattleManager.ProcessWinRewards;
BattleManager.ProcessWinRewards = function(){
    if(Check_GammaSync()) BM_VRS_BM_ProcessWinRewards.call(this);
}
const BM_VRS_BM_ProcessWinRewardsGain = BattleManager.ProcessWinRewardsGain;
BattleManager.ProcessWinRewardsGain = function(){
    if(Check_GammaSync()) BM_VRS_BM_ProcessWinRewardsGain.call(this);
}

const SoR_VRS_BM_Terminate_BattleWinTerminater = BattleManager.BattleWinTerminater;
BattleManager.BattleWinTerminater = function() {//end
    if(!Check_GammaSync()){
        if(this.SuspendTerminate_ResultsShow()) return;
    }
    else this.BattleWinTerminater_GAMMA();

    SoR_VRS_BM_Terminate_BattleWinTerminater.call(this);
}

BattleManager.SuspendTerminate_ResultsShow = function() {
    if(this._victoryProcesses.length==0) return false;
    if(this._victoryProcesses[0].call(this) == false) this._victoryProcesses.shift();
    return true;
}


BattleManager.main_resultshow = function() {
    if(this._VictoryResult.duration < Duration_BattleResultScene*0.9){
        if(this._VictoryResult.RemainLVUPstacks()){
            const nw = this._VictoryResult.createNewLVUPindicator();
            SceneManager._scene.addChild(this._VictoryResult.windowLVUPElems[0]);
            for(let i=1; i<nw; i++) this._VictoryResult.windowLVUPElems[i].setNewOrderID(i);
        }
        else if(this._VictoryResult.lvstack_duration>0) this._VictoryResult.lvstack_duration--;

        if(TouchInput.isTriggered() || Input.isTriggered("ok")) this._VictoryResult.canskip = true;
    }

    if(!this._VictoryResult.canskip && (this._VictoryResult.duration>=1)){
        this._VictoryResult.duration--;
        return true;
    }

    if(!this._VictoryResult.canskip && this._VictoryResult.StillLVUPstacks()) return true;
    if(Input.isPressed(Key_SuspendTermination)) return true;

    return false;
}




//original levelup display
const SoR_VRS_GA_Terminate_displayLevelUp = Game_Actor.prototype.displayLevelUp;
Game_Actor.prototype.displayLevelUp = function(newSkills) {
    if(!Check_GammaSync()){
        if($gameParty.inBattle()){
            const texts = {btl: this._sprite(), actor: this._name, lvtx: TextManager.level, newlv: this._level};
            BattleManager.prepareBattleVictoryLvup(texts, newSkills);
            return;
        }
    }
    else{
        if(BattleManager.results_onMap == true){
            BattleManager.prepareBattleVictoryLvup_GAMMA(this, newSkills);
            return;
        }
    }

    //regular levelup display
    SoR_VRS_GA_Terminate_displayLevelUp.call(this,...arguments);
}

BattleManager.prepareBattleVictoryLvup = function(texts, newSkls) {//suspended
    this._VictoryResult.pushLvup_items(texts, newSkls);
}

//map: battler object -> battler sprite
Game_Battler.prototype._sprite = function() {
    if(BattleManager._spriteset!=null) return BattleManager._spriteset.findTargetSprite(this);
    return null;
}






//////////////////////////////////////////////////
function Window_VictoryBattleLayout() {
    this.initialize(...arguments);
}

Window_VictoryBattleLayout.prototype.constructor = Window_VictoryBattleLayout;
Window_VictoryBattleLayout.prototype.initialize = function(rewards) {
    this.canskip = false;
    this.duration = Duration_BattleResultScene;
    this.window_resultMain = new Window_VictoryBattleResultsMain(new Rectangle(0,0,Graphics.width,Graphics.height/2),rewards);
    this.window_resultDrops = new Window_VictoryBattleResultsDrops(new Rectangle(-Graphics.width,Graphics.height*0.75+WindowBasePosition_Ypadd,Graphics.width,Graphics.height/2), rewards);

    this.windowElems = [this.window_resultMain, this.window_resultDrops];
    this.lvuptexts_Stack = [];
    this.windowLVUPElems = [];
    this.lvstack_duration = 0;
}

Window_VictoryBattleLayout.prototype.pushLvup_items = function(texts, newSkls) { 
    if(texts.btl!=null && texts.btl.parent !=null) texts.btl.createVRS_lvupSprite();

    for(x of newSkls){
        const tx = "\\c[14]" + texts.actor + "\\c[0]" + " : " +"\\i[" + x.iconIndex + "]" + " " + "\\c[14]" + x.name + "\\c[0] " + TextManager.obtainSkill.format();
        this.lvuptexts_Stack.push(tx);
    }
}

Window_VictoryBattleLayout.prototype.RemainLVUPstacks = function() {
    return (this.lvstack_duration==0 && this.lvuptexts_Stack.length > 0);
}

Window_VictoryBattleLayout.prototype.StillLVUPstacks = function() {
    return (this.lvstack_duration>=1 || this.lvuptexts_Stack.length > 0);
}

Window_VictoryBattleLayout.prototype.createNewLVUPindicator = function() {
    const tx = this.lvuptexts_Stack.shift();
    const eid = this.windowLVUPElems.length;
    this.windowLVUPElems.unshift(new Window_VictoryBattleResultsLVUP(new Rectangle(-Graphics.width,Graphics.height*0.75+WindowBasePosition_Ypadd,Graphics.width,Graphics.height/2), tx));
    AudioManager.playSe(SE_SkillLearned);
    this.lvstack_duration = 90;
    return this.windowLVUPElems.length;
}

/////
Sprite_Battler.prototype.createVRS_lvupSprite = function() {
    if(!this._battler.isSpriteVisible()) return;

    const sprite = new Sprite_Damage();
    sprite.createVRS_lvup();

    sprite.x = this.x;
    sprite.y = this.y;

    this._damages.push(sprite);
    this.parent.addChild(sprite);        
    AudioManager.playSe(SE_Levelup);
}

Sprite_Damage.prototype.createVRS_lvup = function() {
    const h = this.fontSize()*1.5;
    const w = 144;
    const sprite = this.createChildSprite(w, h);
    sprite.bitmap.drawText(PopupText_LevelUP, 0, 0, w, h, "center");
    sprite.dy = 0.01;
    this.setupCriticalEffect();
    this._duration = 300;
}

//////////////////////////////////////////////////
function Window_VictoryBattleResultsMain() {
    this.initialize(...arguments);
}
Window_VictoryBattleResultsMain.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleResultsMain.prototype.constructor = Window_VictoryBattleResultsMain;

Window_VictoryBattleResultsMain.prototype.initialize = function(rect, rewards) {
    this.rewards = rewards;
    this.mainwidth = 380;  //Columns_BattleResultContents
    this.base = this.initialize_coordinatebase()
    this.dispnums = [];
    this.dispitem = [];
    this.createRewardContents();
    this.NDispItems = this.dispitem.length;

    if(UseImages_ForContents){
        this.sprRewards_back = [];
        for(const x of ImageFile_Rewards) this.sprRewards_back.push(new Sprite(ImageManager.loadBattleHudSprite(x)));
        this.bmpRewards_digits = ImageManager.loadBattleHudSprite(ImageFile_Digits);
        this.sprRewards_digits = [];

        for(const x of this.sprRewards_back){
            x.visible = false;
            SceneManager._scene.addChild(x);
        }
    }

    Window_Base.prototype.initialize.call(this, rect);
    this.setBackgroundType(2);
    this.refresh();
    this.open();
}


Window_VictoryBattleResultsMain.prototype.initialize_coordinatebase = function() {
    let px, py = 108;
    const span = Columns_BattleResultContents-1;
    px = (Graphics.boxWidth-(this.mainwidth*Columns_BattleResultContents + span*24))/2;
    return {x: px, y: py};
}

Window_VictoryBattleResultsMain.prototype.item_coordinateX = function(i,digit) {
    const idx = i%Columns_BattleResultContents;
    let px = this.base.x+16+(this.mainwidth+24)*idx;
    if(digit==true) px+=Digits_XPadd;
    return px;
}
Window_VictoryBattleResultsMain.prototype.item_coordinateY = function(i,digit) {
    const idx = Math.floor(i/Columns_BattleResultContents);
    let py = this.base.y+(48+2)*idx;
    if(digit==true) py+=Digits_YPadd;
    return py;
}




Window_VictoryBattleResultsMain.prototype.createRewardContents = function(rect, rewards) {
    const ncont = ResultContents.length;
    for(const x of ResultContents){
        let value;
        switch(x.ContentsID){
            case 0:
                value = this.rewards.exp;
            break;
            case 1:
                value = this.rewards.gold;
            break;
            case 2:
                value = $gameTroop._turnCount;
            break;
            case 3:
                value = SoR_Eval(x.ContentScript);
            break;
        }
    this.dispitem.push({name: x.Name, val: value, exdig: x.DigitsExtension, unit: ""});
    this.dispnums.push(0);
    }
}


Window_VictoryBattleResultsMain.prototype.refresh = function() {
    if(UseImages_ForContents){
        this.showbaseSprites();
        this.showitemDigits();
    }
    else{//normal
        this.contents.clear();
        this.contents.fontSize = 36;
        for(let i=0; i<this.NDispItems; i++) this.dispItem(i);
    }
}

Window_VictoryBattleResultsMain.prototype.showbaseSprites = function() {
    if(this.sprRewards_back[0].visible == true) return;

    const nitems = this.NDispItems;
    for(let i=0; i<nitems; i++){
        item = this.sprRewards_back[i];
        item.visible = true;
        item.x = this.item_coordinateX(i,false);
        item.y = this.item_coordinateY(i,false);
    }
}

Window_VictoryBattleResultsMain.prototype.showitemDigits = function() {
    const nitems = this.NDispItems;

    if(this.sprRewards_digits.length!=0){
        for(let i=0; i<this.sprRewards_digits.length; i++){
            for(const n of this.sprRewards_digits[i]) SceneManager._scene.removeChild(n);
        }
    }

    for(let i=0; i<nitems; i++){
        this.sprRewards_digits[i] = LoadDivNumbersFromImage(this.bmpRewards_digits, this.dispnums[i],this.item_coordinateX(i,true),this.item_coordinateY(i,true), this.dispitem[i].exdig);
        for(const n of this.sprRewards_digits[i]) SceneManager._scene.addChild(n);
    }
}

function LoadDivNumbersFromImage(bmp, param, baseX, baseY, exdig){
	const obj_arr = [];
	const Numimg = bmp;
	const wd = Numimg.width / DigitImageFormat;
	const ht = Numimg.height;
	
    let numarr;
    if(exdig){ 
        numarr = param.toFixed(2).split("");
        if(param>=0.0) numarr.unshift("+");
    }
    else if(isNaN(param)) numarr = param.split("");
	else numarr = Math.abs(param).toString().split("");//split status

	for (let i = 0; i < numarr.length; i++) {
		let ndigit;
        if(DigitImageFormat==16){
            if(numarr[i] == "+") ndigit = 10;
            else if(numarr[i] == "-") ndigit = 11;
            else if(numarr[i] == ".") ndigit = 12;
            else if(numarr[i] == ":") ndigit = 13;
            else if(numarr[i] == "/") ndigit = 14;
            else if(numarr[i] == "*") ndigit = 15;
            else ndigit = Number(numarr[i]);
        }
        else ndigit = Number(numarr[i]);

		obj_arr[i] = new Sprite(Numimg);
		obj_arr[i].setFrame(ndigit * wd, 0, wd, ht);
        obj_arr[i].x = baseX + (i*(wd+Digits_AlignWidth)) - Math.floor(((numarr.length-1) * (wd+Digits_AlignWidth))); 
        obj_arr[i].y = baseY;
		obj_arr[i].anchor.x = 0.5;
		obj_arr[i].anchor.y = 0.5;
		obj_arr[i].scale.x = 1.0;
		obj_arr[i].scale.y = 1.0;
		obj_arr[i].wd = wd; //width one digit
	}
	
	return obj_arr;
}
 

/////////////////////////////////////////////////////

Window_VictoryBattleResultsMain.prototype.dispItem = function(idx) {
   const px = this.item_coordinateX(idx,false);
   const py = this.item_coordinateY(idx,false);

   this.changeTextColor(ColorManager.textColor(14));
   this.DrawHorizonLine(px,py+30,360,8, TextColor_Rewards);
   this.drawText(this.dispitem[idx].name, px,py, 320 , "left");
   this.resetTextColor();

   const txt = this.dispnums[idx];
   const dispnum =  this.dispitem[idx].exdig? txt.toFixed(2) : txt;

   this.drawText(dispnum, px,py, 320, "right");
}

Window_VictoryBattleResultsMain.prototype.update = function() {
    let isrequired = false;

    for(let i=0; i<this.NDispItems; i++){

        if(isNaN(this.dispitem[i].val)) this.dispnums[i] = this.dispitem[i].val;
        else{
            const ret = CalcSlideStatusDiff(this.dispitem[i].val,this.dispnums[i], this.dispitem[i].exdig);
            if(this.dispnums[i] != ret) isrequired = true;
            this.dispnums[i] = ret;
        }
    }

    if(isrequired == true) this.refresh();
}

function CalcSlideStatusDiff(param, disp, exflag){
	if(param == disp) return disp;
	const diff = disp-param;
    if(exflag && Math.abs(diff)<0.0001) return disp;
    const spd = exflag ? 0.07 : 1 + Math.abs(diff)/5;

	if(diff>0){
	    disp-=spd;
		if(disp < param) disp = param;
	}
	else{
	    disp+=spd;
		if(disp > param) disp = param;
    }

	return exflag ? disp : Math.floor(disp);
}


Window_VictoryBattleResultsMain.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity 
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}

Bitmap.prototype.FillRoundedRect = function(x, y, width, height, radius, color) {
    var context = this._context;
    var pi = Math.PI;
    context.save();
    context.fillStyle = color;
    context.beginPath();
    context.arc(x + radius, y + radius, radius, -pi, -0.5 * pi, false);
    context.arc(x + width - radius, y + radius, radius, -0.5 * pi, 0, false);
    context.arc(x + width - radius, y + height - radius, radius, 0, 0.5 * pi, false);
    context.arc(x + radius, y + height - radius, radius, 0.5 * pi, pi, false);
    context.fill();
    context.restore();
}




//////////////////////////////////////////////////
function Window_VictoryBattleResultsDrops() {
    this.initialize(...arguments);
}
Window_VictoryBattleResultsDrops.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleResultsDrops.prototype.constructor = Window_VictoryBattleResultsDrops;

Window_VictoryBattleResultsDrops.prototype.initialize = function(rect,rewards) {
    this.items = rewards.items;
    this.itemsNumArr = [];
    this.checkDuplicate();
    this.nitem = this.items.length;
    const nL = this.nitem < 3 ? 2 : Math.floor((this.nitem-1)/3)+2;
    rect.height = this.fittingHeight(nL);
    Window_Base.prototype.initialize.call(this, rect);

    this.setBackgroundType(0);
    this.open();
    this.refresh();
}

Window_VictoryBattleResultsDrops.prototype.checkDuplicate = function() {
    for(let i=0; i<this.items.length; i++){
        const cand = this.items[i];
        this.itemsNumArr[i] = 1;
        for(let j=i+1; j<this.items.length; j++){
            const test = this.items[j];
            if(cand.id == test.id){
                if(cand.itypeId){
                    if(test.itypeId && cand.itypeId == test.itypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
                else if(cand.atypeId){
                    if(test.atypeId && cand.atypeId == test.atypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
                else if(cand.wtypeId){
                    if(test.wtypeId && cand.wtypeId == test.wtypeId){
                        this.itemsNumArr[i]++;
                        this.items.splice(j,1);
                        j--;
                    }
                }
            }
        }
    }
}            

Window_VictoryBattleResultsDrops.prototype.update = function() {
    if(this.x<0) this.x -= (this.x/2-1);
    else this.x = 0;
}


Window_VictoryBattleResultsDrops.prototype.refresh = function() {
   this.contents.clear();
   this.contents.fontSize = 18;
   this.changeTextColor(ColorManager.textColor(14));
   this.DrawHorizonLine(4,18,240,3,TextColor_Rewards);
   this.drawText(WindowText_GetItem, 16,-5, 240,"left");

   this.contents.fontSize = 20;
   if(this.nitem==0){
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(WindowText_NoGetItem, 16, 28, Graphics.boxWidth/3);
   }
   for(let i=0; i<this.nitem; i++) this.dispItem(i);
   AudioManager.playSe(SE_ItemWindow);
}

Window_VictoryBattleResultsDrops.prototype.DrawHorizonLine = function(px,py,pw,ph,color) {
    this.contents.paintOpacity = 96;///horzLineOpacity 
    this.contents.FillRoundedRect(px,py,pw,ph,6,color);
    this.contents.paintOpacity = 255;
}

Window_VictoryBattleResultsDrops.prototype.dispItem = function(index) {
    const item = this.items[index];
    const numberWidth = this.numberWidth();
    const textMargin = ImageManager.iconWidth + 4;
    const itemWidth = Math.max(0, this.itemWidth() - textMargin);
    const rect = this.itemLineRect(index);
    this.drawItemName(item, rect.x, rect.y+28, rect.width - numberWidth);
    if(this.itemsNumArr[index]>=2) this.drawItemNumber(this.itemsNumArr[index], rect.x, rect.y+28, rect.width);
}

Window_VictoryBattleResultsDrops.prototype.drawItemNumber = function(tx, x, y, width) {
    this.drawText("x", x, y, width - this.textWidth("00"), "right");
    this.drawText(tx, x, y, width, "right");
}

Window_VictoryBattleResultsDrops.prototype.itemLineRect = function(index) {
    const rect = this.itemRectWithPadding(index);
    const padding = (rect.height - this.lineHeight()) / 2;
    rect.y += padding;
    rect.height -= padding * 2;
    return rect;
}

Window_VictoryBattleResultsDrops.prototype.itemRectWithPadding = function(index) {
    const rect = this.itemRect(index);
    const padding = this.itemPadding();
    rect.x += padding;
    rect.width -= padding * 2;
    return rect;
}

Window_VictoryBattleResultsDrops.prototype.itemRect = function(index) {
    const maxCols = this.maxCols();
    const itemWidth = this.itemWidth();
    const itemHeight = this.itemHeight();
    const colSpacing = 8;
    const rowSpacing = 4;
    const col = index % maxCols;
    const row = Math.floor(index / maxCols);
    const x = col * itemWidth + colSpacing / 2;
    const y = row * itemHeight + rowSpacing / 2;
    const width = itemWidth - colSpacing;
    const height = itemHeight - rowSpacing;
    return new Rectangle(x, y, width, height);
}

Window_VictoryBattleResultsDrops.prototype.numberWidth = function() { return this.textWidth("000"); }
Window_VictoryBattleResultsDrops.prototype.maxCols = function() { return 3; }
Window_VictoryBattleResultsDrops.prototype.itemWidth = function() { return this.width/3;}
Window_VictoryBattleResultsDrops.prototype.itemHeight = function() { return 36;}




//////////////////////////////////////////////////
function Window_VictoryBattleResultsLVUP() {
    this.initialize(...arguments);
}
Window_VictoryBattleResultsLVUP.prototype = Object.create(Window_Base.prototype);
Window_VictoryBattleResultsLVUP.prototype.constructor = Window_VictoryBattleResultsLVUP;

Window_VictoryBattleResultsLVUP.prototype.initialize = function(rect,text) {
    this.text = text;
    this.opa = 255;

    rect.height = this.fittingHeight(1);
    rect.y -= rect.height;
    Window_Base.prototype.initialize.call(this, rect);
    this.newy = rect.y;
    this.setBackgroundType(1);
    this.refresh();
}

Window_VictoryBattleResultsLVUP.prototype.refreshDimmerBitmap = function() {//_dimmerSprite
    if (this._dimmerSprite) {
        const bitmap = this._dimmerSprite.bitmap;
        const w = this.width > 0 ? this.width + 8 : 0;
        const h = this.height;
        const m = this.padding;
        const c1 = "rgba(64, 64, 144, 0.7)";
        const c2 = "rgba(16, 16, 32, 0.0)";
        bitmap.resize(w, h);
        bitmap.gradientFillRect(0, 0, w, m, c2, c1, true);
        bitmap.fillRect(0, m, w, h - m * 2, c1);
        bitmap.gradientFillRect(0, h - m, w, m, c1, c2, true);
        this._dimmerSprite.setFrame(0, 0, w, h);
    }
}

Window_VictoryBattleResultsLVUP.prototype.update = function() {
    if(this.x<0) this.x -= (this.x/2-1);
    else this.x = 0;

    const diff = this.newy - this.y;
    if(diff < 0){
        this.y += diff/2-1;
    }   
    else this.y = this.newy;
}

Window_VictoryBattleResultsLVUP.prototype.refresh = function() {
   this.contents.clear();
   this.contents.fontSize = 20;
   this.contents.paintOpacity = this.opa;
   this.drawTextEx(this.text, 4 , 0, Graphics.boxWidth);
}

Window_VictoryBattleResultsLVUP.prototype.drawTextEx = function(text, x, y, width) {
    const textState = this.createTextState(text, x, y, width);
    this.processAllText(textState);
    return textState.outputWidth;
}

Window_VictoryBattleResultsLVUP.prototype.setNewOrderID = function(idx) {
    this.newy = this.y-this.fittingHeight(1)+16;
    const val = 255-idx*51;
    this._dimmerSprite.opacity = val>0? val : 0;
    this.opa = val>0? val : 0;
    this.refresh();
}

Window_VictoryBattleResultsLVUP.prototype.flushTextState = function(textState) {
    const text = textState.buffer;
    const rtl = textState.rtl;
    const width = this.textWidth(text);
    const height = textState.height;
    const x = rtl ? textState.x - width : textState.x;
    const y = textState.y;
    if (textState.drawing) {
        this.contents.drawTextWithAlphaOutline(text, x, y, width, height);
    }
    textState.x += rtl ? -width : width;
    textState.buffer = this.createTextBuffer(rtl);
    const outputWidth = Math.abs(textState.x - textState.startX);
    if (textState.outputWidth < outputWidth) {
        textState.outputWidth = outputWidth;
    }
    textState.outputHeight = y - textState.startY + height;
}

Bitmap.prototype.drawTextWithAlphaOutline = function(text, x, y, maxWidth, lineHeight, align) {
    const context = this.context;
    const alpha = context.globalAlpha;
    maxWidth = maxWidth || 0xffffffff;
    let tx = x;
    let ty = Math.round(y + lineHeight / 2 + this.fontSize * 0.35);
    if (align === "center") {
        tx += maxWidth / 2;
    }
    if (align === "right") {
        tx += maxWidth;
    }
    context.save();
    context.font = this._makeFontNameText();
    context.textAlign = align;
    context.textBaseline = "alphabetic";
    context.globalAlpha = alpha;
    this._drawTextOutline(text, tx, ty, maxWidth);
    this._drawTextBody(text, tx, ty, maxWidth);
    context.restore();
    this._baseTexture.update();
}


/////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    
    return res;
}
})();