//=============================================================================
// SoR_PerfectGuardEnemy_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ---------------------------------------------------------------------------
// Latest version v1.00 (2021/02/25)
//=============================================================================
/*:ja
@plugindesc ＜無敵・重装甲エネミー＞ v1.00
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@help ダメージ計算に関わらず、受けるダメージが0(or 1)になる
特性を持つエネミーを作成します。
指定のタグをエネミーのメモ欄に書き込んで使用します。

機能の性質上、ダメージ計算に影響する他の全てのプラグインよりも
下部へ登録することが推奨されます。

タグ基本例)
-完全にダメージを無効化する(イベント等，完全無敵エネミー用)
<PerfectGuard>

-基本的にダメージ無効化，確率で1ダメージ(クリティカル無効)
<PerfectGuard2>

- (クリティカル発生時貫通)
<PerfectGuard3>

(その他「バトラー種族定義」との連動機能あり)
@param Probability_Make1Damage
@desc (PerfectGuard2-4用)ダメージ0判定時に，強制的に1ダメージを与える確率 (default: 30)
@default 30
@type number
@min 0
*/
/*:
@plugindesc <Perfect Guard Enemy> v1.00
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help This plugin makes a trait for enemies that forces taken damage to be 0 (or 1).
Write a given note tag for target enemies.
This plugin usually should be placed as low as possible in the plugin list 
considering the behavior in the game (fixing the damage deal).

Quick exmpales)
- Damage is strictly fixed to 0. (completely immortal for event battles).
<PerfectGuard>

- Damage is fixed to 0 and sometimes 1. (critical is ignored)
<PerfectGuard2>

- (In case of critical, the perfect guard is ignored.)
<PerfectGuard3>

!! Likewise there are assosiative functions with "SoR_RaceForBattler".
@param Probability_Make1Damage
@desc (For PerfectGuard2-4) Probability that makes 1 damage in the perfect guard (default: 30)
@default 30
@type number
@min 0
*/

var Imported = Imported || {};
Imported.SoR_PerfectGuard = true;
var SoR = SoR || {};

(function() {
const pluginName = "SoR_PerfectGuardEnemy_MZ";
GabParam = PluginManager.parameters(pluginName);
Probability_Make1Damage = Number(GabParam['Probability_Make1Damage'] || 30);


const SoR_PGE_GA_makeDamageValue = Game_Action.prototype.makeDamageValue;
Game_Action.prototype.makeDamageValue = function(target, critical) {
    let value = SoR_PGE_GA_makeDamageValue.call(this,...arguments);

    if(target.isEnemy()) value = this.processPerfectGuardDamage(target, critical, value);
 	return value;
}

Game_Action.prototype.processPerfectGuardDamage = function(target, critical, value) {
    let pattern = 0;
    const en = target.enemy();
    if(en.meta.PerfectGuard) pattern = 1;// completely perfect (ignore critical)
    else if(en.meta.PerfectGuard2) pattern = 2;// almost perfect (ignore critical)
    else if(en.meta.PerfectGuard3) pattern = 3;// almost perfect
    else if(Imported.SoR_RfB && en.meta.PerfectGuard4) pattern = 4;// almost perfect (with Killer by "Race for battlers")
    const rnd = Math.random();

    if(pattern==1) value = 0;
    else if(pattern == 2 && value >= 0){
        let prob = en.meta.PerfectGuard2 === true ? Probability_Make1Damage*0.01 : Number(en.meta.PerfectGuard2*0.01);
        value = rnd<prob? 1 : 0;
    }
    else if(!critical && pattern == 3 && value >= 0){ 
        let prob = en.meta.PerfectGuard3 === true ? Probability_Make1Damage*0.01 : Number(en.meta.PerfectGuard3*0.01);
        //console.log(rnd, prob)
        value = rnd<prob? 1 : 0;
    }
    else if(!critical && pattern == 4 && value >= 0){ //temporary
        let prob = en.meta.PerfectGuard4 === true ? Probability_Make1Damage*0.01 : Number(en.meta.PerfectGuard4*0.01);
        
        if(value > 0 && !this.item().meta.NoRaceKiller && target.isKiller && target.complete_resist == false){
            const variance = Math.ceil(target.KillerRate/20.0);
            value = Math.floor(rnd * variance)+1;
        }
        else value = rnd<prob? 1 : 0;

    }

    return value;
}
	
})();