//=============================================================================
// SoR_PassiveStatusEffects_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.02 (2021/10/02)
//=============================================================================
/*:ja
@plugindesc ＜パッシブスキル機能 - メイン＞ v1.02
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@base SoR_BattleActionParameterRefactor_MZ
@base SoR_TagDataProcessor_MZ
@orderAfter SoR_BattleActionParameterRefactor_MZ
@orderAfter SoR_TagDataProcessor_MZ
@help ※要 88.「SoRタグデータ解析」(SoR_TagDataProcessor_MZ.js)
※要 94.「戦闘行動パラメータ参照細分化」(SoR_BattleActionParameterRefactor_MZ.js)

《パッシブスキル機能 本体プラグイン》

所持・習得しているだけでステータスボーナス等の追加補助効果を
バトラー(アクター)に付与する機能を実装します。

本プラグインは、RPGツクールの標準搭載機能に関与する機能のみを提供します。
広義的なパッシブ機能は、
これに従属する後続プラグインが担当します
(このプラグインに、必要なものだけを加えて導入してください)。
*/
/*:
@plugindesc <Passive Skill System - Main> v1.02
@author Soryu
@base SoR_BattleActionParameterRefactor_MZ
@base SoR_TagDataProcessor_MZ
@orderAfter SoR_BattleActionParameterRefactor_MZ
@orderAfter SoR_TagDataProcessor_MZ
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help [Prerequisite] 88. SoR_TagDataProcessor_MZ
[Prerequisite] 94. SoR_BattleActionParameterRefactor_MZ

<<<Passive Skill Base Plugin>>>

This plugin implements a passible skill system which provides
battlers (actors) some effects such as status bonus.

This (base) plugin presents effects to extend the default RPGMaker system
(correction of parameters implemented in default).
Other extensive passive effects are supported by following sub plugins.
(Install all needed sub passive skill system plugins with this base.)
*/
(function() {
if(!PluginManager._scripts.includes("SoR_TagDataProcessor_MZ")) throw new Error("[SoR_PassiveStatusEffects_MZ] This plugin REQUIRES SoR_TagDataProcessor_MZ.");
if(!PluginManager._scripts.includes("SoR_BattleActionParameterRefactor_MZ")) throw new Error("[SoR_PassiveStatusEffects_MZ] This plugin REQUIRES SoR_BattleActionParameterRefactor_MZ.");

const pluginName = "SoR_PassiveStatusEffects_MZ";
const Param = PluginManager.parameters(pluginName);

Game_BattlerBase.TRAIT_BASE_PARAM = 100001;

////////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_PSE_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagPSE1", target: ["skill","weapon","armor","state"]};
    this._SoRTagProcessFuncs.push(q);
}

DataManager.SoRTagPSE1_init = function(obj) {
	obj.passiveEffects = [];
	obj.passiveBase = {
        visible: false,
        maxlevel: 1, rank: 1, cost: 0
    };
}

const baseParams = ["mhp", "mmp", "atk", "def", "mat", "mdf", "agi", "luk"];
const XParams = ["hit", "eva", "cri", "cev", "mev", "mrf", "cnt", "hrg", "mrg", "trg",
                 "mhrg", "mmrg", "mtrg", "exp"]; //107-110
const SParams = ["tgr", "grd", "rec", "pha", "mcr", "tcr", "pdr", "mdr", "fdr", "exr"];
const showtag = /<(?:ShowPassive)[ ]*>/i;
const lvtag = /<(?:PassiveMaxLv):[ ]*(\d+)>/i;
const infotag = /<(?:PassiveInfo):[ ]*(\d+),[ ]*(\d+)>/i;
const tag = /<(?:PSVBaseParam):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i; //baseparam
const tag2 = /<(?:PSVXParam):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i; //xparam
const tag3 = /<(?:PSVSParam):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i; //sparam
const tag4 = /<(?:PSVElem):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i; //element
const tag5 = /<(?:PSVDebuffRate):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i; //debuff
const tag6 = /<(?:PSVStateRate):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i; //state

DataManager.SoRTagPSE1 = function(obj, line) {
    let MatchFlag = true;
    const passiveBase = obj.passiveBase;
    const passiveEffects = obj.passiveEffects;

    if (line.match(showtag)) passiveBase.visible = true;
    else if (line.match(lvtag)) passiveBase.maxlevel = Number(RegExp.$1);
	else if (line.match(infotag)){
        if(Number(RegExp.$1)) passiveBase.rank = Number(RegExp.$1);
        if(Number(RegExp.$2)) passiveBase.cost = Number(RegExp.$2);
    }
    else{

        let ret = MatchPassiveEffects(line, tag, baseParams, Game_BattlerBase.TRAIT_BASE_PARAM); //base param
        if(ret!=null) passiveEffects.push(ret);
        else{
            ret = MatchPassiveEffects(line, tag2, XParams, Game_BattlerBase.TRAIT_XPARAM); //xparam
            if(ret!=null) passiveEffects.push(ret);
            else{
                ret = MatchPassiveEffects(line, tag3, SParams, Game_BattlerBase.TRAIT_SPARAM);  //sparam
                if(ret!=null) passiveEffects.push(ret);
                else{
                    ret = MatchPassiveEffects(line, tag4, [], Game_BattlerBase.TRAIT_ELEMENT_RATE); //element
                    if(ret!=null) passiveEffects.push(ret);
                    else{
                        ret = MatchPassiveEffects(line, tag5, [], Game_BattlerBase.TRAIT_DEBUFF_RATE); //debuff
                        if(ret!=null) passiveEffects.push(ret);
                        else{
                            ret = MatchPassiveEffects(line, tag6, [], Game_BattlerBase.TRAIT_STATE_RATE); //state
                            if(ret!=null) passiveEffects.push(ret);
                            else MatchFlag = false;
                        }
                    }
                }
            }
        }
    }

    return MatchFlag;
}

function MatchPassiveEffects(line, maintag, ParamArr, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: null,
            effect: undefined,
            proportional: false,
            cond: undefined
        };

        const test = ParamArr.length==0? Number(RegExp.$1) : ParamArr.indexOf(String(RegExp.$1).trim());
        pe.Param = test;
        const reg_val = String(RegExp.$2);
        const condtx = String(RegExp.$3);
        pe.cond = condtx? condtx.trim() : "true";

        const tag_2 = /([+,-]?\d+)?(%)?/;
        if (reg_val.match(tag_2)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;

            return pe; //valid
        }
	}

    return null;
}
///////////////////////////////////////////////////////////////////////////


//For default battle system
const SoR_PSE_BM_endAction_extended = BattleManager.endAction_extended;
BattleManager.endAction_extended = function() {
    SoR_PSE_BM_endAction_extended.call(this);
    this.PSVEndofActions();
}
BattleManager.PSVEndofActions = function() {
    /* extension by others */
}

const SoR_PSE_BM_endBattlerActions = BattleManager.endBattlerActions;
BattleManager.endBattlerActions = function(battler) {
    if(this._action && this._action.passiveActivated){
        this.displayBattlerStatus(battler, true);
    }
    else{
        SoR_PSE_BM_endBattlerActions.call(this,...arguments);
    }
}








Game_BattlerBase.prototype.paramPassiveConds = function(code, paramId, proportional, op) {// actually defined in PSV3
    return 0;
}

///////////////////////////////////////////////////////////////////////////
const SoR_PSE_GBB_paramBasePlus = Game_BattlerBase.prototype.paramBasePlus;
Game_BattlerBase.prototype.paramBasePlus = function(paramId) {
    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_BASE_PARAM, paramId, false, 0);// add constant
    const psvvals2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_BASE_PARAM, paramId, false, 0);// add constant
    const psval = psvvals + psvvals2;

    const defaults = SoR_PSE_GBB_paramBasePlus.call(this, ...arguments);
    return Math.max(0, defaults+psval);
}

const SoR_PSE_GBB_paramRate = Game_BattlerBase.prototype.paramRate;
Game_BattlerBase.prototype.paramRate = function(paramId) {
    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_BASE_PARAM, paramId, true, 0);// add propotional
    const psvvals2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_BASE_PARAM, paramId, true, 0);// add propotional
    const psval = (psvvals + psvvals2)/100.0;

    const defaults = SoR_PSE_GBB_paramRate.call(this, ...arguments);
    return psval + defaults;
}
///////////////////////////////////////////////////////////////////////////

const SoR_PSE_GBB_xparam = Game_BattlerBase.prototype.xparam;
Game_BattlerBase.prototype.xparam = function(xparamId) {
    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_XPARAM, xparamId, false, 0);// add constant
    const psvvals2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_XPARAM, xparamId, false, 0);// add constant
    const psval = psvvals + psvvals2;

    const psvvals_p = this.paramPassiveEffects(Game_BattlerBase.TRAIT_XPARAM, xparamId, true, 0);// add propotional
    const psvvals_p2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_XPARAM, xparamId, true, 0);// add propotional
    const psval2 = (psvvals_p + psvvals_p2)/100.0;

    const defaults = SoR_PSE_GBB_xparam.call(this, ...arguments);
    return (defaults+psval)*(1.0+psval2);
}

const SoR_PSE_GBB_sparam = Game_BattlerBase.prototype.sparam;
Game_BattlerBase.prototype.sparam = function(sparamId) {
    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_SPARAM, sparamId, false, 0);// add constant
    const psvvals2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_SPARAM, sparamId, false, 0);// add constant
    const psval = psvvals + psvvals2;

    const psvvals_p = this.paramPassiveEffects(Game_BattlerBase.TRAIT_SPARAM, sparamId, true, 0);// add propotional
    const psvvals_p2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_SPARAM, sparamId, true, 0);// add propotional
    const psval2 = (psvvals_p + psvvals_p2)/100.0;

    const defaults = SoR_PSE_GBB_sparam.call(this, ...arguments);
    return (defaults+psval)*(1.0+psval2);
}
///////////////////////////////////////////////////////////////////////////

const SoR_PSE_GBB_elementRate = Game_BattlerBase.prototype.elementRate;
Game_BattlerBase.prototype.elementRate = function(elementId) {
    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_ELEMENT_RATE, elementId, false, 0)/100.0;// add constant
    const psvvals2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_ELEMENT_RATE, elementId, false, 0)/100.0;// add constant
    const psval = psvvals + psvvals2;

    const psvvals_p = this.paramPassiveEffects(Game_BattlerBase.TRAIT_ELEMENT_RATE, elementId, true, 0)/100.0;// add propotional
    const psvvals_p2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_ELEMENT_RATE, elementId, true, 0)/100.0;// add propotional
    const psval2 = (psvvals_p + psvvals_p2)/100.0;

    const defaults = SoR_PSE_GBB_elementRate.call(this, ...arguments);
    return (defaults+psval)*(1.0+psval2);
}

const SoR_PSE_GBB_debuffRate = Game_BattlerBase.prototype.debuffRate;
Game_BattlerBase.prototype.debuffRate = function(paramId) {
    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_DEBUFF_RATE, paramId, false, 0)/100.0;// add constant
    const psvvals2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_DEBUFF_RATE, paramId, false, 0)/100.0;// add constant
    const psval = psvvals + psvvals2;

    const psvvals_p = this.paramPassiveEffects(Game_BattlerBase.TRAIT_DEBUFF_RATE, paramId, true, 0)/100.0;// add propotional
    const psvvals_p2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_DEBUFF_RATE, paramId, true, 0)/100.0;// add propotional
    const psval2 = (psvvals_p + psvvals_p2)/100.0;

    const defaults = SoR_PSE_GBB_debuffRate.call(this, ...arguments);
    return (defaults+psval)*(1.0+psval2);
}

const SoR_PSE_GBB_stateRate = Game_BattlerBase.prototype.stateRate;
Game_BattlerBase.prototype.stateRate = function(stateId) {
    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_STATE_RATE, stateId, false, 0)/100.0;// add constant
    const psvvals2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_STATE_RATE, stateId, false, 0)/100.0;// add constant
    const psval = psvvals + psvvals2;

    const psvvals_p = this.paramPassiveEffects(Game_BattlerBase.TRAIT_STATE_RATE, stateId, true, 0)/100.0;// add propotional
    const psvvals_p2 = this.paramPassiveConds(Game_BattlerBase.TRAIT_STATE_RATE, stateId, true, 0)/100.0;// add propotional
    const psval2 = (psvvals_p + psvvals_p2)/100.0;

    const defaults = SoR_PSE_GBB_stateRate.call(this, ...arguments);
    return (defaults+psval)*(1.0+psval2);
}


///////////////////////////////////////////////////////////////////////////
Game_BattlerBase.prototype.paramPassiveEffects = function(code, paramId, proportional, op) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
    if(op==0) return this.PassiveEfkSum(code, paramId, proportional);
    else if(op==1) return this.PassiveEfkPi(code, paramId, proportional);
    return undefined;
}
///////////////////////////////////////////////////////////////////////////

Game_BattlerBase.prototype.PassiveEfkSum = function(code, id, proportional) {// Σ
    return this.PassiveWithTraits(code, id, proportional).reduce((r, efk) => r + efk.effect, 0);
}

Game_BattlerBase.prototype.PassiveEfkPi = function(code, id) {// Π
    return this.PassiveWithTraits(code, id, proportional).reduce((r, efk) => r * efk.effect, 1);
}

Game_BattlerBase.prototype.PassiveWithTraits = function(code, id, proportional) {
    return this.allPassiveEffects().filter(//get effects which meat with conditions
        obj => {
            return obj.code === code && obj.Param === id && obj.proportional === proportional && SoR_EvalBSS(obj.cond, this);
        }
    );
}

Game_BattlerBase.prototype.allPassiveEffects = function() {//collect passive effects
    return this.PassiveEffectObj().reduce((r, obj) => obj.passiveEffects ? r.concat(obj.passiveEffects): r, []);
}

Game_BattlerBase.prototype.PassiveEffectObj = function() {
    const obj = this.CalculatePassiveEffectObj([]);
    const res = obj.filter(v => !!v && v.name!== "");//correction
    return res;
}

Game_Actor.prototype.CalculatePassiveEffectObj = function(obj) {
    //console.log(new Error().stack);
    if(this._skills) for(const x of this._skills) obj = obj.concat($dataSkills[x]);
    for(const x of this._equips) obj = x._dataClass==="weapon" ? obj.concat($dataWeapons[x._itemId]) : (x._dataClass==="armor"? obj.concat($dataArmors[x._itemId]) : obj);
    for(const x of this._states) obj = obj.concat($dataStates[x]);
    return obj;
}
Game_Enemy.prototype.CalculatePassiveEffectObj = function(obj) {
    return obj;
}
///////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////
// 2,3
////////////////////////////////////////////////////////////////////////////////////////
Game_BattlerBase.prototype.EvalTraitEfkSum = function(code, proportional) {// Σ
    return this.PassiveWithTraits2(code, proportional).reduce((r, efk) =>{
        return r + efk.effect;
    }, 0);
}
Game_BattlerBase.prototype.EvalTraitEfkPi = function(code, proportional) {// Π
    return this.PassiveWithTraits2(code, proportional).reduce((r, efk) =>{
        return r * efk.effect;
    }, 1);
}
Game_BattlerBase.prototype.EvalTraitEfkMax = function(code, proportional) {// max
    return this.PassiveWithTraits2(code, proportional).reduce((r, efk) =>{
        return r > efk.effect ? r : efk.effect;
    }, 0);
}


Game_BattlerBase.prototype.PassiveWithTraits2 = function(code, proportional) {
    return this.allPassiveEffects().filter(//get effects which meat with conditions
        obj => {
            if(obj.code === code && obj.proportional === proportional && SoR_EvalBSS(obj.cond, this)){
                if(obj.prob <= 0) return true;
                if(Math.random() <= obj.prob) return true;
            }
            return false;
        }
    );
}


/////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE3_BM_updateTurn = BattleManager.updateTurn;
BattleManager.updateTurn = function(timeActive) {
    this.activatePSVSkills_onStart();
    SoR_PSE3_BM_updateTurn.call(this,...arguments);
    this.PSVSkills_observeRealtime();
}
//defined by subs
BattleManager.activatePSVSkills_onStart = function() {}

BattleManager.PSVSkills_observeRealtime = function() {
    $gameParty.PSVobserver();
    $gameTroop.PSVobserver();
}
Game_Unit.prototype.PSVobserver = function() {}

/////////////////////////////////////////////////////////////////////////////////////
//temporary
const SoR_PSE1_WSL_include = Window_SkillList.prototype.includes;
Window_SkillList.prototype.includes = function(item) {
    const prev = SoR_PSE1_WSL_include.call(this,...arguments);
    const psvflag = !$gameParty.inBattle()? true : (typeof item.passiveEffects === "undefined" || item.passiveEffects.length==0);
    return prev && psvflag;
}

/////////////////////////////////////////////////////////////////////////////////////

function SoR_EvalBSS(ev, gb) {
    ev = ev.replace(/this/g, "gb");
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("gb",sentence));
    }     
    const res = $gameTemp.SoRTmp_script.get(sentence)(gb);
    return res;
}
})();