//=============================================================================
// SoR_PassiveStatusEffects6_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.02 (2021/10/19)
//=============================================================================
/*:ja
@plugindesc ＜パッシブスキル機能 - サブ5(エネミー対応)＞ v1.02
@author 蒼竜
@target MZ
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@url https://dragonflare.blue/dcave/
@help 《パッシブスキル機能 - サブ5 (エネミー対応)》
※要 97.「パッシブスキル機能 - メイン」(SoR_PassiveStatusEffects_MZ.js)

所持・習得しているだけでステータスボーナス等の追加補助効果を
バトラー(アクター)に付与する機能を実装します。

本プラグインは、「パッシブスキル機能 - メイン」の土台機能に
RPGツクールの標準搭載"ではない"広義のパッシブスキル機能
(エネミーへのパッシブ機能対応)を実装します。

導入済みのパッシブスキル機能(メイン～サブ4)の効果を、
戦闘で出現するエネミーにも設定できるようになります。

@param MaxPassiveSkills_forEnemy
@desc エネミーが所持できるパッシブスキルの最大個数(全体設定), 0で無制限
@default 0
@type number
*/
/*:
@plugindesc <Passive Skill System - Sub5 (Enemy Ext.)> v1.02
@author Soryu
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help <<<Passive Skill SUB Plugin 5 (Enemy Ext.)>>>
[Prerequisite] 97. SoR_PassiveStatusEffects_MZ

This plugin implements a passible skill system which provides
battlers (actors) some effects such as status bonus.
This sub plugin provide extra system beyond the default RMMZ design
(Extension for application of the passive system to enemies).

@param MaxPassiveSkills_forEnemy
@desc Number of maximum passive skills applied to an enemy (overall setting). Set 0 to be infinite.
@default 0
@type number
*/
(function() {
if(!PluginManager._scripts.includes("SoR_PassiveStatusEffects_MZ")) throw new Error("[SoR_PassiveStatusEffects6_MZ] This plugin REQUIRES SoR_PassiveStatusEffects_MZ.");
const pluginName = "SoR_PassiveStatusEffects6_MZ";

const Param = PluginManager.parameters(pluginName);
const MaxPassiveSkills_forEnemy = Number(Param['MaxPassiveSkills_forEnemy'] || 0);


////////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE6_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_PSE6_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagPSE6", target: ["enemy"]};
    this._SoRTagProcessFuncs.push(q);
}

const tag = /<(?:EnemyPSV):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond

DataManager.SoRTagPSE6_init = function(obj) {
    obj._psvcands = [];
    if(obj.meta.PSVLimit && !Number.isNaN(Number(obj.meta.PSVLimit))) obj.nmax_psv = Number(obj.meta.PSVLimit);
    else obj.nmax_psv = null;
}
DataManager.SoRTagPSE6 = function(obj, line) {
    let MatchFlag = false;

    const res = MatchPassiveEffects_EnemyList(line,tag);
    if(res!=null){
        obj._psvcands.push(res);
        MatchFlag = true;
    }

    return MatchFlag;
}

////////////////////////////////////////////////////////////////////////////////////
function MatchPassiveEffects_EnemyList(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            type: "",
            index: 0,
            prob: 0,
            cond: undefined
        };

        pe.type = String(RegExp.$1);
        pe.index = Number(RegExp.$2);
        if(Number.isNaN(pe.index) || pe.index <= 0) pe.index = 0;
        if(pe.type!= "weapon" && pe.type!= "skill" && pe.type!= "state" && pe.type!= "armor") pe.index = 0;

        pe.prob = Number(RegExp.$3);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$4);
        pe.cond = condtx? condtx.trim() : "true";

        if (pe.index>=1){
            return pe; //valid
        }
	}
    return null;
}
/////////////////////////////////////////////////////////////////////////////////////

const SoR_PSE6_GE_setup = Game_Enemy.prototype.setup;
Game_Enemy.prototype.setup = function(enemyId, x, y) {
    SoR_PSE6_GE_setup.call(this,...arguments);
    this.preparePassiveTraits();
}

Game_Enemy.prototype.preparePassiveTraits = function() {
    this._psvlist = [];
    const cands = this.enemy()._psvcands;
    for(const x of cands){
        if(this.nmax_psv!==null){
            if(MaxPassiveSkills_forEnemy >1 && this._psvlist.length >= MaxPassiveSkills_forEnemy) break;
        }
        else if(this._psvlist.length >= this.nmax_psv) break;

        if(SoR_Eval(x.cond)){
            if(x.prob==0|| Math.random() < x.prob){
                const item = ExtractEnemyPassive(x);
                this._psvlist.push(item);
            }
        }
    }
    this.recoverAll();
}

//MaxPassiveSkills_forEnemy

//overwrite a function in PSV main
Game_Enemy.prototype.CalculatePassiveEffectObj = function(obj) {
    if(typeof this._psvlist === "undefined") return [];//not ready

    let psvlist = this._psvlist.slice();

    const psvstates = this._states.filter(x=> $dataStates[x].passiveEffects);
    for(const x of psvstates) psvlist = psvlist.concat($dataStates[x]);//current states
    return psvlist;
}

function ExtractEnemyPassive(x){
    if(x.type=="skill") return $dataSkills[x.index];
    else if(x.type=="weapon") return $dataWeapons[x.index];
    else if(x.type=="armor") return $dataArmors[x.index];
}

const SoR_PSE6_GU_PSVobserver = Game_Unit.prototype.PSVobserver;
Game_Troop.prototype.PSVobserver = function() {
    SoR_PSE6_GU_PSVobserver.call(this);
    for (const member of this.members()) {
            if(PluginManager._scripts.includes("SoR_PassiveStatusEffects3_MZ")){
                member.performPassiveCondEffects();
                //member.performPassiveCondSkillAct();
            if(PluginManager._scripts.includes("SoR_PassiveStatusEffects4_MZ")){
                member.performPassiveAlwaysEffects();
            }
        }
    }
}

Game_Enemy.prototype.IsAffectedSoRPassive = function() {
    if(typeof this._psvlist === "undefined") return false;

    const psvstates = this._states.filter(x=> $dataStates[x].passiveEffects);
    if(this._psvlist.length == 0 && psvstates.length==0) return false;
    return true;
}

/////////////////////////////////////////////////////////////////////////////////////
function SoR_Eval(ev) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function(sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)();
    return res;
}

})();