//=============================================================================
// SoR_PassiveStatusEffects5_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.01 (2021/10/14)
//=============================================================================
/*:ja
@plugindesc ＜パッシブスキル機能 - サブ4 (SoR拡張)＞ v1.01
@author 蒼竜
@target MZ
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@url https://dragonflare.blue/dcave/
@help 《パッシブスキル機能 - サブ4 (SoR拡張)》
※要 97.「パッシブスキル機能 - メイン」(SoR_PassiveStatusEffects_MZ.js)

所持・習得しているだけでステータスボーナス等の追加補助効果を
バトラー(アクター)に付与する機能を実装します。

本プラグインは、「パッシブスキル機能 - メイン」の土台機能に
RPGツクールの標準搭載"ではない"広義のパッシブスキル機能
(既配布プラグイン実装システムの拡張)を実装します。
*/
/*:
@plugindesc <Passive Skill System - Sub4 (SoR Ext.)> v1.01
@author Soryu
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help <<<Passive Skill SUB Plugin 4 (SoR Ext.)>>>
[Prerequisite] 97. SoR_PassiveStatusEffects_MZ

This plugin implements a passible skill system which provides
battlers (actors) some effects such as status bonus.
This sub plugin provide extra system beyond the default RMMZ design
(Extension for features provided by the existing SoR plugins).
*/
(function() {
if(!PluginManager._scripts.includes("SoR_PassiveStatusEffects_MZ")) throw new Error("[SoR_PassiveStatusEffects5_MZ] This plugin REQUIRES SoR_PassiveStatusEffects_MZ.");
const pluginName = "SoR_PassiveStatusEffects5_MZ";

Game_BattlerBase.TRAIT_SoR_CRITICAL_DAMUP = 100081;
Game_BattlerBase.TRAIT_SoR_CRITICAL_DAMDOWN = 100082;
Game_BattlerBase.TRAIT_SoR_ENEMYESCAPE_FAIL = 100083;
Game_BattlerBase.TRAIT_SoR_BREAKSTAGGER_BVALUP = 100084;
Game_BattlerBase.TRAIT_SoR_BREAKSTAGGER_BDAMUP = 100085;
Game_BattlerBase.TRAIT_SoR_HPCONSUMPTION = 100086;
Game_BattlerBase.TRAIT_SoR_BSCOOLTIME = 100087;
Game_BattlerBase.TRAIT_SoR_ITEMBREAKRATE = 100088;
Game_BattlerBase.TRAIT_SoR_ENEMYREINFORCE_INTERRUPT = 100089;
Game_BattlerBase.TRAIT_SoR_BUFF_DURATIONEXTEND = 100090;
Game_BattlerBase.TRAIT_SoR_DEBUFF_DURATIONEXTEND = 100091;
Game_BattlerBase.TRAIT_SoR_GOODSTATE_DURATIONEXTEND = 100092;
Game_BattlerBase.TRAIT_SoR_BADSTATE_DURATIONEXTEND = 100093;
Game_BattlerBase.TRAIT_SoR_REGEN_INTERVALEXTEND = 100094;
Game_BattlerBase.TRAIT_SoR_SLIP_INTERVALEXTEND = 100095;

////////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE5_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_PSE5_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagPSE5", target: ["skill","weapon","armor","state"]};
    this._SoRTagProcessFuncs.push(q);
}

const tag1 = /<(?:PSVCriDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag2 = /<(?:PSVCriDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag3 = /<(?:PSVEnemyEscapeDown):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag4 = /<(?:PSVBreakEffect):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag5 = /<(?:PSVBreakDamage):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag6 = /<(?:PSVHPConsume):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag7 = /<(?:PSVCoolTime):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag8 = /<(?:PSVItemConsume):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag9 = /<(?:PSVReinforceInterrupt):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag10 = /<(?:PSVBuffExtend):[ ]*(.*),[ ]*(.*)>/i;//val cond
const tag11 = /<(?:PSVBadStateExtend):[ ]*(.*),[ ]*(.*)>/i;//val cond
const tag12 = /<(?:PSVDeBuffExtend):[ ]*(.*),[ ]*(.*)>/i;//val cond
const tag13 = /<(?:PSVGoodStateExtend):[ ]*(.*),[ ]*(.*)>/i;//val cond
const tag14 = /<(?:PSVRegenIntarvalExtend):[ ]*(.*),[ ]*(.*)>/i;//val cond
const tag15 = /<(?:PSVSlipIntervalExtend):[ ]*(.*),[ ]*(.*)>/i;//val cond

DataManager.SoRTagPSE5_init = function(obj) {}
DataManager.SoRTagPSE5 = function(obj, line) {
    let MatchFlag = false;
    const passiveEffects = obj.passiveEffects;

    let ret = MatchPassiveEffects_PSE5ValControl(line, tag1, Game_BattlerBase.TRAIT_SoR_CRITICAL_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControl(line, tag2, Game_BattlerBase.TRAIT_SoR_CRITICAL_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControl(line, tag3, Game_BattlerBase.TRAIT_SoR_ENEMYESCAPE_FAIL);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControlP(line, tag4, Game_BattlerBase.TRAIT_SoR_BREAKSTAGGER_BVALUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControlP(line, tag5, Game_BattlerBase.TRAIT_SoR_BREAKSTAGGER_BDAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControlP(line, tag6, Game_BattlerBase.TRAIT_SoR_HPCONSUMPTION);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControlP(line, tag7, Game_BattlerBase.TRAIT_SoR_BSCOOLTIME);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControl(line, tag8, Game_BattlerBase.TRAIT_SoR_ITEMBREAKRATE);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5ValControl(line, tag9, Game_BattlerBase.TRAIT_SoR_ENEMYREINFORCE_INTERRUPT);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }


    ret = MatchPassiveEffects_PSE5TDBSControl(line, tag10, Game_BattlerBase.TRAIT_SoR_BUFF_DURATIONEXTEND);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5TDBSControl(line, tag11, Game_BattlerBase.TRAIT_SoR_BADSTATE_DURATIONEXTEND);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5TDBSControl(line, tag12, Game_BattlerBase.TRAIT_SoR_DEBUFF_DURATIONEXTEND);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5TDBSControl(line, tag13, Game_BattlerBase.TRAIT_SoR_GOODSTATE_DURATIONEXTEND);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }

    ret = MatchPassiveEffects_PSE5TDBSControl(line, tag14, Game_BattlerBase.TRAIT_SoR_REGEN_INTERVALEXTEND);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_PSE5TDBSControl(line, tag15, Game_BattlerBase.TRAIT_SoR_SLIP_INTERVALEXTEND);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }

    return MatchFlag;
}


////////////////////////////////////////////////////////////////////////////////////
function MatchPassiveEffects_PSE5ValControl(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: 0,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        pe.prob = Number(RegExp.$2);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$3);
        const test_val = parseInt(RegExp.$1);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        if (!Number.isNaN(test_val)){
            pe.effect = test_val;
            return pe; //valid
        }
	}
    return null;
}

function MatchPassiveEffects_PSE5ValControlP(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: 0,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        pe.prob = Number(RegExp.$2);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$3);
        const reg_val = String(RegExp.$1);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}



function MatchPassiveEffects_PSE5TDBSControl(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: 0,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const condtx = String(RegExp.$2);
        const reg_val = String(RegExp.$1);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}


/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

if(PluginManager._scripts.includes("SoR_CriticalDamageController_MZ")){
    const SoR_PSE5_GA_correctCritical_sub = Game_Action.prototype.correctCritical_sub;
    Game_Action.prototype.correctCritical_sub = function() {//for increase
        const prev = SoR_PSE5_GA_correctCritical_sub.call(this);
        const psvefc = this.subject().testPassiveCriticalDamControl(Game_BattlerBase.TRAIT_SoR_CRITICAL_DAMUP);
        return prev + psvefc;
    }
    const SoR_PSE5_GA_correctCritical_tar = Game_Action.prototype.correctCritical_tar;
    Game_Action.prototype.correctCritical_tar = function() {//for decrease
        const prev = SoR_PSE5_GA_correctCritical_tar.call(this);
        const psvefc = this.tmpTarget.testPassiveCriticalDamControl(Game_BattlerBase.TRAIT_SoR_CRITICAL_DAMDOWN);
        return prev + psvefc;
    }
    Game_Battler.prototype.testPassiveCriticalDamControl = function(code) {
        if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
        let cval = this.EvalTraitEfkSum(code, false)*0.01;
        return cval;
    }

}



if(PluginManager._scripts.includes("SoR_EnemyEscapePerformance_MZ")){
    const SoR_PSE5_GA_correctCritical_sub = Game_Action.prototype.correctCritical_sub;
    Game_Action.prototype.itemEscape_calcPRate = function(target) {//party passive
        const base = SoR_PSE5_GA_correctCritical_sub.call(this,...arguments);
        const psvefc = this.testPassiveEscapeERateControl(Game_BattlerBase.TRAIT_SoR_ENEMYESCAPE_FAIL);
        return prev + psvefc;
    }
    Game_Action.prototype.testPassiveEscapeERateControl = function(code) {//merge all party member effects
        let val = 0;
        for(const ptm of $gameParty.members()){
            if(ptm._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) continue; //ignore psv effects
            val += ptm.EvalTraitEfkSum(code, false)*0.01;
        }
        return val;
    }
}


if(PluginManager._scripts.includes("SoR_Break-StaggerSystem_MZ")){
    const SoR_PSE5_GA_applyBreakBonusDamageRate_OtherCorrection = Game_Action.prototype.applyBreakBonusDamageRate_OtherCorrection;
    Game_Action.prototype.applyBreakBonusDamageRate_OtherCorrection = function(target, value) {
        const prev = SoR_PSE5_GA_applyBreakBonusDamageRate_OtherCorrection.call(this, ...arguments);
        const psvefc = this.subject().testPassiveBreakValueControl(Game_BattlerBase.TRAIT_SoR_BREAKSTAGGER_BVALUP);
        return prev+psvefc;
    }
    Game_Battler.prototype.testPassiveBreakValueControl = function(code) {
        if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
        let cval = this.EvalTraitEfkSum(code, false)*0.01;
        return cval;
    }

    const SoR_PSE5_GA_calcBreakDamageBonusRate = Game_Action.prototype.calcBreakDamageBonusRate;
    Game_Action.prototype.calcBreakDamageBonusRate = function(target, value) {
        const prev = SoR_PSE5_GA_calcBreakDamageBonusRate.call(this,...arguments);
        const psvefc = this.subject().testPassiveBreakDamageControl(Game_BattlerBase.TRAIT_SoR_BREAKSTAGGER_BDAMUP);
        return prev+psvefc;
    }
    Game_Battler.prototype.testPassiveBreakDamageControl = function(code) {
        if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
        let cval = this.EvalTraitEfkSum(code, false)*0.01;
        return cval;
    }
}


if(PluginManager._scripts.includes("SoR_HPConsumeSkills_MZ")){
    const SoR_PSE5_GBB_correctSkillHPCost = Game_BattlerBase.prototype.correctSkillHPCost;
    Game_BattlerBase.prototype.correctSkillHPCost = function(base) {
        const prev = SoR_PSE5_GBB_correctSkillHPCost.call(this,...arguments);
        const psvefc = this.testPassiveHPConsumptionControl(Game_BattlerBase.TRAIT_SoR_HPCONSUMPTION,prev);
        return psvefc;
    }
    Game_BattlerBase.prototype.testPassiveHPConsumptionControl = function(code,base) {
        if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
        let cval = this.EvalTraitEfkSum(code, false);
        let vval = base*this.EvalTraitEfkSum(code, true)*0.01;
        let val = base-(cval+vval);
        if(val<=0) val = 0;
        return Math.floor(val);
    }
}


if(PluginManager._scripts.includes("SoR_BattleSkillCoolTime_MZ")){
    const SoR_PSE5_GB_applyCoolTimeCorrection = Game_Battler.prototype.applyCoolTimeCorrection;
    Game_Battler.prototype.applyCoolTimeCorrection = function(sct) {
        const base = SoR_PSE5_GB_applyCoolTimeCorrection.call(this,...arguments);
        const psvefc = this.testPassiveBSCoolTimeControl(Game_BattlerBase.TRAIT_SoR_BSCOOLTIME,base);
        return psvefc;
    }
    Game_Battler.prototype.testPassiveBSCoolTimeControl = function(code,base) {
        if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
        let cval = this.EvalTraitEfkSum(code, false);
        let vval = base*this.EvalTraitEfkSum(code, true)*0.01;
        let val = base-(cval+vval);
        if(val<=0) val = 0;
        return Math.floor(val);
    }
}


if(PluginManager._scripts.includes("SoR_ItemConsumptionRate_MZ")){
    const SoR_PSE5_GB_canKeepConsumeItem = Game_Battler.prototype.canKeepConsumeItem;
    Game_Battler.prototype.canKeepConsumeItem = function() {//considering battler trait
        const prev = SoR_PSE5_GB_canKeepConsumeItem.call(this);
        const psvefc = this.testPassiveItemConsumptionControl(Game_BattlerBase.TRAIT_SoR_ITEMBREAKRATE);
        return prev||psvefc;
    }

    Game_Battler.prototype.testPassiveItemConsumptionControl = function(code) {
        if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return false; //ignore psv effects
        let cval = this.EvalTraitEfkSum(code, false);
        const prob = cval.clamp(0,100)/100.0;
        if(Math.random() < prob) return true;
        else return false;
    }
}


if(PluginManager._scripts.includes("SoR_TroopReinforcement_MZ")){
const SoR_PSE5_GA_correctReinforcementRate = Game_Action.prototype.correctReinforcementRate;
Game_Action.prototype.correctReinforcementRate = function() {
	const base = SoR_PSE5_GA_correctReinforcementRate.call(this);
    const psvefc = this.testPassiveReinforceInterruptControl(Game_BattlerBase.TRAIT_SoR_ENEMYREINFORCE_INTERRUPT);
    return base+psvefc;
}
Game_Action.prototype.testPassiveReinforceInterruptControl = function() {
    if(this.subject().isActor()) return 0.0;
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0.0; //ignore psv effects
    let accum = 0.0;
    const pm = $gameParty.member();
    for(const x of pm){
        const cval = x.EvalTraitEfkSum(code, false);
        accum += cval;
    }
    accum.clamp(0,100)/100.0;
    return accum;
}
}


////////////////////////////////////////////////////////
if(PluginManager._scripts.includes("SoR_TimeDurationBuffState_MZ_Alpha") || PluginManager._scripts.includes("SoR_TimeDurationBuffState_MZ_Beta")){
const SoR_PSE5_GBB_correctBuffDuration = Game_BattlerBase.prototype.correctBuffDuration;
Game_BattlerBase.prototype.correctBuffDuration = function(type) {
    const base = SoR_PSE5_GBB_correctBuffDuration.call(this, type);
    let cval = type==0? this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_BUFF_DURATIONEXTEND, true) : this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_DEBUFF_DURATIONEXTEND, true);
    let test = base+cval/100.0;
    if(test<0)test = 0;
    return test;
}

const SoR_PSE5_GBB_correctStateDuration = Game_BattlerBase.prototype.correctStateDuration;
Game_BattlerBase.prototype.correctStateDuration = function(type) {
    const base = SoR_PSE5_GBB_correctStateDuration.call(this, type);
    let cval = type==5? this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_GOODSTATE_DURATIONEXTEND, false) : this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_BADSTATE_DURATIONEXTEND, true);
    let test = base+cval/100.0;
    if(test<0)test = 0;
    return test;
}
const SoR_PSE5_GBB_correctRegenDuration = Game_BattlerBase.prototype.correctRegenDuration;
Game_BattlerBase.prototype.correctRegenDuration = function(type) {
    const base = SoR_PSE5_GBB_correctRegenDuration.call(this, type);
    let cval = type==3? this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_REGEN_INTERVALEXTEND, true) : this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_SLIP_INTERVALEXTEND, true);
    let test = base+cval/100.0;
    if(test<0)test = 0;
    return test;
}

const SoR_PSE5_GBB_correctBuffDurationAdd = Game_BattlerBase.prototype.correctBuffDurationAdd;
Game_BattlerBase.prototype.correctBuffDurationAdd = function(type) {
    const base = SoR_PSE5_GBB_correctBuffDuration.call(this, type);
    let cval = type==0? this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_BUFF_DURATIONEXTEND, false) : this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_DEBUFF_DURATIONEXTEND, false);
    let test = base+cval;
    if(test<0)test = 0;
    return test;
}
const SoR_PSE5_GBB_correctStateDurationAdd = Game_BattlerBase.prototype.correctStateDurationAdd;
Game_BattlerBase.prototype.correctStateDurationAdd = function(type) {
    const base = SoR_PSE5_GBB_correctStateDurationAdd.call(this, type);
    let cval = type==5? this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_GOODSTATE_DURATIONEXTEND, false) : this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_BADSTATE_DURATIONEXTEND, false);
    let test = base+cval;
    if(test<0)test = 0;
    return test;
}
const SoR_PSE5_GBB_correctRegenDurationAdd = Game_BattlerBase.prototype.correctRegenDurationAdd;
Game_BattlerBase.prototype.correctRegenDurationAdd = function(type) {
    const base = SoR_PSE5_GBB_correctRegenDurationAdd.call(this, type);
    let cval = type==0? this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_BUFF_DURATIONEXTEND, false) : this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_SoR_DEBUFF_DURATIONEXTEND, false);
    let test = base+cval;
    if(test<0)test = 0;
    return test;
}
}


/////////////////////////////////////////////////////////////////////////////////////
function PSVScriptFunctionConverter(command){
    command = command.replace(/LeftHPRate/ig, "this.hp/this.mhp");
    command = command.replace(/LeftHP/ig, "this.hp");
    command = command.replace(/LeftMPRate/ig, "this.mp/this.mmp");
    command = command.replace(/LeftMP/ig, "this.mp");
    command = command.replace(/LeftTP/ig, "this.tp");
    command = command.replace(/LeftTPRate/ig, "this.tp/this.maxTp()");
    command = command.replace(/Level/ig, "this.level");
    command = command.replace(/IsState\[(\d+)\]/ig, (_, p1) => {return "this.isStateAffected("+ p1 +")"});
    command = command.replace(/aliveParty/ig, "$gameParty.aliveMembers().length");
    command = command.replace(/aliveTroop/ig, "$gameTroop.aliveMembers().length");
    command = command.replace(/aliveFriend/ig, "this.friendsUnit.aliveMembers().length");
    command = command.replace(/aliveOpponent/ig, "this.opponentsUnit.aliveMembers().length");
    command = command.replace(/Turn/ig, "$gameTroop._turnCount");
    if(PluginManager._scripts.includes("SoR_BattleTimeCounter_MZ")) command = command.replace(/Time/ig, "BattleManager._getRawCurrentBTCounter()");
    return command;
}
/////////////////////////////////////////////////////////////////////////////////////

function SoR_EvalBSS(ev, gb) {
    ev = ev.replace(/this/g, "gb");
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("gb",sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)(gb);
    return res;
}
})();