//=============================================================================
// SoR_PassiveStatusEffects4_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.02 (2021/10/15)
//=============================================================================
/*:ja
@plugindesc ＜パッシブスキル機能 - サブ3＞ v1.03
@author 蒼竜
@target MZ
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@url https://dragonflare.blue/dcave/
@help 《パッシブスキル機能 - サブ3》
※要 97.「パッシブスキル機能 - メイン」(SoR_PassiveStatusEffects_MZ.js)

所持・習得しているだけでステータスボーナス等の追加補助効果を
バトラー(アクター)に付与する機能を実装します。

本プラグインは、「パッシブスキル機能 - メイン」の土台機能に
RPGツクールの標準搭載"ではない"広義のパッシブスキル機能
(指定系統スキルの効果強化・拡張)を実装します。
*/
/*:
@plugindesc <Passive Skill System - Sub3> v1.03
@author Soryu
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help <<<Passive Skill SUB Plugin 3>>>
[Prerequisite] 97. SoR_PassiveStatusEffects_MZ

This plugin implements a passible skill system which provides
battlers (actors) some effects such as status bonus.
This sub plugin provide extra system beyond the default RMMZ design
(Buff activation and status correction under designated conditions).
*/
(function() {
if(!PluginManager._scripts.includes("SoR_PassiveStatusEffects_MZ")) throw new Error("[SoR_PassiveStatusEffects4_MZ] This plugin REQUIRES SoR_PassiveStatusEffects_MZ.");
const pluginName = "SoR_PassiveStatusEffects4_MZ";

Game_BattlerBase.TRAIT_ELEM_MAG_DAMUP = 100051;
Game_BattlerBase.TRAIT_ELEM_PHY_DAMUP = 100052;
Game_BattlerBase.TRAIT_WEAP_MAG_DAMUP = 100053;
Game_BattlerBase.TRAIT_WEAP_PHY_DAMUP = 100054;

Game_BattlerBase.TRAIT_ELEM_MAG_DAMDOWN = 100055;
Game_BattlerBase.TRAIT_ELEM_PHY_DAMDOWN = 100056;
Game_BattlerBase.TRAIT_WEAP_MAG_DAMDOWN = 100057;
Game_BattlerBase.TRAIT_WEAP_PHY_DAMDOWN = 100058;

Game_BattlerBase.TRAIT_MAG_HEALUP = 100059;
Game_BattlerBase.TRAIT_WEAP_HEALUP = 100060;

Game_BattlerBase.TRAIT_ALWAYS_STATE = 100061;

Game_BattlerBase.TRAIT_TARGET_DAMUP = 100062;

////////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE4_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_PSE4_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagPSE4", target: ["skill","weapon","armor","state"]};
    this._SoRTagProcessFuncs.push(q);
}

const tag = /<(?:PSVEMDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag2 = /<(?:PSVEPDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag3 = /<(?:PSVWMDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag4 = /<(?:PSVWPDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond

const tag5 = /<(?:PSVEMDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag6 = /<(?:PSVEPDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag7 = /<(?:PSVWMDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag8 = /<(?:PSVWPDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond

const tag2_1 = /<(?:PSVAllEMDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag2_2 = /<(?:PSVAllEPDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag2_3 = /<(?:PSVAllWMDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag2_4 = /<(?:PSVAllWPDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond

const tag2_5 = /<(?:PSVAllEMDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag2_6 = /<(?:PSVAllEPDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag2_7 = /<(?:PSVAllWMDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond
const tag2_8 = /<(?:PSVAllWPDamDown):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond

const tag3_1 = /<(?:PSVMHealUp):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str prob cond
const tag3_2 = /<(?:PSVPHealUp):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str prob cond

const tag4_1 = /<(?:PSVAlwaysState):[ ]*(.*),[ ]*(.*)>/i;//val cond

const tag5_1 = /<(?:PSVSkillDamUp):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//id val prob cond

DataManager.SoRTagPSE4_init = function(obj) {
}
DataManager.SoRTagPSE4 = function(obj, line) {
    let MatchFlag = false;
    const passiveEffects = obj.passiveEffects;

    let ret = MatchPassiveEffects_ELEMDamageControl(line, tag, Game_BattlerBase.TRAIT_ELEM_MAG_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_ELEMDamageControl(line, tag2, Game_BattlerBase.TRAIT_ELEM_PHY_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_ELEMDamageControl(line, tag5, Game_BattlerBase.TRAIT_ELEM_MAG_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_ELEMDamageControl(line, tag6, Game_BattlerBase.TRAIT_ELEM_PHY_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }

    ret = MatchPassiveEffects_ELEMDamageControl2(line, tag2_1, Game_BattlerBase.TRAIT_ELEM_MAG_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_ELEMDamageControl2(line, tag2_2, Game_BattlerBase.TRAIT_ELEM_PHY_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_ELEMDamageControl2(line, tag2_5, Game_BattlerBase.TRAIT_ELEM_MAG_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_ELEMDamageControl2(line, tag2_6, Game_BattlerBase.TRAIT_ELEM_PHY_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }

    ret = MatchPassiveEffects_TargetDamageControl(line, tag5_1, Game_BattlerBase.TRAIT_TARGET_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }




    ret = MatchPassiveEffects_WEAPONDamageControl(line, tag3, Game_BattlerBase.TRAIT_WEAP_MAG_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_WEAPONDamageControl(line, tag4, Game_BattlerBase.TRAIT_WEAP_PHY_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_WEAPONDamageControl(line, tag7, Game_BattlerBase.TRAIT_WEAP_MAG_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_WEAPONDamageControl(line, tag8, Game_BattlerBase.TRAIT_WEAP_PHY_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }

    ret = MatchPassiveEffects_WEAPONDamageControl2(line, tag2_3, Game_BattlerBase.TRAIT_WEAP_MAG_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_WEAPONDamageControl2(line, tag2_4, Game_BattlerBase.TRAIT_WEAP_PHY_DAMUP);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_WEAPONDamageControl2(line, tag2_7, Game_BattlerBase.TRAIT_WEAP_MAG_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }
    ret = MatchPassiveEffects_WEAPONDamageControl2(line, tag2_8, Game_BattlerBase.TRAIT_WEAP_PHY_DAMDOWN);
    if(ret!=null){
        passiveEffects.push(ret);
        return true;
    }


    ret = MatchPassiveEffects_HEALControl(line, tag3_1, Game_BattlerBase.TRAIT_MAG_HEALUP);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }

    ret = MatchPassiveEffects_HEALControl(line, tag3_2, Game_BattlerBase.TRAIT_WEAP_HEALUP);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }


    ret = MatchPassiveEffects_AlwaysState(line, tag4_1, Game_BattlerBase.TRAIT_ALWAYS_STATE);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }

    return MatchFlag;
}


////////////////////////////////////////////////////////////////////////////////////
function MatchPassiveEffects_ELEMDamageControl(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        let Pidx = -1;
        if(!Number.isNaN(testint)){
            if(testint>=0 && testint < $dataSystem.elements.length){
                pe.Param = testint;
            }
        }
        else{
            Pidx = $dataSystem.elements.findIndex( x => x == teststr.toLowerCase());
            if(Pidx!=-1){
                pe.Param = Pidx;
            }
        }

        pe.prob = Number(RegExp.$3);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$4);
        const reg_val = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (pe.Param !=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}

function MatchPassiveEffects_ELEMDamageControl2(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: 0,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);

        pe.prob = Number(RegExp.$2);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$3);
        const reg_val = String(RegExp.$1);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (pe.Param !=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}

////////////////////////////////////////////////////////////////////////////////////
function MatchPassiveEffects_WEAPONDamageControl(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        let Pidx = -1;
        if(!Number.isNaN(testint)){
            if(testint>=0 && testint < $dataSystem.weaponTypes.length){
                pe.Param = testint;
            }
        }
        else{
            Pidx = $dataSystem.weaponTypes.findIndex( x => x == teststr.toLowerCase());
            if(Pidx!=-1){
                pe.Param = Pidx;
            }
        }

        pe.prob = Number(RegExp.$3);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$4);
        const reg_val = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (pe.Param !=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}

function MatchPassiveEffects_WEAPONDamageControl2(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        let Pidx = -1;
        if(!Number.isNaN(testint)){
            if(testint>=0 && testint < $dataSystem.weaponTypes.length){
                pe.Param = testint;
            }
        }
        else{
            Pidx = $dataSystem.weaponTypes.findIndex( x => x == teststr.toLowerCase());
            if(Pidx!=-1){
                pe.Param = Pidx;
            }
        }

        pe.prob = Number(RegExp.$3);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$4);
        const reg_val = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (pe.Param !=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}



function MatchPassiveEffects_TargetDamageControl(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        let Pidx = -1;
        if(!Number.isNaN(testint)){
            if(testint>=0 && testint < $dataSkills.length){
                pe.Param = testint;
            }
        }

        pe.prob = Number(RegExp.$3);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$4);
        const reg_val = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (pe.Param !=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}
////////////////////////////////////////////////////////////////////////////////////

function MatchPassiveEffects_HEALControl(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: 0,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        pe.prob = Number(RegExp.$2);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$3);
        const reg_val = String(RegExp.$1);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (pe.Param !=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}
    return null;
}


function MatchPassiveEffects_AlwaysState(line, maintag, cd) {
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: 0,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        pe.Param = !Number.isNaN(testint)? testint: -1;

        const condtx = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        if (pe.Param !=-1){
            pe.effect = 1;
            return pe; //valid
        }
	}

    return null;
}



////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE4_GA_evalDamageFormula = Game_Action.prototype.evalDamageFormula;
Game_Action.prototype.evalDamageFormula = function(target) {
    const base = SoR_PSE4_GA_evalDamageFormula.call(this,...arguments);
    const result = this.SoR_PSVDamageCorrection(target, base);
    return result;
}

Game_Action.prototype.SoR_PSVDamageCorrection = function(target, base) {
    let psvefc = 0, psvefc2 = 0, psvefc3 = 0, psvefc4 = 0;

    const elem = this.item().damage.elementId;
    const type = this.isPhysical()? 1 : this.isMagical()? -1 : 0;

    if(this.checkDamageType([1, 5])){//damage
        if(elem>=1 && type==-1){
            psvefc = this.subject().testPassiveDamageBoost(Game_BattlerBase.TRAIT_ELEM_MAG_DAMUP, elem) - target.testPassiveDamageBoost(Game_BattlerBase.TRAIT_ELEM_MAG_DAMDOWN, elem);
            psvefc2 = this.subject().testPassiveDamageBoost2(Game_BattlerBase.TRAIT_ELEM_MAG_DAMUP, elem) - target.testPassiveDamageBoost2(Game_BattlerBase.TRAIT_ELEM_MAG_DAMDOWN, elem);
        }
        else if(elem>=1 && type==1){
            psvefc = this.subject().testPassiveDamageBoost(Game_BattlerBase.TRAIT_ELEM_PHY_DAMUP, elem) - target.testPassiveDamageBoost(Game_BattlerBase.TRAIT_ELEM_PHY_DAMDOWN, elem);
            psvefc2 = this.subject().testPassiveDamageBoost2(Game_BattlerBase.TRAIT_ELEM_PHY_DAMUP, elem) - target.testPassiveDamageBoost2(Game_BattlerBase.TRAIT_ELEM_PHY_DAMDOWN, elem);
        }
        else if(elem<=1 && type==-1){
            psvefc = this.subject().testPassiveDamageBoost(Game_BattlerBase.TRAIT_WEAP_MAG_DAMUP, elem) - target.testPassiveDamageBoost(Game_BattlerBase.TRAIT_WEAP_MAG_DAMDOWN, elem);
            psvefc2 = this.subject().testPassiveDamageBoost2(Game_BattlerBase.TRAIT_WEAP_MAG_DAMUP, elem) - target.testPassiveDamageBoost2(Game_BattlerBase.TRAIT_WEAP_MAG_DAMDOWN, elem);
        }
        else if(elem<=1 && type==1){
            psvefc = this.subject().testPassiveDamageBoost(Game_BattlerBase.TRAIT_WEAP_PHY_DAMUP, elem) - target.testPassiveDamageBoost(Game_BattlerBase.TRAIT_WEAP_PHY_DAMDOWN, elem);
            psvefc2 = this.subject().testPassiveDamageBoost2(Game_BattlerBase.TRAIT_WEAP_PHY_DAMUP, elem) - target.testPassiveDamageBoost2(Game_BattlerBase.TRAIT_WEAP_PHY_DAMDOWN, elem);
        }

        if(base+psvefc<=0) psvefc=-base;
        if(psvefc2<=-1.0) psvefc2=-1.0;
    }
    else if(this.checkDamageType([3])){
        if(type==1){
           psvefc = this.subject().testPassiveDamageBoost(Game_BattlerBase.TRAIT_WEAP_HEALUP, elem);
           psvefc2 = this.subject().testPassiveDamageBoost2(Game_BattlerBase.TRAIT_WEAP_HEALUP, elem);
        }
        else if(type==-1){
           psvefc = this.subject().testPassiveDamageBoost(Game_BattlerBase.TRAIT_MAG_HEALUP, elem);
           psvefc2 = this.subject().testPassiveDamageBoost2(Game_BattlerBase.TRAIT_MAG_HEALUP, elem);
        }
    }

    psvefc3 = this.subject().testPassiveDamageBoost3(Game_BattlerBase.TRAIT_TARGET_DAMUP, this.item().id)
    psvefc4 = this.subject().testPassiveDamageBoost4(Game_BattlerBase.TRAIT_TARGET_DAMUP, this.item().id)

    const newdam = Math.floor(Math.floor((base+psvefc+psvefc3)*(1.0+psvefc2))*(1.0+psvefc4));
    return newdam;
}

Game_BattlerBase.prototype.testPassiveDamageBoost = function(type, elemId) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const psvvals = this.paramPassiveEffects(type, elemId, false, 0);// add constant
    const psvvals2 = this.paramPassiveConds(type, elemId, false, 0);// add constant
    const psvvals3 = this.paramPassiveEffects(type, 0, false, 0);//
    const psvvals4 = this.paramPassiveConds(type, 0, false, 0);//
    const psval = (psvvals + psvvals2 + psvvals3 + psvvals4);

    return psval;
}

Game_BattlerBase.prototype.testPassiveDamageBoost2 = function(type, elemId) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const psvvals = this.paramPassiveEffects(type, elemId, true, 0);// add constant
    const psvvals2 = this.paramPassiveConds(type, elemId, true, 0);// add constant
    const psvvals3 = this.paramPassiveEffects(type, 0, true, 0);// 
    const psvvals4 = this.paramPassiveConds(type, 0, true, 0);// 
    const psval = (psvvals + psvvals2 + psvvals3 + psvvals4)/100.0;

    return psval;
}

Game_BattlerBase.prototype.testPassiveDamageBoost3 = function(type, skillId) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const psvvals = this.paramPassiveEffects(type, skillId, false, 0);// add constant
    const psvvals2 = this.paramPassiveConds(type, skillId, false, 0);// add constant
    const psval = psvvals + psvvals2;

    return psval;
}
Game_BattlerBase.prototype.testPassiveDamageBoost4 = function(type, skillId) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const psvvals = this.paramPassiveEffects(type, skillId, true, 0);//
    const psvvals2 = this.paramPassiveConds(type, skillId, true, 0);// 
    const psval = (psvvals + psvvals2)/100.0;

    return psval;
}
/////////////////////////////////////////////////////////////////////////////////////

const SoR_PSE4_GU_PSVobserver = Game_Party.prototype.PSVobserver;
Game_Party.prototype.PSVobserver = function() {
    SoR_PSE4_GU_PSVobserver.call(this);
    for (const member of this.members()) {
        member.performPassiveAlwaysEffects();
    }
}

Game_BattlerBase.prototype.performPassiveAlwaysEffects = function() {
    const stateId = this.testPassiveAlwaysEffect(Game_BattlerBase.TRAIT_ALWAYS_STATE);
    if(stateId!=false){
        if (!this.isStateAffected(stateId)) {
            this.addNewState(stateId);
            this.refresh();
        }
    }
}


Game_BattlerBase.prototype.testPassiveAlwaysEffect = function(value) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const psvcands = this.PassiveEffectObj();
    let allcands = [];
    for(const x of psvcands){
        const cands = x.passiveEffects.filter((data)=>data.code == value);
        allcands = allcands.concat(cands);
    }
    allcands.sort((a,b)=> a.Param-b.Param);

    let test=-1;
    for(const cand of allcands){
        if(test == cand.Param) continue;
        let cval = this.PassiveEfkSum(value, cand.Param, false);
        if(cval > 0) return cand.Param;
        test = cand.Param;
    }

    return false;
}


/////////////////////////////////////////////////////////////////////////////////////
function PSVScriptFunctionConverter(command){
    command = command.replace(/LeftHPRate/ig, "this.hp/this.mhp");
    command = command.replace(/LeftHP/ig, "this.hp");
    command = command.replace(/LeftMPRate/ig, "this.mp/this.mmp");
    command = command.replace(/LeftMP/ig, "this.mp");
    command = command.replace(/LeftTP/ig, "this.tp");
    command = command.replace(/LeftTPRate/ig, "this.tp/this.maxTp()");
    command = command.replace(/Level/ig, "this.level");
    command = command.replace(/IsState\[(\d+)\]/ig, (_, p1) => {return "this.isStateAffected("+ p1 +")"});
    command = command.replace(/aliveParty/ig, "$gameParty.aliveMembers().length");
    command = command.replace(/aliveTroop/ig, "$gameTroop.aliveMembers().length");
    command = command.replace(/aliveFriend/ig, "this.friendsUnit.aliveMembers().length");
    command = command.replace(/aliveOpponent/ig, "this.opponentsUnit.aliveMembers().length");
    command = command.replace(/Turn/ig, "$gameTroop._turnCount");
    if(PluginManager._scripts.includes("SoR_BattleTimeCounter_MZ")) command = command.replace(/Time/ig, "BattleManager._getRawCurrentBTCounter()");
    return command;
}
/////////////////////////////////////////////////////////////////////////////////////

function SoR_EvalBSS(ev, gb) {
    ev = ev.replace(/this/g, "gb");
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("gb",sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)(gb);
    return res;
}
})();