//=============================================================================
// SoR_PassiveStatusEffects3_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2021/09/17)
//=============================================================================
/*:ja
@plugindesc ＜パッシブスキル機能 - サブ2＞ v1.00
@author 蒼竜
@target MZ
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@url https://dragonflare.blue/dcave/
@help 《パッシブスキル機能 - サブ2》
※要 97.「パッシブスキル機能 - メイン」(SoR_PassiveStatusEffects_MZ.js)

所持・習得しているだけでステータスボーナス等の追加補助効果を
バトラー(アクター)に付与する機能を実装します。

本プラグインは、「パッシブスキル機能 - メイン」の土台機能に
RPGツクールの標準搭載"ではない"広義のパッシブスキル機能
(特定状況下でのバフ・ステータス補正発動)を実装します。
*/
/*:
@plugindesc <Passive Skill System - Sub2> v1.00
@author Soryu
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help <<<Passive Skill SUB Plugin 2>>>
[Prerequisite] 97. SoR_PassiveStatusEffects_MZ

This plugin implements a passible skill system which provides
battlers (actors) some effects such as status bonus.
This sub plugin provide extra system beyond the default RMMZ design
(Buff activation and status correction under designated conditions).
*/
(function() {
if(!PluginManager._scripts.includes("SoR_PassiveStatusEffects_MZ")) throw new Error("[SoR_PassiveStatusEffects3_MZ] This plugin REQUIRES SoR_PassiveStatusEffects_MZ.");
const pluginName = "SoR_PassiveStatusEffects3_MZ";

Game_BattlerBase.TRAIT_OPENBATTLE_BUFF = 100031;
Game_BattlerBase.TRAIT_OPENBATTLE_STATE = 100032;
Game_BattlerBase.TRAIT_OPENBATTLE_SKILLS = 100033;
Game_BattlerBase.TRAIT_COND_BASE_PARAM = 100034;
Game_BattlerBase.TRAIT_COND_BASE_XPARAM = 100035;
Game_BattlerBase.TRAIT_COND_BASE_SPARAM = 100036;
Game_BattlerBase.TRAIT_COND_ELEMRATE = 100037;
Game_BattlerBase.TRAIT_COND_DEBUFFRATE = 100038;
Game_BattlerBase.TRAIT_COND_STATERATE = 100039;

Game_BattlerBase.TRAIT_COND_SINGLE_EFFECT = 100041;
Game_BattlerBase.TRAIT_COND_SKILL_EFFECT = 100042;

const baseParams = ["mhp", "mmp", "atk", "def", "mat", "mdf", "agi", "luk"];
const XParams = ["hit", "eva", "cri", "cev", "mev", "mrf", "cnt", "hrg", "mrg", "trg",
                 "mhrg", "mmrg", "mtrg", "exp"]; //107-110
const SParams = ["tgr", "grd", "rec", "pha", "mcr", "tcr", "pdr", "mdr", "fdr", "exr"];

////////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE3_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_PSE3_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagPSE3", target: ["skill","weapon","armor","state"]};
    this._SoRTagProcessFuncs.push(q);
}

//const params = ["invalid", "reflect", "evade", "guard", "revenge", "charge", "counter", "knockback"];
const tag = /<(?:PSVBattleStartBuff):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag2 = /<(?:PSVBattleStartState):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str prob cond
const tag3 = /<(?:PSVBattleStartSkill):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//val prob cond

const tag4 = /<(?:PSVCondParam):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//param val cond
const tag5 = /<(?:PSVCondElemRate):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//param val cond
const tag6 = /<(?:PSVCondStateRate):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//param val cond
const tag7 = /<(?:PSVCondDebuffRate):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//param val cond

const tag2_1 = /<(?:PSVCondEffect):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/;//param val cond
//const tag2_2 = /<(?:PSVCondSkill):[ ]*(.*),[ ]*(.*),[ ]*(.*)>/;//param cond//

DataManager.SoRTagPSE3_init = function(obj) {}
DataManager.SoRTagPSE3 = function(obj, line) {
    let MatchFlag = false;
    const passiveEffects = obj.passiveEffects;

    let ret = MatchPassiveEffects_OpenCombat(line, tag);
    if(ret!=null){
        passiveEffects.push(ret);
            return true;
    }

    ret = MatchPassiveEffects_OpenCombat2(line, tag2);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }

    ret = MatchPassiveEffects_OpenCombat3(line, tag3);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }

    ret = MatchPassiveEffects_CondParams(line, tag4);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }

    ret = MatchPassiveEffects_CondElemRate(line, tag5);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }
    ret = MatchPassiveEffects_CondStateRate(line, tag6);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }
    ret = MatchPassiveEffects_CondDebuffRate(line, tag7);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }

    ret = MatchPassiveEffects_CondSkillEffect1(line, tag2_1);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }
/*
    ret = MatchPassiveEffects_CondSkillEffect2(line, tag2_2);
        if(ret!=null){
            passiveEffects.push(ret);
            return true;
        }
*/
    return MatchFlag;
}



//buff
function MatchPassiveEffects_OpenCombat(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_OPENBATTLE_BUFF,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const Pidx = baseParams.findIndex( x => x == teststr.toLowerCase());
        pe.Param = Pidx;

        pe.effect = Number(RegExp.$2);
        if(Number.isNaN(pe.effect)) pe.effect = 0;

        pe.prob = Number(RegExp.$3);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$4);
        pe.cond = condtx? condtx.trim() : "true";

        if(!Number.isNaN(Pidx) && Pidx>=0){
            return pe;
        }
	}

    return null;
}


//state
function MatchPassiveEffects_OpenCombat2(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_OPENBATTLE_STATE,
            Param: null,
            effect: 1,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const Pidx = Number(teststr);
        pe.Param = Pidx;

        pe.prob = Number(RegExp.$2);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$3);
        pe.cond = condtx? condtx.trim() : "true";

        if(!Number.isNaN(Pidx) && Pidx>=0){
            return pe;
        }
	}

    return null;
}

//skills
function MatchPassiveEffects_OpenCombat3(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_OPENBATTLE_SKILLS,
            Param: null,
            effect: 1,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const Pidx = Number(teststr);
        pe.Param = Pidx;//skillID

        pe.prob = Number(RegExp.$2);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$3);
        pe.cond = condtx? condtx.trim() : "true";

        if(!Number.isNaN(Pidx) && Pidx>=1){
            return pe;
        }
	}

    return null;
}

//cond baseparams
function MatchPassiveEffects_CondParams(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: 0,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        let Pidx = baseParams.findIndex( x => x == teststr.toLowerCase());
        if(Pidx!=-1){
            pe.Param = Pidx;
            pe.code = Game_BattlerBase.TRAIT_COND_BASE_PARAM;
        }
        else {
            Pidx = XParams.findIndex( x => x == teststr.toLowerCase());
            if(Pidx!=-1){
                pe.Param = Pidx;
                pe.code = Game_BattlerBase.TRAIT_COND_BASE_XPARAM;
            }
            else {
                Pidx = SParams.findIndex( x => x == teststr.toLowerCase());
                if(Pidx!=-1){
                    pe.Param = Pidx;
                    pe.code = Game_BattlerBase.TRAIT_COND_BASE_SPARAM;
                }
            }
        }
        
        const reg_val = String(RegExp.$2);
        const condtx = String(RegExp.$3);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (Pidx!=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}

    return null;
}

//cond elem rate
function MatchPassiveEffects_CondElemRate(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_COND_ELEMRATE,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        let Pidx = -1;
        if(!Number.isNaN(testint)){
            if(testint>=0 && testint < $dataSystem.elements.length){
                pe.Param = Pidx;
            }
        }
        else{
            Pidx = $dataSystem.elements.findIndex( x => x == teststr.toLowerCase());
            if(Pidx!=-1){
                pe.Param = Pidx;
            }
        }

        const condtx = String(RegExp.$3);
        const reg_val = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";


        const tag_t = /([+,-]?\d+)?(%)?/;
        if (Pidx!=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }

	}

    return null;
}


//cond state rate
function MatchPassiveEffects_CondStateRate(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_COND_STATERATE,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        let Pidx = -1;
        if(!Number.isNaN(testint)){
            if(testint>=0 && testint < $dataStates.length){
                pe.Param = Pidx;
            }
        }
        else{
            Pidx = $dataStates.findIndex( x => x.name == teststr.toLowerCase());
            if(Pidx!=-1){
                pe.Param = Pidx;
            }
        }

        const condtx = String(RegExp.$3);
        const reg_val = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (Pidx!=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }
	}

    return null;
}

//cond debuff rate
function MatchPassiveEffects_CondDebuffRate(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_COND_DEBUFFRATE,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        let Pidx = -1;
        if(!Number.isNaN(testint)){
            if(testint>=0 && testint < baseParams.length){
                pe.Param = Pidx;
            }
        }
        else{
            Pidx = baseParams.findIndex( x => x == teststr.toLowerCase());
            if(Pidx!=-1){
                pe.Param = Pidx;
            }
        }

        const condtx = String(RegExp.$3);
        const reg_val = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        const tag_t = /([+,-]?\d+)?(%)?/;
        if (Pidx!=-1 && reg_val.match(tag_t)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }
	}

    return null;
}

//////////////////////////////////////////////////////////////

//cond skill
function MatchPassiveEffects_CondSkillEffect1(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_COND_SINGLE_EFFECT,
            Param: null,
            effect: 1,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        if(!Number.isNaN(testint)){
            if(testint>=0){
                pe.Param = testint; //target
            }
        }

        const ttest = Math.floor(RegExp.$2.trim());
        const times = Number.isNaN(ttest)? 1 : ttest<=0? 1 : ttest;
        pe.Param += 10000*times;
        const condtx = String(RegExp.$3);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";
        if (testint!=-1){
            console.log(pe);
            return pe; //valid
        }
	}

    return null;
}

function MatchPassiveEffects_CondSkillEffect2(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: Game_BattlerBase.TRAIT_COND_SKILL_EFFECT,
            Param: null,
            effect: 1,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const teststr = RegExp.$1.trim();
        const testint = Number(teststr);
        if(!Number.isNaN(testint)){
            if(testint>=0){
                pe.Param = testint; //target
            }
        }

        pe.Param += 10000*1;//Math.floor(RegExp.$2);// times
        const condtx = String(RegExp.$2);
        pe.cond = condtx? PSVScriptFunctionConverter(condtx.trim()) : "true";

        if (testint!=-1){
            return pe; //valid
        }
	}

    return null;
}




const SoR_PSE3_BM_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
    SoR_PSE3_BM_initMembers.call(this);
    this._openCombat_PSVactSkills = [];
}


const SoR_PSE3_BM_activatePSVSkills_onStart = BattleManager.activatePSVSkills_onStart;
BattleManager.activatePSVSkills_onStart = function() {
    SoR_PSE3_BM_activatePSVSkills_onStart.call(this);
    if(this._openCombat_PSVactSkills.length == 0) return;
    this.invokePSV_onStart();
}


BattleManager.invokePSV_onStart = function() {
    const revskl = this._openCombat_PSVactSkills.shift();
    const newsub = revskl.tar;
    const action = new Game_Action(newsub);
    action.passiveActivated = true;
    action.setSkill(revskl.skl);

    let targets;
    if(action.isValidTarget_PSVopenbattle(newsub)){
        targets = [newsub];
    }
    else targets = action.testTarget_PSVopenbattle();
    if(targets[0]) action.setTarget(targets[0].index());

    this._subject = newsub;
    this._phase = "turn";
    this._action = action;
    this._action._SoR_ActionCounter = 0; //////
    this._subject._actions = [this._action];
    this._targets = targets;
}

const SoR_PSE3_GU_PSVobserver = Game_Unit.prototype.PSVobserver;
Game_Party.prototype.PSVobserver = function() {
    SoR_PSE3_GU_PSVobserver.call(this);
    for (const member of this.members()) {
        member.performPassiveCondEffects();
        //member.performPassiveCondSkillAct();
    }
}



Game_Action.prototype.isValidTarget_PSVopenbattle = function(testtarget) {
    const all = this.itemTargetCandidates();
    return all.some(x=> x.isActor() == testtarget.isActor() && x.index() == testtarget.index());
}

Game_Action.prototype.testTarget_PSVopenbattle = function() {
    const targets = [];
    if (!this._forcing && this.subject().isConfused()) {
        targets.push(this.confusionTarget());
    } else if (this.isForEveryone()) {
        targets.push(...this.targetsForEveryone());
    } else if (this.isForOpponent()) {
        targets.push(...this.targetsForOpponents());
    } else if (this.isForFriend()) {
        targets.push(...this.targetsForFriends());
    }
    return this.repeatTargets(targets);
}

const SoR_PSE3_GU_startBattle = Game_Unit.prototype.onBattleStart;
Game_Unit.prototype.onBattleStart = function(advantageous) {
    SoR_PSE3_GU_startBattle.call(this,...arguments);
    for (const member of this.members()) {
        member.processPSE_onstartBattle();
        member.initPSV_condeffects();
    }
}

Game_Battler.prototype.initPSV_condeffects = function() {
    this._PSVcondEffects = {};
    this._PSVcondSkills = {};
}

Game_Battler.prototype.processPSE_onstartBattle = function() {
    if(!this.PSE_isforActor()) return;
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return; //ignore psv effects

    if(this.isAlive()){//buff-state
        const nbp = baseParams.length;
        for(let i=0; i< nbp; i++){
            const res = this.testPassiveonBattleStart(i, Game_BattlerBase.TRAIT_OPENBATTLE_BUFF);
            if(res>0){
                const cnt = res;
                for(let j=0; j<cnt;j++) this.increaseBuff(i);
            }
            else if(res<0){
                const cnt = -res;
                for(let j=0; j<cnt;j++) this.decreaseBuff(i);
            }
        }

        const nst = $dataStates.length;
        for(let i=0; i< nst; i++){
            const res = this.testPassiveonBattleStart(i, Game_BattlerBase.TRAIT_OPENBATTLE_STATE);
            if(res>0) this.addState(i);
        }

        const skls = this.testPassiveSkillonBattleStart();
        if(skls.length>0) BattleManager._openCombat_PSVactSkills = BattleManager._openCombat_PSVactSkills.concat(skls);
    }
}

Game_BattlerBase.prototype.testPassiveonBattleStart = function(value,op) {
    //if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
    const cval = this.PassiveEfkSum(op, value, false);
    return cval;
}

Game_BattlerBase.prototype.testPassiveSkillonBattleStart = function() {
    //if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return []; //ignore psv effects
    const activateSkls = [];

    const psvcands = this.PassiveEffectObj();
    let allcands = [];
    for(const x of psvcands){
        const cands = x.passiveEffects.filter((data)=>data.code == Game_BattlerBase.TRAIT_OPENBATTLE_SKILLS);
        allcands = allcands.concat(cands);
    }
    allcands.sort((a,b)=> a.Param-b.Param);

    let test=-1;
    for(const cand of allcands){
        if(test == cand.Param) continue;

        let cval = this.PassiveEfkSum(Game_BattlerBase.TRAIT_OPENBATTLE_SKILLS, cand.Param, false);
        if(cval > 0) activateSkls.push({skl: cand.Param, tar: this});
        test = cand.Param;
    } 

    return activateSkls;
}





//////////////////////////////////////////////////////////////////////////
////Conditional
Game_BattlerBase.prototype.paramPassiveConds = function(code, paramId, proportional, op) {
    if(!$gameParty.inBattle()) return 0;
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    let subcd;
    if(code == Game_BattlerBase.TRAIT_BASE_PARAM) subcd = Game_BattlerBase.TRAIT_COND_BASE_PARAM;
    else if(code == Game_BattlerBase.TRAIT_XPARAM) subcd = Game_BattlerBase.TRAIT_COND_BASE_XPARAM;
    else if(code == Game_BattlerBase.TRAIT_SPARAM) subcd = Game_BattlerBase.TRAIT_COND_BASE_SPARAM;
    else if(code == Game_BattlerBase.TRAIT_ELEMENT_RATE) subcd = Game_BattlerBase.TRAIT_COND_ELEMRATE;
    else if(code == Game_BattlerBase.TRAIT_DEBUFF_RATE) subcd = Game_BattlerBase.TRAIT_COND_DEBUFFRATE;
    else if(code == Game_BattlerBase.TRAIT_STATE_RATE) subcd = Game_BattlerBase.TRAIT_COND_STATERATE;

    if(op==0) return this.PassiveEfkSum(subcd, paramId, proportional);
    else if(op==1) return this.PassiveEfkPi(subcd, paramId, proportional);
}

Game_BattlerBase.prototype.performPassiveCondEffects = function() {
    const res = this.testPassiveCondEffect(Game_BattlerBase.TRAIT_COND_SINGLE_EFFECT);
    if(res!=false){
        const sid = res.skl%10000;
        const cnt = parseInt(res.skl/10000);
        const action = new Game_Action(this);
        action.setSkill(sid);
        action.apply(this);
        console.log(action);

        if(typeof this._PSVcondEffects[sid] === "undefined") this._PSVcondEffects[sid]=0;
        this._PSVcondEffects[sid]++;
    }
}

Game_BattlerBase.prototype.testPassiveCondEffect = function(value) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const psvcands = this.PassiveEffectObj();
    let allcands = [];
    for(const x of psvcands){
        const cands = x.passiveEffects.filter((data)=>data.code == value && 
        typeof this._PSVcondEffects[data.Param%10000] === "undefined" || this._PSVcondEffects[data.Param%10000] < this._PSVcondEffects[Math.floor(data.Param/10000)]
        );
        allcands = allcands.concat(cands);
    }
    allcands.sort((a,b)=> a.Param-b.Param);

    let test=-1;
    for(const cand of allcands){
        if(test == cand.Param%10000) continue;
        let cval = this.PassiveEfkSum(value, cand.Param, false);
        if(cval > 0) return {skl: cand.Param, tar: this};
        test = cand.Param;
    }

    return false;
}

/*
Game_BattlerBase.prototype.performPassiveCondSkillAct = function() {
    const res = this.testPassiveCondSkills(Game_BattlerBase.TRAIT_COND_SKILL_EFFECT);
    if(res!=false){
        const sid = res.skl%10000;
        const cnt = parseInt(res.skl/10000);
        const action = new Game_Action(this);
        action.setSkill(sid);
        action.apply(this);

        if(typeof this._PSVcondSkills[sid] === "undefined") this._PSVcondSkills[sid]=0;
        this._PSVcondSkills[sid]++;
    }
}

Game_BattlerBase.prototype.testPassiveCondSkills = function(value) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const psvcands = this.PassiveEffectObj();
    let allcands = [];
    for(const x of psvcands){
        const cands = x.passiveEffects.filter((data)=>data.code == value && 
        typeof this._PSVcondSkills[data.Param%10000] === "undefined" || this._PSVcondSkills[data.Param%10000] < this._PSVcondSkills[Math.floor(data.Param/10000)]
        );
        allcands = allcands.concat(cands);
    }
    allcands.sort((a,b)=> a.Param-b.Param);

    let test=-1;
    for(const cand of allcands){
        if(test == cand.Param%10000) continue;
        let cval = this.PassiveEfkSum(value, cand.Param, false);
        if(cval > 0) return {skl: cand.Param, tar: this};
        test = cand.Param;
    }

    return false;
}

BattleManager.invokePSV_ConditionalSkillAct = function() {
    this._PSVprevented_subject = {subject: this._subject, actions: this._subject._actions.slice()};

    const revskl = this._action._PSVreact_revenge.shift();
    const newsub = revskl.tar;
    const action = new Game_Action(newsub);
    action.passiveActivated = true;
    action.setSkill(revskl.skl);

    let oldsub = [this._subject];
    const targets = oldsub.slice();

    this._subject = newsub;
    this._phase = "turn";
    this._action = action;
    this._subject._actions = [this._action];
    this._targets = targets;
}*/


Game_Battler.prototype.PSE_isforActor = function() {
    return this.isActor();
}

/////////////////////////////////////////////////////////////////////////////////////
function PSVScriptFunctionConverter(command){
    command = command.replace(/LeftHPRate/ig, "this.hp/this.mhp");
    command = command.replace(/LeftHP/ig, "this.hp");
    command = command.replace(/LeftMPRate/ig, "this.mp/this.mmp");
    command = command.replace(/LeftMP/ig, "this.mp");
    command = command.replace(/LeftTP/ig, "this.tp");
    command = command.replace(/LeftTPRate/ig, "this.tp/this.maxTp()");
    command = command.replace(/Level/ig, "this.level");
    command = command.replace(/IsState\[(\d+)\]/ig, (_, p1) => {return "this.isStateAffected("+ p1 +")"});
    command = command.replace(/aliveParty/ig, "$gameParty.aliveMembers().length");
    command = command.replace(/aliveTroop/ig, "$gameTroop.aliveMembers().length");
    command = command.replace(/aliveFriend/ig, "this.friendsUnit.aliveMembers().length");
    command = command.replace(/aliveOpponent/ig, "this.opponentsUnit.aliveMembers().length");
    command = command.replace(/Turn/ig, "$gameTroop._turnCount");
    if(PluginManager._scripts.includes("SoR_BattleTimeCounter_MZ")) command = command.replace(/Time/ig, "BattleManager._getRawCurrentBTCounter()");
    return command;
}

function SoR_EvalBSS(ev, gb) {
    ev = ev.replace(/this/g, "gb");
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("gb",sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)(gb);
    return res;
}
})();