//=============================================================================
// SoR_PassiveStatusEffects2_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.10 (2022/03/04)
//=============================================================================
/*:ja
@plugindesc ＜パッシブスキル機能 - サブ1＞ v1.10
@author 蒼竜
@target MZ
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@url https://dragonflare.blue/dcave/
@help 《パッシブスキル機能 - サブ1》
※要 97.「パッシブスキル機能 - メイン」(SoR_PassiveStatusEffects_MZ.js)

所持・習得しているだけでステータスボーナス等の追加補助効果を
バトラー(アクター)に付与する機能を実装します。

本プラグインは、「パッシブスキル機能 - メイン」の土台機能に
RPGツクールの標準搭載"ではない"広義のパッシブスキル機能
(アクションに反応して起こる効果)を実装します。

@param --オートガード--
@param AutoGuardState
@desc 自動防御用ステートID (通常の「防御」とは独立したものを作成して適用すること)
@type state
@param --特殊アクション反応--
@param ExceptionRule
@desc スキル動作に関する下記パラメータ設定の反映ルール
@type select
@option 除外(指定したものだけ無効にする)
@value 0
@option 許可(指定しなかったものを無効にする)
@value 1
@default 0

@param DamageRevenge_Skills
@desc (ExceptionRuleに基づいて)指定スキルによる被ダメージ時反撃反応設定
@type skill[]
@default []
@param EvadeRevenge_Skills
@desc (ExceptionRuleに基づいて)指定スキルによる回避後反撃反応設定
@type skill[]
@default []
@param ForceEvade_Skills
@desc (ExceptionRuleに基づいて)指定スキルによる強制回避反応設定
@type skill[]
@default []
@param ReflectDamage_Skills
@desc (ExceptionRuleに基づいて)指定スキルによるダメージ反射反応設定
@type skill[]
@default []
@param AidDamage_Skills
@desc (ExceptionRuleに基づいて)指定スキルによる非ダメージ時回復反応設定
@type skill[]
@default []
*/
/*:
@plugindesc <Passive Skill System - Sub1> v1.10
@author Soryu
@orderAfter SoR_PassiveStatusEffects_MZ
@base SoR_PassiveStatusEffects_MZ
@target MZ
@url https://dragonflare.blue/dcave/index_e.php
@help <<<Passive Skill SUB Plugin 1>>>
[Prerequisite] 97. SoR_PassiveStatusEffects_MZ

This plugin implements a passible skill system which provides
battlers (actors) some effects such as status bonus.
This sub plugin provide extra system beyond the default RMMZ design
(especially reaction to attacks).

@param --Auto Guard--
@param AutoGuardState
@desc State ID for Auto Guard (Must be independent of the "default" guard state.)
@type state
@param -Reaction Effects-
@param ExceptionRule
@desc Rule of reaction to activate for following parameter settings
@type select
@option Eliminate (Designated skills are not reacted)
@value 0
@option Include (NOT Designated skills are not reacted)
@value 1
@default 0

@param DamageRevenge_Skills
@desc Skills causes the revenge actions (Based on "ExceptionRule")
@type skill[]
@default []
@param EvadeRevenge_Skills
@desc Skills causes the revenge actions in evasion (Based on "ExceptionRule")
@type skill[]
@default []
@param ForceEvade_Skills
@desc Skills causes the evade action (Based on "ExceptionRule")
@type skill[]
@default []
@param ReflectDamage_Skills
@desc Skills causes the HP damage reflection (Based on "ExceptionRule")
@type skill[]
@default []
@param AidDamage_Skills
@desc Skills causes the first-aid effects (Based on "ExceptionRule")
@type skill[]
@default []
*/
(function() {
if(!PluginManager._scripts.includes("SoR_PassiveStatusEffects_MZ")) throw new Error("[SoR_PassiveStatusEffects2_MZ] This plugin REQUIRES SoR_PassiveStatusEffects_MZ.");
const pluginName = "SoR_PassiveStatusEffects2_MZ";
const Param = PluginManager.parameters(pluginName);

const AutoGuardState = Number(Param['AutoGuardState'] || 0);
const ExceptionRule = Number(Param['ExceptionRule'] || 0);
const DamageRevenge_Skills = convertJsonParam(Param['DamageRevenge_Skills']) || '';
const EvadeRevenge_Skills = convertJsonParam(Param['EvadeRevenge_Skills']) || '';
const ForceEvade_Skills = convertJsonParam(Param['ForceEvade_Skills']) || '';
const ReflectDamage_Skills = convertJsonParam(Param['ReflectDamage_Skills']) || '';
const AidDamage_Skills = convertJsonParam(Param['AidDamage_Skills']) || '';

function convertJsonParam(param) {
	if (param == undefined) return [];
	let arr = [];
		JSON.parse(param).map(function(param) {
			arr.push(param);
		});
	return arr;
}

Game_BattlerBase.TRAIT_DAMAGE_INVALID = 100010;
Game_BattlerBase.TRAIT_DAMAGE_REFLECT = 100011;
Game_BattlerBase.TRAIT_DAMAGE_EVADE = 100012;
Game_BattlerBase.TRAIT_DAMAGE_GUARD = 100013;
Game_BattlerBase.TRAIT_DAMAGE_REVENGE = 100014;
Game_BattlerBase.TRAIT_DAMAGE_CHARGE = 100015;
Game_BattlerBase.TRAIT_DAMAGE_EVADECOUTNER = 100016;
Game_BattlerBase.TRAIT_DAMAGE_AIDH = 100017;
Game_BattlerBase.TRAIT_DAMAGE_AIDM = 100018;
Game_BattlerBase.TRAIT_DAMAGE_AIDT = 100019;
Game_BattlerBase.TRAIT_DAMAGE_KNOCK = 100020;

Game_BattlerBase.TRAIT_DEFFENCE_RECOVER = 100021;
Game_BattlerBase.TRAIT_EVCOUNTER_EVBOOST = 100022;
Game_BattlerBase.TRAIT_REVENGE_BOOST = 100023;

const loopids = [];
for(let i= 100010; i<=100020; i++) loopids.push(i);

////////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE2_DM_initializeSoRTagProcessor = DataManager.initializeSoRTagProcessor;
DataManager.initializeSoRTagProcessor = function() {
    SoR_PSE2_DM_initializeSoRTagProcessor.call(this);
    const q = {name: "SoRTagPSE2", target: ["skill","weapon","armor","state"]};
    this._SoRTagProcessFuncs.push(q);
}

const params = ["invalid", "reflect", "evade", "guard", "revenge", "charge", "evcounter", "firstaid", "firstaidMP", "firstaidTP", "knockback"];
const tag = /<(?:PSVReactAttack):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//str val prob cond
const tag2 = /<(?:PSVGuardEffect):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//param val prob cond
//v1.10
const tag3 = /<(?:PSVEvadeCounterBoost):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//param val prob cond
const tag4 = /<(?:PSVRevengeBoost):[ ]*(.*),[ ]*(.*),[ ]*(.*),[ ]*(.*)>/i;//param val prob cond


//obj.passiveEffects
DataManager.SoRTagPSE2_init = function(obj) {}
DataManager.SoRTagPSE2 = function(obj, line) {
    let MatchFlag = false;
    const passiveEffects = obj.passiveEffects;

    for(const x of loopids){
        let ret = MatchPassiveEffects2(line, tag, params, x);
        if(ret!=null){
            passiveEffects.push(ret);
            MatchFlag = true;
            break;
        }
    }
    if(!MatchFlag){
        let ret = MatchPassiveEffects2_guard(line, tag2);
        if(ret!=null){
            passiveEffects.push(ret);
            MatchFlag = true;
        }
    }
    if(!MatchFlag){
        let ret = MatchPassiveEffects2_evboost(line, tag3);
        if(ret!=null){
            passiveEffects.push(ret);
            MatchFlag = true;
        }
    }
    if(!MatchFlag){
        let ret = MatchPassiveEffects2_revboost(line, tag4);
        if(ret!=null){
            passiveEffects.push(ret);
            MatchFlag = true;
        }
    }

    return MatchFlag;
}

function MatchPassiveEffects2(line, maintag, ParamArr, cd) {
    const NoConsider = [3,10];
	if (line.match(maintag)) {
        const pe = {
            code: cd,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const test = ParamArr.length==0? Number(RegExp.$1) : ParamArr.indexOf(String(RegExp.$1).trim());
        pe.code = 100010 + test;
        pe.Param = test;
        const reg_val = String(RegExp.$2);
        pe.prob = Number(RegExp.$3);
        if(Number.isNaN(pe.prob)) pe.prob = 0;

        const condtx = String(RegExp.$4);
        pe.cond = condtx? condtx.trim() : "true";

        const tag_2 = /([+,-]?\d+)?(%)?/;
        if (reg_val.match(tag_2)){
            pe.effect = parseInt(RegExp.$1);
            if(NoConsider.some( x=> x==test)) pe.effect = 1;
            if(test==2 || test==4 || test==6){ pe.Param = pe.effect; pe.effect=1;}// force evade && revenge attack by skills
            else if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }
	}

    return null;
}



function MatchPassiveEffects2_guard(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: 100021,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        pe.Param = String(RegExp.$1).trim();
        const reg_val = String(RegExp.$2);
        pe.prob = Number(RegExp.$3);
        const condtx = String(RegExp.$4);
        pe.cond = condtx? condtx.trim() : "true";

        const tag_2 = /([+,-]?\d+)?(%)?/;
        if (reg_val.match(tag_2)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2) pe.proportional = true;
            return pe; //valid
        }
    }
    return null;
}


function MatchPassiveEffects2_evboost(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: 100022,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const ParamArr = ["dam", "hit", "cri"];
        const test = ParamArr.length==0? Number(RegExp.$1) : ParamArr.indexOf(String(RegExp.$1).trim());
        pe.Param = test;

        const reg_val = String(RegExp.$2);
        pe.prob = Number(RegExp.$3);
        const condtx = String(RegExp.$4);
        pe.cond = condtx? condtx.trim() : "true";

        const tag_2 = /([+,-]?\d+)?(%)?/;
        if (reg_val.match(tag_2)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2 && test == 0) pe.proportional = true;
            return pe; //valid
        }
    }
    return null;
}


function MatchPassiveEffects2_revboost(line, maintag) {
	if (line.match(maintag)) {
        const pe = {
            code: 100023,
            Param: null,
            effect: undefined,
            prob: 0,
            proportional: false,
            cond: undefined
        };

        const ParamArr = ["dam", "hit", "cri"];
        const test = ParamArr.length==0? Number(RegExp.$1) : ParamArr.indexOf(String(RegExp.$1).trim());
        pe.Param = test;

        const reg_val = String(RegExp.$2);
        pe.prob = Number(RegExp.$3);
        const condtx = String(RegExp.$4);
        pe.cond = condtx? condtx.trim() : "true";

        const tag_2 = /([+,-]?\d+)?(%)?/;
        if (reg_val.match(tag_2)){
            pe.effect = parseInt(RegExp.$1);
            if(RegExp.$2 && test == 0) pe.proportional = true;
            return pe; //valid
        }
    }
    return null;
}

////////////////////////////////////////////////////////////////////////////////////////
Game_BattlerBase.prototype.testPassiveAutoGuard = function(temporal) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return false; //ignore psv effects

    const cval = this.EvalTraitEfkMax(Game_BattlerBase.TRAIT_DAMAGE_GUARD, false);
    if(cval > 0){
        this.addState(AutoGuardState);
        this.requestMotion("guard");
    }
    else{
        this.removeState(AutoGuardState);
    }
}

const SoR_PSE2_GA_applyGlobal = Game_Action.prototype.applyGlobal;
Game_Action.prototype.applyGlobal = function() {
    if($gameParty.inBattle()) this._originTargets = BattleManager._targets.slice();
    SoR_PSE2_GA_applyGlobal.call(this);
}


BattleManager.PSVEndofActions = function() {
    if(this._action){
        if(this._action._originTargets){
            for(const x of this._action._originTargets) x.removeState(AutoGuardState);
        }

        //truely end action
        if(this._PSVprevented_subject!=null){
            this.PSVEndofCounterActions(this._PSVprevented_subject);
            this._PSVprevented_subject = null;
        }
        else if(this._action._PSVreact_revenge.length>0) this.invokePSV_SkillRevenge();

        //truely end action
        if(this._PSVprevented_subject2!=null){
            this.PSVEndofCounterActions(this._PSVprevented_subject2);
            this._PSVprevented_subject2 = null;
        }
        else if(this._action._PSVreact_counter.length>0) this.invokePSV_EvadeCounter();
    }
}


BattleManager.PSVEndofCounterActions = function(sub) {
    this._logWindow.endAction(sub.subject);
    sub.subject.setActionState(this.isTpb() ? "undecided" : "done");
    sub.subject.onAllActionsEnd();
    sub.subject.clearTpbChargeTime();
}

BattleManager.PSVCounterActions_restoreOrigin = function() {
    if(this._PSVReactActor == null) return;

    const stackid = this._PSVReactActor.isActor()? this._PSVReactActor._actorId : this._PSVReactActor._enemyId+1000;
    const data = this._PSVReactActorStack[stackid];
    this._PSVReactActor._actions = data.actions.slice();
    this._PSVReactActor._tpbState = data.tpbstate;
    this._PSVReactActor._actionState = data.actstate;
    if(this._PSVReactActor._tpbState === "casting") this._PSVReactActor._tpbCastTime = data.cat;
    if(this._PSVReactActor._tpbState === "charging") this._PSVReactActor._tpbChargeTime = data.cht;

    delete this._PSVReactActorStack[stackid];
    this._PSVReactActor = null;
}

const SoR_PSV2_BM_endBattlerActions = BattleManager.endBattlerActions;
BattleManager.endBattlerActions = function(battler) {
    SoR_PSV2_BM_endBattlerActions.call(this,...arguments);
    this.PSVCounterActions_restoreOrigin();
}




Game_BattlerBase.prototype.testPassiveReflect = function(value) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const cval = this.EvalTraitEfkMax(Game_BattlerBase.TRAIT_DAMAGE_REFLECT, false); //constant reflect (up to limit)
    const vval = this.EvalTraitEfkMax(Game_BattlerBase.TRAIT_DAMAGE_REFLECT, true); //reflect in %
    const testval = cval > vval? cval : vval;
    return testval>0? (cval >= value ? Math.floor(value) : Math.floor(cval)) + Math.floor(value*(vval*0.01)) : 0;
}

Game_BattlerBase.prototype.testPassiveDamageAid = function(value, code) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    const cval = this.EvalTraitEfkMax(code, false); //constant reflect (up to limit)
    const vval = this.EvalTraitEfkMax(code, true); //reflect in %
    const testval = cval > vval? cval : vval;
    return testval>0? (cval >= value ? Math.floor(value) : Math.floor(cval)) + Math.floor(value*(vval*0.01)) : 0;
}

Game_BattlerBase.prototype.testPassiveAbsAvoid = function() {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return false; //ignore psv effects

/*
    let cval = this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_DAMAGE_EVADE, false)*0.01;
    console.log(cval);
    cval = cval.clamp(0,1);
    if(cval > Math.random()) return true;
    else return false;
*/
    let cval = this.EvalTraitEfkSum(Game_BattlerBase.TRAIT_DAMAGE_EVADE, false)
    if(cval==1) return true;
    else return false;
}   

Game_BattlerBase.prototype.testPassiveInvalid = function(val) {
    if(val < 0) return val; //heal

    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return val; //ignore psv effects
    const cval = this.EvalTraitEfkMax(Game_BattlerBase.TRAIT_DAMAGE_INVALID, false);
    const vval = Math.floor(this.EvalTraitEfkMax(Game_BattlerBase.TRAIT_DAMAGE_INVALID, true)*0.01 * this.mhp);
    const testval = cval > vval? cval : vval;
    if(val <= testval) return 0;

    return val;//nothing else
}

//
Game_BattlerBase.prototype.testPassiveGuardEffect = function(type) {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects

    let valmax = 0;
    switch(type){
        case "hp":
        valmax = this.mhp;
        break;
        case "mp":
        valmax = this.mmp;
        break;
        case "tp":
        valmax = this.maxTp();
        break;
    }

    const psvvals = this.paramPassiveEffects(Game_BattlerBase.TRAIT_DEFFENCE_RECOVER, type, false, 0);// add constant
    const psvvals_p = Math.floor(this.paramPassiveEffects(Game_BattlerBase.TRAIT_DEFFENCE_RECOVER, type, true, 0)* 0.01 * valmax);// add propotional
    const testval = psvvals + psvvals_p;
    if(testval <= 0) return 0;
    return testval;
}


/////////////////////////////////////////////////////////////////////////////////////
Game_BattlerBase.prototype.testPassiveSkillReactCode = function(code) {
    const psvcands = this.PassiveEffectObj();
    let allcands = [];
    for(const x of psvcands){
        const cands = x.passiveEffects.filter((data)=>data.code == code);
        allcands = allcands.concat(cands);
    }
    allcands.sort((a,b)=> a.Param-b.Param);

    let test=-1;
    for(const cand of allcands){
        if(test == cand.Param) continue;

        let cval = this.PassiveEfkSum_PSE2(code, cand.Param, false);
        if(cval > 0) return {skl: cand.Param, tar: this};
    
        test = cand.Param;
    }

    return false;
}

Game_BattlerBase.prototype.testPassiveRevengeAct = function() {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
    return this.testPassiveSkillReactCode(Game_BattlerBase.TRAIT_DAMAGE_REVENGE);
}
Game_BattlerBase.prototype.testPassiveEvadeATKAct = function() {
    if(this._states.some((x)=> $dataStates[x].meta.VanishAllPassive)) return 0; //ignore psv effects
    return this.testPassiveSkillReactCode(Game_BattlerBase.TRAIT_DAMAGE_EVADECOUTNER);
}
/////////////////////////////////////////////////////////////////////////////////////

Game_BattlerBase.prototype.PassiveEfkSum_PSE2 = function(code, id, proportional) {// Σ
    return this.PassiveWithTraits_PSE2(code, id, proportional).reduce((r, efk) => r + efk.effect, 0);
}
Game_BattlerBase.prototype.PassiveWithTraits_PSE2 = function(code, id, proportional) {
    return this.allPassiveEffects().filter(//get effects which meat with conditions
        obj => {
            if( obj.code === code && obj.Param === id && obj.proportional === proportional && SoR_EvalBSS(obj.cond, this)){
                if(obj.prob <= 0) return true;
                if(Math.random() <= obj.prob) return true;
            }
            return false;
        }
    );
}



/////////////////////////////////////////////////////////////////////////////////////


if(PluginManager._scripts.includes("SoR_AttackAccuracyManager_MZ")){
    const SoR_PSE2_GA_DefaultHitControl = Game_Action.prototype.DefaultHitControl;
    Game_Action.prototype.DefaultHitControl = function(target, current) {
        const orig = SoR_PSE2_GA_DefaultCriControl.call(this,...arguments);
        let corr = 0;
        if(this.psvReact){
            if(this.psvReact == "evc") corr = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_EVCOUNTER_EVBOOST,1,false)*0.01;
            else if(this.psvReact == "rev") corr = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_REVENGE_BOOST,1,false)*0.01;
        }

        return orig + corr;
    }
}

if(PluginManager._scripts.includes("SoR_CriticalAttackManager_MZ")){
    const SoR_PSE2_GA_DefaultCriControl = Game_Action.prototype.DefaultCriControl;
    Game_Action.prototype.DefaultCriControl = function(target, current) {
        const orig = SoR_PSE2_GA_DefaultCriControl.call(this,...arguments);
        let corr = 0;
        if(this.psvReact){
            if(this.psvReact == "evc") corr = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_EVCOUNTER_EVBOOST,2,false)*0.01;
            else if(this.psvReact == "rev") corr = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_REVENGE_BOOST,2,false)*0.01;
        }

        return orig + corr;
    }
}


const SoR_PSE2_GA_correctDamageValue = Game_Action.prototype.correctDamageValue;
Game_Action.prototype.correctDamageValue = function(target, value, IsCri) {
    let newval = SoR_PSE2_GA_correctDamageValue.call(this,...arguments);

    if(this.psvReact){
        let corr1 = 0, corr2 = 0;
        if(this.psvReact == "evc"){
            corr1 = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_EVCOUNTER_EVBOOST,0,false);
            corr2 = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_EVCOUNTER_EVBOOST,0,true)*0.01;
        }
        else if(this.psvReact == "rev"){
            corr1 = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_REVENGE_BOOST,0,false);
            corr2 = this.subject().PassiveEfkSum_PSE2(Game_BattlerBase.TRAIT_REVENGE_BOOST,0,true)*0.01;
        }
        newval = (newval+corr1)+Math.floor(newval*(1.0+corr2));
    }
    return newval;
}


/////////////////////////////////////////////////////////////////////////////////////
const SoR_PSE2_GA_clear = Game_Action.prototype.clear;
Game_Action.prototype.clear = function() {
    SoR_PSE2_GA_clear.call(this);
    this._PSVreact_revenge = [];
    this._PSVreact_counter = [];
}

const SoR_PSE2_GA_makeDamageValue = Game_Action.prototype.makeDamageValue;
Game_Action.prototype.makeDamageValue = function(target, critical) {
    target.testPassiveAutoGuard(this.temporalGuard);
    const prev = SoR_PSE2_GA_makeDamageValue.call(this, ...arguments);
    const newval = target.testPassiveInvalid(prev);
    return newval;
}

const SoR_PSE2_GA_executeDamage = Game_Action.prototype.executeDamage;
Game_Action.prototype.executeDamage = function(target, value) {
    SoR_PSE2_GA_executeDamage.call(this,...arguments);
    if (this.checkDamageType([1,5])) {//not HP heal
        
        if(canActivatePSVActions(this.item().id,3)){
            const reflectval = target.testPassiveReflect(value);
            if(reflectval>0){
                this.executeHpDamage(this.subject(), reflectval);
                if (this.subject().isDead()) this.subject().performCollapse();
            }
        }
        
        if(canActivatePSVActions(this.item().id,4)){
            const valH = target.testPassiveDamageAid(value, Game_BattlerBase.TRAIT_DAMAGE_AIDH);
            const valM = target.testPassiveDamageAid(value, Game_BattlerBase.TRAIT_DAMAGE_AIDM);
            const valT = target.testPassiveDamageAid(value, Game_BattlerBase.TRAIT_DAMAGE_AIDT);

            if(valH>0||valM>0||valT>0){
                const bl = BattleManager._logWindow;
                const ts = target._sprite();
                const issprite = target.isSpriteVisible();
                if(valH>0){
                    target.setHp(target.hp + valH);
                    if (issprite){
                        if(PluginManager._scripts.includes("SoR_AlternativeDamagePopup_MZ")) ts.createDamageSprite_I(valH,1);
                        else ts.createDamageSprite_PSV2(valH,0);
                    }
                    target.performRecovery();
                    //bl.addText(bl.makeHpDamageText(target));
                }
                if(valM>0){
                    target.setMp(target.mp + valM);
                    if (issprite){
                        if(PluginManager._scripts.includes("SoR_AlternativeDamagePopup_MZ")) ts.createDamageSprite_I(valM,3);
                        else ts.createDamageSprite_PSV2(valM,1);
                    }
                    target.performRecovery();
                    //bl.addText(bl.makeMpDamageText(target));
                }
                if(valT>0){
                    target.setTp(target.tp + valT);
                    if (issprite) ts.createDamageSprite_PSV2(valT,2);
                    target.performRecovery();
                    //bl.addText(bl.makeTpDamageText(target));
                }
            }
        }

        if(canActivatePSVActions(this.item().id,0)){
            if(this._PSVreact_revenge.length==0){
                const res = target.testPassiveRevengeAct();///revenge prepare
                if(res!=false) this._PSVreact_revenge.push(res);
            }
        }

    }
}

const SoR_PSE2_GA_apply_finalzeBeforeHit = Game_Action.prototype.apply_finalzeBeforeHit;
if(typeof SoR_PSE2_GA_apply_finalzeBeforeHit === "function"){
Game_Action.prototype.apply_finalzeBeforeHit = function(target,result) {
    let res = SoR_PSE2_GA_apply_finalzeBeforeHit.call(this,...arguments);
    if (res.isHit() && result.hpDamage >= 0){

        if(canActivatePSVActions(this.item().id,2)){
            if(this.forceAvoid_psv2(target)) res.evaded = true;
        }
    }
    return res;
}
Game_Action.prototype.forceAvoid_psv2 = function(target,result) {
    return target.testPassiveAbsAvoid();
}

//evade counter
const SoR_PSE2_GA_apply_executeProcessMiss = Game_Action.prototype.executeProcessMiss;
Game_Action.prototype.executeProcessMiss = function(target, result) {
    SoR_PSE2_GA_apply_executeProcessMiss.call(this,...arguments);

    if(canActivatePSVActions(this.item().id,1)){
        if(this._PSVreact_counter.length==0){
            const res = target.testPassiveEvadeATKAct();///evade counter prepare
            if(res!=false) this._PSVreact_counter.push(res);
        }
    }
}
}

 

const SoR_PSE2_GA_apply_FinalizeAfterApply = Game_Action.prototype.FinalizeAfterApply;
if(typeof SoR_PSE2_GA_apply_FinalizeAfterApply === "function"){
Game_Action.prototype.FinalizeAfterApply = function(target, result) {
    SoR_PSE2_GA_apply_FinalizeAfterApply.call(this,...arguments);
    if(this.isGuard()) this.guardEffect_psv2(target, result);
}

Game_Action.prototype.guardEffect_psv2 = function(target,result) {
    const valhp = target.testPassiveGuardEffect("hp");
    const valmp = target.testPassiveGuardEffect("mp");
    const valtp = target.testPassiveGuardEffect("tp");
    if(valhp > 0) target.gainHp(valhp);
    if(valmp > 0) target.gainMp(valmp);
    if(valtp > 0) target.gainTp(valtp);
}

}


const SoR_PSE2_BM_startBattle = BattleManager.startBattle;
BattleManager.startBattle = function() {
    SoR_PSE2_BM_startBattle.call(this);
    this.Init_PSVtmpActions();
}

BattleManager.Init_PSVtmpActions = function() {
    this._PSVprevented_subject = null;
    this._PSVprevented_subject2 = null;
    this._PSVReactActor = null;
    this._PSVReactActorStack = {};
}

BattleManager.invokePSV_EvadeCounter = function(subject, target) {
    this._PSVprevented_subject2 = {subject: this._subject, actions: this._subject._actions.slice()};
    const revskl = this._action._PSVreact_counter.shift();
    this.preparePSV_AlternativeSkill(revskl, "evc");
}

BattleManager.invokePSV_SkillRevenge = function() {
    this._PSVprevented_subject = {subject: this._subject, actions: this._subject._actions.slice()};
    const revskl = this._action._PSVreact_revenge.shift();
    this.preparePSV_AlternativeSkill(revskl, "rev");
}

BattleManager.preparePSV_AlternativeSkill = function(revskl, type) {
    const newsub = revskl.tar;
    const action = new Game_Action(newsub);

    const stackid = newsub.isActor()? newsub._actorId : newsub._enemyId+1000;
    this._PSVReactActor = newsub;
    this._PSVReactActorStack[stackid] = {
        actions : newsub._actions? newsub._actions.slice() : [],
        actstate : newsub._actionState,
        tpbstate : newsub._tpbState,
        cat: newsub._tpbCastTime,
        cht: newsub._tpbChargeTime
    };
    newsub._tpbState = "waiting";

    action.passiveActivated = true;
    action.setSkill(revskl.skl);
    action.psvReact = type;

    let oldsub = [this._subject];
    const targets = oldsub.slice();
	
	action._targetIndex = targets[0].index();

    this._subject = newsub;
    this._phase = "turn";
    this._action = action;
    this._subject._actions = [this._action];
    this._targets = targets;
}
 

/////////////////////////////////////////////////////////////////////////////////////
function canActivatePSVActions(id, type){
    let ret;
    if(type==0){
        ret = DamageRevenge_Skills.some(x=> x==id);
        if(ExceptionRule==0) ret = !ret;
    }
    else if(type==1){
        ret = EvadeRevenge_Skills.some(x=> x==id);
        if(ExceptionRule==0) ret = !ret;
    }
    else if(type==2){
        ret = ForceEvade_Skills.some(x=> x==id);
        if(ExceptionRule==0) ret = !ret;
    }
    else if(type==3){
        ret = ReflectDamage_Skills.some(x=> x==id);
        if(ExceptionRule==0) ret = !ret;
    }
    else if(type==4){
        ret = AidDamage_Skills.some(x=> x==id);
        if(ExceptionRule==0) ret = !ret;
    }

    return ret;
}

/////////////////////////////////////////////////////////////////////////////////////
//map: battler object -> battler sprite
Game_Battler.prototype._sprite = function() {
    if(BattleManager._spriteset!=null) return BattleManager._spriteset.findTargetSprite(this);
    return null;
}

Sprite_Battler.prototype.createDamageSprite_PSV2 = function(val,type) {
    const last = this._damages[this._damages.length - 1];
    const sprite = new Sprite_Damage_PSV2(val,type);
    if (last) {
        sprite.x = last.x + 8;
        sprite.y = last.y - 16;
    } else {
        sprite.x = this.x + this.damageOffsetX();
        sprite.y = this.y + this.damageOffsetY();
    }
    sprite.setup(this._battler);
    this._damages.push(sprite);
    this.parent.addChild(sprite);
}



function Sprite_Damage_PSV2() {
    this.initialize(...arguments);
}
Sprite_Damage_PSV2.prototype = Object.create(Sprite_Damage.prototype);
Sprite_Damage_PSV2.prototype.constructor = Sprite_Damage_PSV2;
Sprite_Damage_PSV2.prototype.initialize = function(val,type) {
    Sprite_Damage.prototype.initialize.call(this);
    this._value = val;
    this._type = type;
}
Sprite_Damage_PSV2.prototype.setup = function(target) {
    if (this._type==0) {
        this._colorType = 1;
        this.createDigits(this._value);
    } else if (this._type==1) {
        this._colorType = 3;
        this.createDigits(this._value);
    }
}

/////////////////////////////////////////////////////////////////////////////////////
function SoR_EvalBSS(ev, gb) {
    ev = ev.replace(/this/g, "gb");
    const sentence = "return (" + ev + ");";
    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("gb",sentence));
    }     
    const res = $gameTemp.SoRTmp_script.get(sentence)(gb);
    return res;
}

})();