//=============================================================================
// SoR_PartyJoinIndiactor_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2021/05/24)
//=============================================================================
/*:ja
@plugindesc ＜パーティー加入・脱退インジケータ＞ v1.00
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@help イベントコマンドによる「パーティーの加入・脱退」処理について
マップ画面上でその情報を通知するUI(独自画像による演出も可)を実装します。
画面右側のレイアウト固定で、連続する「加入」「脱退」は別々
(加入・脱退アクターが一度の表示に入り混じらない)で表示されます。

導入後、明示的にプラグインコマンドを1度呼び出して
必ずインジケータを有効化する必要があります。
@param ---全般---
@param Suspend_WhlieEventRunning
@desc true: イベント実行中はインジケータ起動を一時停止する (default: true)
@default true
@type boolean

@param PartyJoinPopWindowY
@desc 描画位置Y座標(default: 360)
@default 360
@type number
@param PartyJoinPopWindowHeight
@desc ウィンドウ縦幅(default: 64)
@default 64
@type number


@param ---インジケータ土台---
@param UseImages_IndicatorBase
@desc true: 土台ラベル部分画像表示 (default: false)
@default false
@type boolean
@param IndicatorBaseText1
@desc (画像非使用時のみ) インジケータ土台ラベル"加入"テキスト (default: Member Joined)
@default Member Joined
@type string
@param IndicatorBaseText2
@desc (画像非使用時のみ) インジケータ土台ラベル"脱退"テキスト (default: Member Left)
@default Member Left
@type string
@type boolean
@param WindowSkinBaseImage1
@desc (画像使用時のみ) 参照する"加入"テキスト時画像
@type file
@dir img/SoRScenes
@param WindowSkinBaseImage2
@desc (画像使用時のみ) 参照する"脱退"テキスト画像
@type file
@dir img/SoRScenes
@param PartyJoinPopSoundSE
@desc 加入・脱退発生時に鳴らす効果音を設定します (default: 無し) 
@type struct<SEDATA>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}

@param ---アクター部分---
@param WindowStyle
@desc ウィンドウ形式 (default: 0)
@type select
@option 標準スキンによるウィンドウ
@value 0
@option 暗くする
@value 1
@option 独自画像を利用
@value 2
@default 0

@param WindowSkinImage1
@desc WindowStyleで設定したウィンドウ形式が 2.「独自画像を利用」 のときに参照する"加入"時画像
@type file
@dir img/SoRScenes
@param WindowSkinImage2
@desc WindowStyleで設定したウィンドウ形式が 2.「独自画像を利用」 のときに参照する"脱退"画像
@type file
@dir img/SoRScenes

@param PartyJoinPopWindowYpadd_originalSkin
@desc WindowStyleで設定したウィンドウ形式が 2.「独自画像を利用」 のときの縦の間隔の補正値(default: 0)
@default 0
@type number

@param PartyJoinWindow_keepDuration
@desc アクター加入脱退Popupを消去するまでの待機時間(default: 240)
@default 240
@type number
@param Multiple_PartyJoinPopSpaces
@desc アクター表示同士の縦の間隔(default: 64)
@default 64
@type number
@min 0
@param PartyJoinPopActorNameFont
@desc アクター名表示フォントサイズ(default: 18)
@default 18
@type number

@param ActorName_Xpadd
@desc アクター名表示位置x座標補正(default: 32)
@default 32
@type number
@min 0
@param ActorName_Ypadd
@desc アクター名表示位置y座標補正(default: 30)
@default 30
@type number
@min 0

@param ActorFace_Xpadd
@desc アクター顔表示x座標補正(default: -12)
@default -12
@type number
@min -999

@param ActorFaceDrawRect_Upper
@desc 顔表示領域の上端。-1のとき画像の上端
@default 72
@type number
@min -1
@param ActorFaceDrawRect_Lower
@desc 顔表示領域の下端。-1のとき画像の下端
@default 188
@type number
@min -1

@command EnablePartyJoinPopIndicator
@text 描画ON[パーティー加入・脱退インジケータ]
@desc パーティー加入・脱退判定時に、ポップアップウィンドウを表示します。
@command DisablePartyJoinPopIndicator
@text 描画OFF[パーティー加入・脱退インジケータ]
@desc パーティー加入・脱退判定時のポップアップウィンドウを無効化します。
@command ForcePartyJoinPopClear
@text 全消去 [パーティー加入・脱退インジケータ]
@desc ウィンドウに描画中のパーティー加入・脱退情報を直ちに全て消去します。
*/
/*:
@plugindesc <Party Member Join/Withdrawal Indicator> v1.00
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help This plugin observes the event command "Party Member Change"
to push an indicator of actor join and withdrawal on the map screen
(possible to decorate the indicator with original image sources).

The indicator is fixed to the right end of the screen. Join and 
withdrawal are processed separately (they never mingle in one indication).

Users are required to call a designated plugin command to activate 
the indicator at the beginning of games.
@param ---General---
@param Suspend_WhlieEventRunning
@desc If true, the indicator will be suspended while any events are running. (default: true)
@default true
@type boolean

@param PartyJoinPopWindowY
@desc Padding of the indicator for y-coordinate (default: 360)
@default 360
@type number
@param PartyJoinPopWindowHeight
@desc Height of the indicator (mainly each actor info.) (default: 64)
@default 64
@type number

@param --Indicator Base--
@param UseImages_IndicatorBase
@desc If true, indicator base (label) are composed of images. (default: false)
@default false
@type boolean
@param IndicatorBaseText1
@desc (If UseImages_IndicatorBase==false) "join" text (default: Member Joined)
@default Member Joined
@type string
@param IndicatorBaseText2
@desc (If UseImages_IndicatorBase==false) "withdrawal" text (default: Member Left)
@default Member Left
@type string
@param WindowSkinBaseImage1
@desc (If UseImages_IndicatorBase==true) image source for "join" text
@type file
@dir img/SoRScenes
@param WindowSkinBaseImage2
@desc (If UseImages_IndicatorBase==true) image source for "withdrawal" text
@type file
@dir img/SoRScenes
@param PartyJoinPopSoundSE
@desc SE to show an indicator if needed (default: none) 
@type struct<SEDATAE>
@default {"name":"","volume":"100","pitch":"100","pan":"0"}

@param ---Actor Info.---
@param WindowStyle
@desc Style of drawing actor information in the indicator (default: 0)
@type select
@option With the default window skin
@value 0
@option Dimmer window
@value 1
@option Use original image sources
@value 2
@default 0

@param WindowSkinImage1
@desc Original image source (if WindowStyle==2) for background of actor join  
@type file
@dir img/SoRScenes
@param WindowSkinImage2
@desc Original image source (if WindowStyle==2) for background of actor withdrawal
@type file
@dir img/SoRScenes

@param PartyJoinPopWindowYpadd_originalSkin
@desc (Only in WindowStyle==2) Additional padding of actor info. for y-coordinate (default: 0)
@default 0
@type number

@param PartyJoinWindow_keepDuration
@desc Duration of showing each actor info. on the indicator (default: 240)
@default 240
@type number
@param Multiple_PartyJoinPopSpaces
@desc Padding of actor info. for y-coordinate (default: 64)
@default 64
@type number
@min 0
@param PartyJoinPopActorNameFont
@desc Font size of actor info., actually actor name text (default: 18)
@default 18
@type number

@param ActorName_Xpadd
@desc Padding of actor name text for x-coordinate (default: 32)
@default 32
@type number
@min 0
@param ActorName_Ypadd
@desc Padding of actor name text for y-coordinate (default: 30)
@default 30
@type number
@min 0

@param ActorFace_Xpadd
@desc Padding of actor face image for x-coordinate (default: -12)
@default -12
@type number
@min -999

@param ActorFaceDrawRect_Upper
@desc Upper height of Trimmed Face Sprite. -1 for upper end of the face image.
@default 72
@type number
@min -1
@param ActorFaceDrawRect_Lower
@desc Lower height of Trimmed Face Sprite. -1 for lower end of the face image.
@default 188
@type number
@min -1

@command EnablePartyJoinPopIndicator
@text Enable Indicator [Party Member Join/Withdraw Indicator]
@desc Enable the indicator to activate when "Party Member Change" commands is called.
@command DisablePartyJoinPopIndicator
@text Disable Indicator [Party Member Join/Withdraw Indicator]
@desc Disable the indicator to activate when "Party Member Change" commands is called.
@command ForcePartyJoinPopClear
@text Force Clear [Party Member Join/Withdraw Indicator]
@desc Clear Immediately the indicator currently shown on the screen.
*/
/*~struct~SEDATA:
@type string
@param name
@dir audio/se/
@type file
@desc 効果音
@param volume
@desc 音量 [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc ピッチ [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc パン(位相) [-50...50]
@type number
@default 0
@min -50
@max 50
*/
/*~struct~SEDATAE:
@type string
@param name
@dir audio/se/
@type file
@desc SE File
@param volume
@desc Voulme [0...100]
@type number
@default 100
@min 0
@max 100
@param pitch
@desc Pitch [50...150]
@type number
@default 100
@min 50
@max 150
@param pan
@desc Pan [-50...50]
@type number
@default 0
@min -50
@max 50
*/

(function() {
const pluginName = "SoR_PartyJoinIndiactor_MZ";
const Param = PluginManager.parameters(pluginName);

const Suspend_WhlieEventRunning = Boolean(Param['Suspend_WhlieEventRunning'] === 'true' || false);

const UseImages_IndicatorBase = Boolean(Param['UseImages_IndicatorBase'] === 'true' || false);
const IndicatorBaseText1 = String(Param['IndicatorBaseText1'] || "");
const IndicatorBaseText2 = String(Param['IndicatorBaseText2'] || "");

const WindowSkinBaseImage1 = String(Param['WindowSkinBaseImage1'] || "");
const WindowSkinBaseImage2 = String(Param['WindowSkinBaseImage2'] || "");

const WindowLayoutSide = Number(Param['WindowLayoutSide'] || 0);
const WindowStyle = Number(Param['WindowStyle'] || 0);
const WindowSkinImage1 = String(Param['WindowSkinImage1'] || "");
const WindowSkinImage2 = String(Param['WindowSkinImage2'] || "");

const PartyJoinPop_se = convertJsonStruct(Param['PartyJoinPopSoundSE']);
const PartyJoinPopWindowY = Number(Param['PartyJoinPopWindowY'] || 560);

const PartyJoinPopWindowHeight = Number(Param['PartyJoinPopWindowHeight'] || 48);
const PartyJoinWindow_keepDuration = Number(Param['PartyJoinWindow_keepDuration'] || 400);
const Multiple_PartyJoinPopSpaces = Number(Param['Multiple_PartyJoinPopSpaces'] || 62);
const PartyJoinPopWindowYpadd_originalSkin = Number(Param['PartyJoinPopWindowYpadd_originalSkin'] || 0);
const PartyJoinPopActorNameFont = Number(Param['PartyJoinPopActorNameFont'] || 16);

const ActorFace_Xpadd = Number(Param['ActorFace_Xpadd'] || 0);
const ActorName_Xpadd = Number(Param['ActorName_Xpadd'] || 0);
const ActorName_Ypadd = Number(Param['ActorName_Ypadd'] || 0);

let SoR_PJI_Isopen = true;
const Window_LayerZ = Number(Param['Window_LayerZ'] || 0);

const ActorFaceRect_U = Number(Param['ActorFaceDrawRect_Upper'] || -1);
const ActorFaceRect_L = Number(Param['ActorFaceDrawRect_Lower'] || -1);

function convertJsonStruct(param) {
    const obj = JSON.parse(param);
    obj.volume = Number(obj.volume);
    obj.pan = Number(obj.pan);
    obj.pitch = Number(obj.pitch);
    return obj;
}


PluginManager.registerCommand(pluginName, "ForcePartyJoinClear", args => {
	$gameTemp.clearPartyJoinPopCommand();
});
PluginManager.registerCommand(pluginName, "EnablePartyJoinPopIndicator", args => {
	SoR_PJI_Isopen = true;
});
PluginManager.registerCommand(pluginName, "DisablePartyJoinPopIndicator", args => {
	SoR_PJI_Isopen = false;
});

ImageManager.loadMapSprite = function(filename) {
    return this.loadBitmap('img/SoRScenes/', filename, 0, true);
}
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

const SoR_PJI_GT_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
	SoR_PJI_GT_initialize.call(this);
    this.PartyJoinPop_ready_queue = [];
	this.PartyJoinPop_duration = 0;
	this.isPartyJoinPopForceClear = false;
	this.PartyJoinPopForceTransferClear = false;
}

//force clear
Game_Temp.prototype.clearPartyJoinPopCommand = function() {
	this.PartyJoinPop_ready_queue.length = 0;
	this.PartyJoinPop_duration = 0;
	this.isPartyJoinPopForceClear = true;
}

Game_Temp.prototype.IsPartyJoinPopClear = function() {
	return this.isPartyJoinPopForceClear;
}

Game_Temp.prototype.SoR_PartyJoinPopPush = function(obj) {
	this.PartyJoinPop_ready_queue.push(obj);
}

Game_Temp.prototype.SoR_PartyJoinPopPullHead = function() {
	let obj = null;
	if(this.SoR_PartyJoinPopQueueCount() > 0){
		obj = this.PartyJoinPop_ready_queue[0];
	}
	
	return obj;
}
Game_Temp.prototype.SoR_PartyJoinPop = function() {
	this.PartyJoinPop_ready_queue.shift();
}

Game_Temp.prototype.SoR_PartyJoinPopQueueCount = function(){
	return this.PartyJoinPop_ready_queue.length;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
const SoR_PJI_SB_initialize = Scene_Base.prototype.initialize;
Scene_Base.prototype.initialize = function() {
    SoR_PJI_SB_initialize.call(this);
		
	this.PartyJoinPop_duration = 0;
	this.PartyJoinPop_shown = [];
}

const SoR_PJI_SM_push = SceneManager.push;
SceneManager.push = function(next_scene) {
    if (this._scene instanceof Scene_Map) {
		for(let i=0; i<this._scene.PartyJoinPop_shown.length; i++){
			const obj = this._scene.PartyJoinPop_shown[i];
			obj.TempClosePartyJoinPop();
			this._scene.SoR_PartyJoinPopField.removeChild(obj);
		}
		this._scene.PartyJoinPop_shown.length = 0;
    }
	
    SoR_PJI_SM_push.call(this, next_scene);
}

const SoR_PJI_GP_reserveTransfer = Game_Player.prototype.reserveTransfer;
Game_Player.prototype.reserveTransfer = function(mapId, x, y, d, fadeType) {
    SoR_PJI_GP_reserveTransfer.call(this, mapId, x, y, d, fadeType);
	$gameTemp.PartyJoinPopForceTransferClear = true;
}

///////////////////////////////////////////////////////////////

Scene_Base.prototype.SoR_createPartyJoinPopWindow = function(scene) {
	this._scene = scene;
	this.SoR_PartyJoinPopField = new WindowLayer();
	if(Window_LayerZ==1)this.addChildAt(this.SoR_PartyJoinPopField,1);
    else if(Window_LayerZ==0)this.addChild(this.SoR_PartyJoinPopField);

	this.SoR_PartyJoinBase = new SoR_PartyJoinIndWindow();
	this.addChild(this.SoR_PartyJoinBase);
}

//
//update 
//
Scene_Base.prototype.PartyJoinPopWindowManager = function() {
	//reset for transition
	if($gameTemp.PartyJoinPopForceTransferClear || $gameTemp.IsPartyJoinPopClear()){
		for(let i=0; i<this.PartyJoinPop_shown.length; i++){
			const obj = this.PartyJoinPop_shown[i];
			this.SoR_PartyJoinPopField.removeChild(obj);
		}
		this.PartyJoinPop_shown.length = 0;
		if($gameTemp.PartyJoinPopForceTransferClear) $gameTemp.PartyJoinPopForceTransferClear = false;
		if($gameTemp.IsPartyJoinPopClear()) $gameTemp.isPartyJoinPopForceClear = false;
		return;
	}

	//create
	if($gameTemp.SoR_PartyJoinPopQueueCount()>0 && this.PartyJoinPop_duration == 0){
		const obj = $gameTemp.SoR_PartyJoinPopPullHead();
		if(obj!=null){
			if(!Suspend_WhlieEventRunning || (Suspend_WhlieEventRunning && !$gameMap.isEventRunning())){
					if(this.PartyJoinPop_shown.length==0){
						this.SoR_PartyJoinPopSetup(obj, this._scene);
						this.SoR_PartyJoinBase.startshow(obj.type);///
					}
					else{// join or left
						if(this.PartyJoinPop_shown[0]._type == obj._type) this.SoR_PartyJoinPopSetup(obj, this._scene);
					}
			}
		}
	}

	if(this.PartyJoinPop_duration>0) this.PartyJoinPop_duration--;
	
	//main update
	for(let i=0; i<this.PartyJoinPop_shown.length; i++){
		const obj = this.PartyJoinPop_shown[i];
		if(i==this.PartyJoinPop_shown.length-1){
			if(this.PartyJoinPop_duration==0){
				if($gameTemp.SoR_PartyJoinPopPullHead() == obj)	$gameTemp.SoR_PartyJoinPop();
				obj.keepDuration--;
			}
		}
		else obj.keepDuration--;
		
		this.PartyJoinPop_shown[i].shiftY(this.PartyJoinPop_shown.length-i-1);
	}

    //expire
	for(let i=0; i<this.PartyJoinPop_shown.length; i++){
		const obj = this.PartyJoinPop_shown[i];
		if(obj.keepDuration==0){
			this.SoR_PartyJoinPopField.removeChild(obj);
			this.PartyJoinPop_shown.splice(i, 1);
			i--;
		}
	}

	if(this.PartyJoinPop_shown.length==0){
		if(this.SoR_PartyJoinBase.state == "show") this.SoR_PartyJoinBase.processErase();
	}
	
}

Scene_Base.prototype.SoR_PartyJoinPopSetup = function(obj, scene){
		this.PartyJoinPop_shown.push(obj);
		this.PartyJoinPop_duration = obj.drawDuration;
		
		obj.setupPartyJoinPop(scene);
		this.SoR_PartyJoinPopField.addChild(obj);
}

////////////////////////////////////////////////////////////
// For Scene_Map
////////////////////////////////////////////////////////////
const SoR_IPW_SM_createAllWindows = Scene_Map.prototype.createAllWindows;
Scene_Map.prototype.createAllWindows = function() {
    SoR_IPW_SM_createAllWindows.call(this);
    this.SoR_createPartyJoinPopWindow('Scene_Map');
}

const SoR_IPW_SM_update = Scene_Map.prototype.update;
Scene_Map.prototype.update = function() {
	SoR_IPW_SM_update.call(this);
	this.PartyJoinPopWindowManager();
}


////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
function SoR_PartyJoinIndWindow() {
    this.initialize.apply(this, arguments);
}
SoR_PartyJoinIndWindow.prototype = Object.create(Window_Base.prototype);
SoR_PartyJoinIndWindow.prototype.constructor = SoR_PartyJoinIndWindow;
SoR_PartyJoinIndWindow.prototype.initialize = function(){
	Window_Base.prototype.initialize.call(this,new Rectangle( 0, 0, 320, PartyJoinPopWindowHeight));
	if(UseImages_IndicatorBase){
		this.joinimg = ImageManager.loadMapSprite(WindowSkinBaseImage1);
		this.leftimg = ImageManager.loadMapSprite(WindowSkinBaseImage2);
	}

	let nametxt = "";
	this.Basey = PartyJoinPopWindowY;
	this.x = Graphics.width;
	this.y = this.Basey;
	this.state = "hide";
	this.opa = 0;
	this.setBackgroundType(2);
}

SoR_PartyJoinIndWindow.prototype.startshow = function(type){
	if(type=="join") this.type = "join";
	else if(type=="left") this.type = "left";
	if(UseImages_IndicatorBase){
		this.removeChild(this.bgimg);
		this.bgimg = new Sprite(type=="join"? this.joinimg : this.leftimg);
		this.addChild(this.bgimg);
	}

	this.enter_effect = 51;
	this._text = this.type=="join" ? IndicatorBaseText1 : IndicatorBaseText2;
	this.Basey = PartyJoinPopWindowY; 
	this.x = Graphics.width - this.width;
	this.y = this.Basey - this.enter_effect;
	this.DrawMessages();
	AudioManager.playSe(PartyJoinPop_se);
	this.state = "show";

}

SoR_PartyJoinIndWindow.prototype.redrawText = function(){
	this.contents.clear();
	this.DrawMessages();
}

SoR_PartyJoinIndWindow.prototype.processErase = function(){
    this.type = "";
	this.state = "erase";
	this.enter_effect = 51;
}

SoR_PartyJoinIndWindow.prototype.finalizeErase = function(){
    this.x = Graphics.width;
	if(UseImages_IndicatorBase) this.removeChild(this.bgimg);
}

SoR_PartyJoinIndWindow.prototype.DrawMessages = function(){
	if(!UseImages_IndicatorBase){
		this.contents.fontSize = 22;
		this.resetTextColor();
		const op = this.contents.paintOpacity/512.0;
		const rgba = 'rgba(0, 0, 0, ' + op.toFixed(2) + ')' ;
		this.contents.outlineColor = rgba;
		const textState = this.createTextState(this._text, 24, 0, 0);
		this.processAllText(textState);
	}
	else{
		this.bgimg.opacity = this.opa;
	}
}

SoR_PartyJoinIndWindow.prototype.update = function(){
	Window_Base.prototype.update.call(this);
	
	if(this.state == "show"){
		if(this.enter_effect>0) this.enter_effect = Math.floor(this.enter_effect/1.25);
		this.y = this.Basey - this.enter_effect;
		this.opa = (51-this.enter_effect)*5;
		this.contents.paintOpacity = this.opa;
		this.redrawText();
		
		this.enter_effect = this.enter_effect>0? this.enter_effect-1 : 0;
	}
	else if(this.state == "erase"){
		this.opa = this.enter_effect*5;
		if(this.opa <= 0){ this.state = "hide"; this.finalizeErase();}
		this.contents.paintOpacity = this.opa;
		this.redrawText();

		this.enter_effect = this.enter_effect>0? this.enter_effect-1 : 0;
	}
}



////////////////////////////////////////////////////////////
function SoR_PartyJoinPopWindow() {
    this.initialize.apply(this, arguments);
}

SoR_PartyJoinPopWindow.prototype = Object.create(Window_Base.prototype);
SoR_PartyJoinPopWindow.prototype.constructor = SoR_PartyJoinPopWindow;

SoR_PartyJoinPopWindow.prototype.initialize = function(actor, type){
	this.bg_img = null;
	if(WindowStyle == 2){
		this.bg_img = (type==1? new Sprite(ImageManager.loadMapSprite(WindowSkinImage2)) : new Sprite(ImageManager.loadMapSprite(WindowSkinImage1)));
	}

	Window_Base.prototype.initialize.call(this,new Rectangle( 0, 0, 800, PartyJoinPopWindowHeight));
	this.type = type==0? "join" : "left";


	this.getobj = actor;
	this.face = LoadActorFaceSprite_onDatabase(actor);

	let nametxt = "";
	this._type = type;
	this.padding = -12;

	this._text = this.getobj._name;
	this.contents.fontSize = PartyJoinPopActorNameFont;
	this.drawLength = 256;
	this.drawDuration = 0;
	this.keepDuration = PartyJoinWindow_keepDuration;
	this.enter_effect = (this.type==="left"?256:512);
	this.x = Graphics.boxWidth- this.drawLength +this.enter_effect;
	this.Basey = PartyJoinPopWindowY;
	this.y = this.Basey;
	this.diffY = 0;

	this.face.x = this.drawLength - this.face.width*0.5 +ActorFace_Xpadd;
	this.addChild(this.face);
	
	this.width = this.drawLength+10;
	this.height = PartyJoinPopWindowHeight;
    this.openness = 0;
	
	if(WindowStyle == 0) this.setBackgroundType(0);
	else this.setBackgroundType(2);	//no default window
}

Object.defineProperty(SoR_PartyJoinPopWindow.prototype, "innerWidth", {
    get: function() {
        return Math.max(0, this._width);
    },
    configurable: true
});
Object.defineProperty(SoR_PartyJoinPopWindow.prototype, "innerHeight", {
    get: function() {
        return Math.max(0, this._height+10);
    },
    configurable: true
});

SoR_PartyJoinPopWindow.prototype.destroy = function(options) {}

SoR_PartyJoinPopWindow.prototype.setupPartyJoinPop = function(scene){
	this.scene_ypadd = 0;

	this.x = Graphics.boxWidth- this.drawLength + this.enter_effect;
	this.y = this.Basey + this.scene_ypadd + Multiple_PartyJoinPopSpaces;

	this.contents.clear();
	if(WindowStyle != 0) this.DrawBackground(255);
	this.DrawMessages();
	this.openness = 255;
}

SoR_PartyJoinPopWindow.prototype.TempClosePartyJoinPop = function(){
	this.openness = 0;
}

SoR_PartyJoinPopWindow.prototype.DrawMessages = function(){
	this.contents.fontSize = PartyJoinPopActorNameFont;
	this.resetTextColor();
	const textState = this.createTextState(this._text, ActorName_Xpadd, ActorName_Ypadd, 0);
	this.processAllText(textState);
}

SoR_PartyJoinPopWindow.prototype.shiftY = function(tmp_y){
	if(this.y != this.Basey + this.scene_ypadd + (tmp_y+1)*Multiple_PartyJoinPopSpaces){
		this.diffY = (this.Basey + this.scene_ypadd + (tmp_y+1)*Multiple_PartyJoinPopSpaces) - this.y;
	}
	else this.diffY = 0;
	this.changeOpacity();
}

SoR_PartyJoinPopWindow.prototype.changeOpacity = function(){
	const Eraser = this.keepDuration<=45 ? (45-this.keepDuration)*5 : 0;
	
	if(WindowStyle == 0) this.opacity = 255 - Eraser;
	if(this.opacity < 0) this.opacity = 0;
	this.contents.paintOpacity = 255 - Eraser;
	if(this.contents.paintOpacity < 0) this.contents.paintOpacity = 0;
	this.face.opacity = this.contents.paintOpacity;

	this.contents.clear();
	if(WindowStyle != 0) this.DrawBackground(this.contents.paintOpacity);
	this.DrawMessages(); 
	
	const op = this.contents.paintOpacity/512.0;
	const rgba = 'rgba(0, 0, 0, ' + op.toFixed(2) + ')' ;
	this.contents.outlineColor = rgba;
}


SoR_PartyJoinPopWindow.prototype.update = function(){
	Window_Base.prototype.update.call(this);
	
	if(this.enter_effect>0 && this.keepDuration>45) this.enter_effect = Math.floor(this.enter_effect/1.25);
	else if(this.keepDuration>45) this.enter_effect = 0;
	else this.enter_effect = (this.enter_effect-1)*1.025;

	this.x = Graphics.boxWidth- this.drawLength +this.enter_effect *(this.type==="left"?-1:1);
	this.y += Math.floor(this.diffY/2.25);
}

SoR_PartyJoinPopWindow.prototype.DrawBackground = function(opa) {
	if(WindowStyle == 1){
		const color1 = ColorManager.dimColor1();
		const color2 = ColorManager.dimColor2(); 
		const wx = Math.floor(this.width / 2);
		this.contents.fillRect(wx, 8, this.width-wx, this.height, color1);
		this.contents.gradientFillRect(0, 8, wx, this.height, color2, color1);
	}
	else{
		this.bg_img.x = 0;
		this.bg_img.y = PartyJoinPopWindowYpadd_originalSkin;
		this.bg_img.opacity = opa;
	}
}

SoR_PartyJoinPopWindow.prototype._createBackSprite = function() {
    if(WindowStyle == 2) this.addChild( this.bg_img );
	Window_Base.prototype._createBackSprite.call(this);
}





function LoadActorFaceSprite_onDatabase(actor){
	const fname = actor.faceName();
	const fidx = actor.faceIndex();
	let Face_spr;
	
    const img = ImageManager.loadFace(fname);
		Face_spr = new Sprite(img);
		const pw = ImageManager.faceWidth;
		const ph = ImageManager.faceHeight;
		
		let upp = ActorFaceRect_U;
		let low = ActorFaceRect_L;
		if(ActorFaceRect_U <= -1) upp = 0;	
		if(ActorFaceRect_L <= -1 || ActorFaceRect_L > Window_Base._faceHeight) low = ph;
		const drawarea = Math.abs(upp-low);

		Face_spr.setFrame((fidx%4) * pw, Math.floor(fidx/4)*ph, pw, drawarea);
		Face_spr.scale.x = 0.5;
		Face_spr.scale.y = 0.5;
    return Face_spr;
}

///////////////////////////////////////////////////////////////////////////////

const SoR_PJI_GI_command129 = Game_Interpreter.prototype.command129;
Game_Interpreter.prototype.command129 = function(params) {
    const actor = $gameActors.actor(params[0]);
	if(actor && SoR_PJI_Isopen){
		const target = $gameParty._actors.includes(params[0]);
		if(!(params[1]===0 ^ !target)){//tfft
			const obj = new SoR_PartyJoinPopWindow(actor,params[1]);
			$gameTemp.SoR_PartyJoinPopPush(obj);
		}
	}

	SoR_PJI_GI_command129.call(this, ...arguments);
    return true;
}


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

const SoR_PJI_ST_commandNewGame = Scene_Title.prototype.commandNewGame;
Scene_Title.prototype.commandNewGame = function() {
    SoR_PJI_Isopen = false;
    SoR_PJI_ST_commandNewGame.call(this);
}
const SoR_PJI_DM_makeSaveContents = DataManager.makeSaveContents;
DataManager.makeSaveContents = function() {
    const contents = SoR_PJI_DM_makeSaveContents.call(this);
    contents.SoRPartyJoinPop = SoR_PJI_Isopen;
    return contents;
}
const SoR_PJI_DM_extractSaveContents = DataManager.extractSaveContents;
DataManager.extractSaveContents = function(contents) {
    SoR_PJI_DM_extractSaveContents.call(this, contents);
    if(!contents.SoRPartyJoinPop) SoR_PJI_Isopen = false;
    else SoR_PJI_Isopen = contents.SoRPartyJoinPop;
}

}());