//=============================================================================
// SoR_MapNameWindow_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.10 (2021/04/25)
//=============================================================================
/*:ja
@plugindesc ＜開閉表示マップ名ウィンドウ＞ v1.10
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@help マップ名表示を，ウィンドウ開閉演出を伴った
ウィンドウ内に描画するスタイルへ変更します。

RPGツクールMVのように、セーブデータロード時にもマップ名を表示する機能を
復活させるオプションもあります。
@param ---全般設定---
@param StandardWidth
@desc マップ名ウィンドウ横幅基準値(default: 600)
@default 600
@type number
@param StandardHeight
@desc マップ名ウィンドウ縦幅基準値(default: 48)
@default 48
@type number
@param MapName_FontSize
@desc マップ名フォントサイズ、0でゲーム設定に準拠 (default: 0)
@default 0
@type number
@param Duration_ShowMapName
@desc マップ名表示時間 (default: 300)
@default 240
@type number
@param MapName_Xpadd
@desc マップ名表示x方向補正値(default: -10)
@default -10
@type number
@param MapName_Ypadd
@desc マップ名表示y方向補正値(default: -5)
@default -5
@type number

@param ---拡張設定---
@param IsShownNameOnLoadMap
@desc 'true': ゲームロード時にもマップ名表示(ツクールMV形式)　'false': 表示しない(MZ形式) (default: false)
@default false
@type boolean
@param IsOptimizeWindowWidth
@desc 'true': マップ名の長さに応じてウィンドウサイズを調整する　'false': StandardWidthで固定する (default: false)
@default false
@type boolean
@param IsKeepInMessageBusy
@desc 'true': メッセージ表示が入ってもマップ名表示を止めさせない　'false': やめさせる。MZ標準 (default: true)
@default true
@type boolean
*/
/*:
@plugiesc <Alternate Map Name Style> v1.10
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help Alternate the map name window to the style with system skin.

There is an option to restore the function that
the map name window is shown when the save data is loaded (as MV).
@param ---General---
@param StandardWidth
@desc Width of Map name Window (default: 600)
@default 600
@type number
@param StandardHeight
@desc Height of Map name Window(default: 48)
@default 48
@type number
@param MapName_FontSize
@desc Font size for map name. Set 0 to depend on the game system settings. (default: 0@default 0
@type number
@param Duration_ShowMapName
@desc Duration to show the window (default: 300)
@default 240
@type number
@param MapName_Xpadd
@desc Padding for x-coordinate of map name (default: -10)
@default -10
@type number
@param MapName_Ypadd
@desc Padding for y-coordinate of map name (default: -5)
@default -5
@type number

@param --Extension--
@param IsShownNameOnLoadMap
@desc 'true': Show map name when the save is loaded(MV style)　'false': disabled (MZ style) (default: false)
@default false
@type boolean
@param IsOptimizeWindowWidth
@desc 'true': Adjust the window width based on the map name length　'false': Fix by StandardWidth (default: false)
@default false
@type boolean
@param IsKeepInMessageBusy
@desc 'true': MapName window is not interrupted by Message Window  (default: true)
@default true
@type boolean
*/

(function() {

const Param = PluginManager.parameters('SoR_MapNameWindow_MZ');

const Standard_width = Number(Param['StandardWidth']) || 600; 
const Standard_height = Number(Param['StandardHeight']) || 48; 
const MapName_FontSize = Number(Param['MapName_FontSize']) || 0;
const Duration_ShowMapName = Number(Param['Duration_ShowMapName']) || 240;
const MapName_Xpadd = Number(Param['MapName_Xpadd']) || -10; 
const MapName_Ypadd = Number(Param['MapName_Ypadd']) || -5; 
const IsShownNameOnLoadMap = Boolean(Param['IsShownNameOnLoadMap'] === 'true') || false;
const IsOptimizeWindowWidth = Boolean(Param['IsOptimizeWindowWidth'] === 'true') || false;
const IsKeepInMessageBusy = Boolean(Param['IsKeepInMessageBusy'] === 'true') || false;

//v1.10
const BackgroundImageSource = String(Param['BackgroundImageSource']) || '';


const SpR_MNW_GT_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
    SpR_MNW_GT_initialize.call(this);
    this._openMapNameWindow = false;
}

Game_Temp.prototype.MNW_LoadBehave = function(flag) {
    this._openMapNameWindow = flag;
}

const SoR_MNW_SM_start = Scene_Map.prototype.start;
Scene_Map.prototype.start = function() {
    SoR_MNW_SM_start.call(this);
    if($gameTemp._openMapNameWindow == true){
        this._mapNameWindow.open();
        $gameTemp._openMapNameWindow = null;
    }
};


Window_MapName.prototype.initialize = function() {
    var width = this.windowWidth();
    var height = this.windowHeight();
    Window_Base.prototype.initialize.call(this, new Rectangle( Graphics.width/2-width/2, 4, width, height) );

    this.fontsize = MapName_FontSize==0? $gameSystem.mainFontSize() : MapName_FontSize;
	if(IsOptimizeWindowWidth){
	 this.width = this.OptimizeWidth();
	 this.x = Graphics.width/2-this.width/2;
	}
	
	this.opacity = 0;
    this.contentsOpacity = 0;
    this._showCount = 0;
	this.openness = 0;
	this.setBackgroundType(0);
    this.refresh();
}

Object.defineProperty(Window_MapName.prototype, "innerWidth", {
    get: function() {
        return Math.max(0, this._width);
    },
    configurable: true
});
Object.defineProperty(Window_MapName.prototype, "innerHeight", {
    get: function() {
        return Math.max(0, this._height);
    },
    configurable: true
});


Window_MapName.prototype.windowWidth = function() {
	return Standard_width;
}

Window_MapName.prototype.OptimizeWidth = function() {
	this.contents.fontSize = this.fontsize;
	const tw = this.textWidth($gameMap.displayName());
	this.resetFontSettings();
	if(tw!=0){
	 const WSrate = tw/Standard_width;
	 if(WSrate>1.0) return tw+Standard_width;
	 if(WSrate<1.0) return Standard_width*WSrate+128;
	}		
	return Standard_width;	
}

Window_MapName.prototype.windowHeight = function() { return Standard_height; };


Window_MapName.prototype.update = function() {
    Window_Base.prototype.update.call(this);
    if (this._showCount > 0 ) {
        this.updateFadeIn();
        this._showCount--;
    } else if(this.contentsOpacity > 0){
        this.updateFadeOut();
		if(this.contentsOpacity <= 0) this.close();
    }
}

Window_MapName.prototype.updateFadeIn = function() { this.contentsOpacity += 15; };
Window_MapName.prototype.updateFadeOut = function() { this.contentsOpacity -= 15; };

Window_MapName.prototype.open = function() {
	if($gameMap.isNameDisplayEnabled() && $gameTemp._openMapNameWindow != false){
		this.refresh();
		this._showCount = Duration_ShowMapName;
		Window_Base.prototype.open.call(this);
	}
    $gameTemp._openMapNameWindow = null;
}

Window_MapName.prototype.close = function() {
	Window_Base.prototype.close.call(this);
    this._showCount = 0;
}

Window_MapName.prototype.refresh = function() {
    this.contents.clear();
    if ($gameMap.displayName()) {
        var width = this.innerWidth;
        this.drawBackground(0, 0, width, this.lineHeight());
		
		this.contents.fontSize = this.fontsize;
        this.drawText($gameMap.displayName(), MapName_Xpadd, MapName_Ypadd, width, 'center');
		this.resetFontSettings();
    }
}

Window_MapName.prototype.drawBackground = function(x, y, width, height) {
    var color1 = ColorManager.dimColor1();
    var color2 = ColorManager.dimColor2();
}

////////////////////////////////////////////
// like MV
const SoR_MNW_SL_onLoadSuccess = Scene_Load.prototype.onLoadSuccess;
Scene_Load.prototype.onLoadSuccess = function() {
    $gameTemp.MNW_LoadBehave(IsShownNameOnLoadMap);
    SoR_MNW_SL_onLoadSuccess.call(this);
}

////////////////////////////////////////////
const SoR_MNW_SM_updateMapNameWindow = Scene_Map.prototype.updateMapNameWindow;
Scene_Map.prototype.updateMapNameWindow = function() {
    if(IsKeepInMessageBusy) return;
    SoR_MNW_SM_updateMapNameWindow.call(this);
}

}());