//=============================================================================
// SoR_EnemySE_Append4Others_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2021/11/10)
//=============================================================================
/*:ja
@plugindesc ＜シンボルエンカウント総合：他者対応アペンド＞ v1.50
@author 蒼竜
@target MZ
@url https://dragonflare.blue/dcave/
@orderAfter SoR_EnemySymbolEncounter_MZ
@base SoR_EnemySymbolEncounter_MZ
@help ※要 13.「シンボルエンカウント総合」(SoR_EnemySymbolEncounter_MZ.js)

「シンボルエンカウント総合」の一部機能において、
他者プラグイン機能と同調させるための修正を適用します。

他者制作プラグインの対応のため、完全に個別での受注となります。
使用したいプラグインの機能上の問題がある場合には、
サポートBBSにて随時受け付けます。

----------------------------------------------------------
対応リスト
----------------------------------------------------------
MenuSubCommand.js (サブメニューマップ使用時)
*/
/*:
@plugindesc <Symbol Encoutner System: Appendix for Others> v1.50
@author Soryu
@target MZ
@base SoR_EnemySymbolEncounter_MZ
@orderAfter SoR_EnemySymbolEncounter_MZ
@url https://dragonflare.blue/dcave/index_e.php
@help This is a SUPPLEMENTAL plugin for 13. "SoR_EnemySymbolEncounter_MZ",
to handle original system regarding enemy symbol behavior
which were introduced by any other developer's plugins.

If you have similar issues on your environment, inquiries are 
acceptable on Support BBS since the treatment can be performed individually.

----------------------------------------------------------
Target Plugins of Modification
----------------------------------------------------------
MenuSubCommand.js (under an original menu system using maps)
*/
(function() {
const pluginName = "SoR_EnemySE_Append4Others_MZ";
const Param = PluginManager.parameters(pluginName);
if(!PluginManager._scripts.includes("SoR_EnemySymbolEncounter_MZ")) throw new Error("[SoR_EnemySE_Append4Others_MZ] This APPENDIX plugin is not standalone.");


////////////////////////////////////////////////////////////////////////////
// Targets
////////////////////////////////////////////////////////////////////////////
if(PluginManager._scripts.includes("MenuSubCommand")){
    const SoR_ESE_GP_performTransfer = Game_Player.prototype.performTransfer;
    Game_Player.prototype.performTransfer = function() {
        // Coexistence with MenuSubCommand
        if($gameSystem.SoRSE_InvincibleMoveExcept()){
            if($gameTemp.invincibleAfterEnc && $gameTemp.invincibleAfterEnc >= 0) $gamePlayer.FinishInvinsibleEffectsAfterSE(false); 
        }
        SoR_ESE_GP_performTransfer.apply(this, arguments);
    }

    Game_System.prototype.SoRSE_InvincibleMoveExcept = function(){
        let flag = false;

        if($gamePlayer.isTransferringToOriginalMap()) flag = true;
        return flag;
    }
}

const SoR_SEA_GS_SoRSE_InvincibleExcept = Game_System.prototype.SoRSE_InvincibleExcept;
Game_System.prototype.SoRSE_InvincibleExcept = function(){
    let flag = SoR_SEA_GS_SoRSE_InvincibleExcept.call(this);

    if(PluginManager._scripts.includes("MenuSubCommand")){
        if($gamePlayer.isInSubCommandMap()) flag = false;
    }
	return flag;
}



})();