//=============================================================================
// SoR_EncounterTransitionEffect_MZ_Epsilon.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2021/01/25)
//=============================================================================
/*:ja
@plugindesc ＜エンカウントエフェクト＞ Type-ε v1.00
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@help エンカウント時のエフェクト(バトルシーン遷移時の画面効果)を変更します。
(※要pixi-filters.min.js)

※これは"Type-ε"です。他のTypeとは両立しません。
表示挙動の詳細はpdfドキュメントを参照してください。

@param StartBattlBGM_onTransition
@desc 'true'の時、エンカウント発生と同時に戦闘BGMを再生します。 (default: false)
@default false
@type boolean
*/ 
/*:
@plugindesc <Battle Transition Effect> Type-Epsilon v1.00
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help This plugin alternates the behavior (screen effects of transition to battle scenes)
when the player encounters enemies on the map scene.
(Require pixi-filters.min.js)

This is "Type-Epsilon" which is not compatible with other types.
See .pdf help for detail.

@param StartBattlBGM_onTransition
@desc If 'true', battle BGM plays as the moment of encounter on the map. (default: false)
@default false
@type boolean
*/


(function() {
"use strict";

const doc_elem = document.createElement('script');
doc_elem.type = 'text/javascript';
doc_elem.src = 'js/libs/pixi-filters.min.js';
doc_elem.async = false;
doc_elem._url = 'js/libs/pixi-filters.min.js'; 
document.body.appendChild(doc_elem);

 const pluginName = "SoR_EncounterTransitionEffect_MZ_Epsilon";
 const Param = PluginManager.parameters(pluginName);  
 const StartBattlBGM_onTransition = Boolean(Param['StartBattlBGM_onTransition'] === 'true' || false);


Scene_Map.prototype.startEncounterEffect = function() {
    //this._spriteset.hideCharacters();
    SceneManager.snapForBackground();
    const bg = new Bitmap(Graphics.width, Graphics.height);
    bg.fillRect(0,0, this.width, this.height, "#000000");
    this._encoutnerBGSprite = new Sprite(bg);

    this._encoutnerEffectSprite = new Sprite(SceneManager.backgroundBitmap());
    const init_Rad = Graphics.boxWidth < Graphics.boxHeight ? Graphics.boxWidth/4 : Graphics.boxHeight/4;
    this._encounterFilter = new PIXI.filters.ZoomBlurFilter(0.1,[$gamePlayer.screenX(), $gamePlayer.screenY()],init_Rad,-1,32);
    this._encounterFilter2 = new PIXI.filters.MotionBlurFilter([0,0],5,0);
    this._encounterFilter3 = new PIXI.filters.AlphaFilter();

    this._encoutnerEffectSprite.filters = [this._encounterFilter,this._encounterFilter2,this._encounterFilter3];

    this.addChild(this._encoutnerBGSprite);
    this.addChild(this._encoutnerEffectSprite);

    this._encounterEffectDuration = this.encounterEffectSpeed();
}


Scene_Map.prototype.encounterEffectSpeed = function() {
    return 64;
}

Scene_Map.prototype.updateEncounterEffect = function() {

    if (this._encounterEffectDuration > 0) {
        const Tmax = this.encounterEffectSpeed();
        const t = Tmax - this._encounterEffectDuration;
        this.updateEncounterFilter();
        if(StartBattlBGM_onTransition && t==0) BattleManager.playBattleBgm();
        if(t >= Tmax*0.7) this._encounterFilter3.alpha*=0.9;
        this._encounterEffectDuration--;
    }

}

Scene_Map.prototype.updateEncounterFilter = function() {
    this._encounterFilter2.offset+=5.5;
    this._encounterFilter2.velocity.x = (this._encounterFilter2.velocity.x*1.067)+1;

    this._encounterFilter.strength *= 1.07;
    if(this._encounterFilter.innerRadius>0) this._encounterFilter.innerRadius/=2;
    //this._encoutnerEffectSprite.scale.x *= 1.01;
    //this._encoutnerEffectSprite.scale.y *= 1.01;
}


})();