//=============================================================================
// SoR_EncounterTransitionEffect_MZ_Beta.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2021/01/25)
//=============================================================================
/*:ja
@plugindesc ＜エンカウントエフェクト＞ Type-β v1.00
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@help エンカウント時のエフェクト(バトルシーン遷移時の画面効果)を変更します。
(※要pixi-filters.min.js)

※これは"Type-β"です。他のTypeとは両立しません。
表示挙動の詳細はpdfドキュメントを参照してください。

@param StartBattlBGM_onTransition
@desc 'true'の時、エンカウント発生と同時に戦闘BGMを再生します。 (default: false)
@default false
@type boolean
*/ 
/*:
@plugindesc <Battle Transition Effect> Type-Beta v1.00
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help This plugin alternates the behavior (screen effects of transition to battle scenes)
when the player encounters enemies on the map scene.
(Require pixi-filters.min.js)

This is "Type-Beta" which is not compatible with other types.
See .pdf help for detail.

@param StartBattlBGM_onTransition
@desc If 'true', battle BGM plays as the moment of encounter on the map. (default: false)
@default false
@type boolean
*/


(function() {
"use strict";

const doc_elem = document.createElement('script');
doc_elem.type = 'text/javascript';
doc_elem.src = 'js/libs/pixi-filters.min.js';
doc_elem.async = false;
doc_elem._url = 'js/libs/pixi-filters.min.js'; 
document.body.appendChild(doc_elem);

 const pluginName = "SoR_EncounterTransitionEffect_MZ_Beta";
 const Param = PluginManager.parameters(pluginName);  
 const StartBattlBGM_onTransition = Boolean(Param['StartBattlBGM_onTransition'] === 'true' || false);

Scene_Map.prototype.startEncounterEffect = function() {
    //this._spriteset.hideCharacters();
    SceneManager.snapForBackground();
    this._encoutnerEffectSprite = new Sprite(SceneManager.backgroundBitmap());
    //this._encoutnerEffectSprite.anchor.set(0.5);
    //this._encoutnerEffectSprite.x = Graphics.boxWidth/2;
    //this._encoutnerEffectSprite.y = Graphics.boxHeight/2;

    const init_Rad = Graphics.boxWidth < Graphics.boxHeight ? Graphics.boxWidth/4 : Graphics.boxHeight/4;
    this._encounterFilter = new PIXI.filters.RadialBlurFilter(1,[Graphics.boxWidth/2, Graphics.boxHeight/2],5,init_Rad);
    this._encoutnerEffectSprite.filters = [this._encounterFilter];
    this.addChild(this._encoutnerEffectSprite);

    this._encounterEffectDuration = this.encounterEffectSpeed();
}

Scene_Map.prototype.encounterEffectSpeed = function() {
    return 90;
}

Scene_Map.prototype.updateEncounterEffect = function() {

    if (this._encounterEffectDuration > 0) {
        const Tmax = this.encounterEffectSpeed();
        const t = Tmax - this._encounterEffectDuration;
        this.updateEncounterFilter();
        if(StartBattlBGM_onTransition && t==0) BattleManager.playBattleBgm();
        if(t >= Tmax*0.3) this.startFadeOut(this.fadeSpeed());
        this._encounterEffectDuration--;
    }

}

Scene_Map.prototype.updateEncounterFilter = function() {
    this._encounterFilter.radius*= 1.1;
    this._encounterFilter.angle += (2+this._encounterFilter.angle*0.015);
    this._encoutnerEffectSprite.scale.x *= 1.01;
    this._encoutnerEffectSprite.scale.y *= 1.01;
}

})();