//=============================================================================
// SoR_CriticalAttackManager_MZ.js
// SoR License (C) 2020 蒼竜, REQUIRED User Registration on Dragon Cave
// http://dragonflare.blue/dcave/license.php
// ---------------------------------------------------------------------------
// Latest version v1.00 (2021/02/26)
//=============================================================================
/*:ja
@plugindesc ＜スキルクリティカル制御＞ v1.00
@author 蒼竜
@target MZ
@url http://dragonflare.blue/dcave/
@help 任意のスキルに対して、クリティカル発生率を個別に制御する機能を
実装します。これにより、「命中すれば必ずクリティカル」といった特殊な
スキルを作成できます。45. "無敵・重装甲エネミー" (SoR_PerfectGuardEnemy_MZ)
との共用にも適しています。

スキル用タグ基本例)
-絶対クリティカル
<AbsoluteCritical>

-確率指定クリティカル
<ForceCritical: [X]>

-クリティカル条件判定(真偽)
<CondCritical: [Cond.]>
<CondCritical2: [Cond.]>

-クリティカル条件判定(数値)
<CondValCritical: [Cond.]>

-回避率貫通クリティカル
<PenetrateCriEvade>
*/
/*:
@plugindesc <Critical Attack Manager> v1.00
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help This plugin enables us to make skills which has individual 
critical rate settings despite of battler traits and other settings.
We can create a skill that "must cause critical if the attack successes",
which is very friendly with the existing 45. "SoR_PerfectGuardEnemy_MZ".

Quick exmpales)
-Attack with the skill must be Critical.
<AbsoluteCritical>

-The skill must be critical in the designated percentage.
<ForceCritical: [X]>

-Conditional Critical (The condition returns true or false.)
<CondCritical: [Cond.]>
<CondCritical2: [Cond.]>

-Conditional Critical (The condition returns a value from 0.0 to 1.0.)
<CondValCritical: [Cond.]>

-Ignore Critical Evade rate
<PenetrateCriEvade>
*/

(function() {
const pluginName = "SoR_CriticalAttackManager_MZ";

const SoR_CAM_GA_itemCri = Game_Action.prototype.itemCri;
Game_Action.prototype.itemCri = function(target) {
    const default_result = SoR_CAM_GA_itemCri.call(this,...arguments);

    const fixed_result = this.EvaluateForceCriticalEffect(target);
    return fixed_result==null ? default_result : fixed_result;
}

Game_Action.prototype.EvaluateForceCriticalEffect = function(target) {
    const item = this.item();
    const a = this.subject();
    const b = target;
    const v = $gameVariables._data;
    
    if(item.meta.AbsoluteCritical) return 1;
    if(item.meta.ForceCritical && item.meta.ForceCritical!==true){
        const val = Number(item.meta.ForceCritical);
        if(!Number.isNaN(val)) return val/100.0;
    }
    if(item.meta.CondCritical && item.meta.CondCritical!==true){
        const str = String(item.meta.CondCritical).trim();
        if(SoR_Evaluate(str,a,b,v)) return 1;
        else return 0;
    }
    if(item.meta.CondCritical2 && item.meta.CondCritical2!==true){
        const str = String(item.meta.CondCritical2).trim();
        if(SoR_Evaluate(str,a,b,v)) return 1;
    }
    if(item.meta.CondValCritical && item.meta.CondValCritical!==true){
        const str = String(item.meta.CondValCritical).trim();
        return SoR_Evaluate(str,a,b,v);
    }
    if(item.meta.PenetrateCriEvade) return a.cri;

    return null;
}

function SoR_Evaluate(ev,a,b,v) {
    const sentence = "return (" + ev + ");";

    if(typeof $gameTemp.SoRTmp_script === "undefined") $gameTemp.SoRTmp_script = new Map();
    if(!$gameTemp.SoRTmp_script.has(sentence)){
        $gameTemp.SoRTmp_script.set(sentence, new Function("a","b","v",sentence));
    }
    const res = $gameTemp.SoRTmp_script.get(sentence)(a,b,v);
    return res;
}

})();