//=============================================================================
// SoR_BattleTargetHPHUD_MZ.js
// SoR License inherited from MIT License (C) 2020 蒼竜
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.10 (2021/04/09)
//=============================================================================
/*:ja
@plugindesc ＜戦闘用ターゲットHPゲージ＞ v1.10
@url http://dragonflare.blue/dcave/
@target MZ
@author 蒼竜
@help 戦闘シーンにおけるターゲット選択中、および行動によるHP変動の発生中に
各ターゲットに対してHPゲージを表示する機能を実装します。

ゲージは用意された画像(土台，残量，減少幅)を組み合わせて描画され、
お好みでゲージにHP数値を付加することもできます。
フロントビュー戦闘では敵専用となります。

@param ----全般----
@param HPGaugeBase_Enemy
@desc 敵用HPゲージ土台画像
@type file
@dir img/SoRBatHUD/
@default 
@param HPGaugeColor_Enemy
@desc 敵用HPゲージ内部画像
@type file
@dir img/SoRBatHUD/
@default 
@param HPNumber_Enemy
@desc 敵用HP数値画像
@type file
@dir img/SoRBatHUD/
@default 

@param HPGaugeBase_Actor
@desc 味方用HPゲージ土台画像
@type file
@dir img/SoRBatHUD/
@default 
@param HPGaugeColor_Actor
@desc 味方用HPゲージ内部画像
@type file
@dir img/SoRBatHUD/
@default 
@param HPNumber_Actor
@desc 味方用HP数値画像
@type file
@dir img/SoRBatHUD/
@default 

@param EnemyHPGuageBase_Ypadd
@desc HPゲージ土台位置y座標補正,敵用 (default: 0)
@default 0
@type number
@min -9999

@param ActorHPGuageBase_Ypadd
@desc HPゲージ土台位置y座標補正,味方用 (default: 0)
@default 0
@type number
@min -9999

@param Enemy_HPGuageBar_Xpadd
@desc HPゲージ内部バーx座標補正,敵用 (default: 21)
@default 21
@type number
@min -9999
@param Enemy_HPGuageBar_Ypadd
@desc HPゲージ内部バーy座標補正,敵用 (default: 4)
@default 4
@type number
@min -9999

@param Actor_HPGuageBar_Xpadd
@desc HPゲージ内部バーx座標補正,味方用 (default: 21)
@default 21
@type number
@min -9999
@param Actor_HPGuageBar_Ypadd
@desc HPゲージ内部バーy座標補正,味方用 (default: 4)
@default 4
@type number
@min -9999

@param ---HP数値描画設定---
@param Enable_HPDigits
@desc 表示されるHPゲージに数値を表示するか
@type select
@option する(敵・味方両方)
@value 3
@option 敵のみ
@value 2
@option 味方のみ
@value 1
@option しない
@value 0
@default 0

@param Alignment_HPDigits
@desc HP数値の描画位置基準
@type select
@option 敵:右寄せ 味方:右寄せ
@value 3
@option 敵:右寄せ 味方:左寄せ
@value 2
@option 敵:左寄せ 味方:右寄せ
@value 1
@option 敵:左寄せ 味方:左寄せ
@value 0
@default 3

@param HPDigitsEnemy_Xpadd
@desc HP数値x座標補正,敵用 (default: 175)
@default 175
@type number
@min -9999
@param HPDigitsEnemy_Ypadd
@desc HP数値y座標補正,敵用 (default: 12)
@default 12
@type number
@min -9999
@param HPDigitsActor_Xpadd
@desc HP数値x座標補正,味方用 (default: 175)
@default 175
@type number
@min -9999
@param HPDigitsActor_Ypadd
@desc HP数値y座標補正,味方用 (default: 12)
@default 12
@type number
@min -9999
@param --その他--
@param Max_HUDStorage
@desc HUD記憶空間サイズ，想定する最大敵バトラー出現数 (default: 8)
@default 8
@type number
*/
/*:
@plugindesc <Battle HP Gauge with Images> v1.10
@author Soryu
@target MZ
@url http://dragonflare.blue/dcave/index_e.php
@help During the battle scene, HP gauges for target battlers are presented
in the action target selection, and varing HP by actions.

This plugin uses (requires) several image sources to create gauges.
We have an option to add digits which represents the left HP.
In front-view battles, features provided by this plugin is valid for only enemies.

@param ----General----
@param HPGaugeBase_Enemy
@desc Base Image of HP Gauge for Enemies
@type file
@dir img/SoRBatHUD/
@default 
@param HPGaugeColor_Enemy
@desc Inner Images of HP Gauge for Enemies
@type file
@dir img/SoRBatHUD/
@default 
@param HPNumber_Enemy
@desc Digit Images of HP for Enemies
@type file
@dir img/SoRBatHUD/
@default 

@param HPGaugeBase_Actor
@desc Base Image of HP Gauge for Actors
@type file
@dir img/SoRBatHUD/
@default 
@param HPGaugeColor_Actor
@desc Inner Images of HP Gauge for Actors
@type file
@dir img/SoRBatHUD/
@default 
@param HPNumber_Actor
@desc Digit Images of HP for Actors
@type file
@dir img/SoRBatHUD/
@default 

@param EnemyHPGuageBase_Ypadd
@desc Padding of HP gauge for enemies (y-coordinate) (default: 0)
@default 0
@type number
@min -9999

@param ActorHPGuageBase_Ypadd
@desc Padding of HP gauge for actors (y-coordinate) (default: 0)
@default 0
@type number
@min -9999

@param Enemy_HPGuageBar_Xpadd
@desc Padding of HP bar in the gauge for enemies (x-coordinate) (default: 21)
@default 21
@type number
@min -9999
@param Enemy_HPGuageBar_Ypadd
@desc Padding of HP bar in the gauge for enemies (y-coordinate)  (default: 4)
@default 4
@type number
@min -9999

@param Actor_HPGuageBar_Xpadd
@desc Padding of HP bar in the gauge for actors (x-coordinate)  (default: 21)
@default 21
@type number
@min -9999
@param Actor_HPGuageBar_Ypadd
@desc Padding of HP bar in the gauge for actors (y-coordinate)  (default: 4)
@default 4
@type number
@min -9999

@param ---For HP Digits Display---
@param Enable_HPDigits
@desc A flag to display HP value with digit images
@type select
@option Enabled (Display for both enemies and actors.)
@value 3
@option Only for enemies
@value 2
@option Only for actors
@value 1
@option Disabled
@value 0
@default 0

@param Alignment_HPDigits
@desc The alignment of the position displaying HP values
@type select
@option Enemies: right, Actors: right
@value 3
@option Enemies: right, Actors: left
@value 2
@option Enemies: left, Actors: right
@value 1
@option Enemies: left, Actors: left
@value 0
@default 3

@param HPDigitsEnemy_Xpadd
@desc Padding of HP values for enemies (x-coordinate) (default: 175)
@default 175
@type number
@min -9999
@param HPDigitsEnemy_Ypadd
@desc Padding of HP values for enemies (y-coordinate) (default: 12)
@default 12
@type number
@min -9999
@param HPDigitsActor_Xpadd
@desc Padding of HP values for actors (x-coordinate) (default: 175)
@default 175
@type number
@min -9999
@param HPDigitsActor_Ypadd
@desc Padding of HP values for actors (y-coordinate) (default: 12)
@default 12
@type number
@min -9999

@param --Others--
@param Max_HUDStorage
@desc Size of storage for HP HUD associated with max number of enemy battlers in the battle scene. (default: 8)
@default 8
@type number
*/

(function() {
const pluginName = "SoR_Battle_TargetHPHUD_MZ";
const Param = PluginManager.parameters(pluginName);

const HPGaugeBase_Enemy = String(Param['HPGaugeBase_Enemy']) || '';
const HPGaugeColor_Enemy = String(Param['HPGaugeColor_Enemy']) || '';
const HPNumber_Enemy =  String(Param['HPNumber_Enemy']) || '';
const HPGaugeBase_Actor = String(Param['HPGaugeBase_Actor']) || '';
const HPGaugeColor_Actor = String(Param['HPGaugeColor_Actor']) || '';
const HPNumber_Actor =  String(Param['HPNumber_Actor']) || '';

const EnemyHPGuageBase_Ypadd = Number(Param['EnemyHPGuageBase_Ypadd']) || 0; 
const ActorHPGuageBase_Ypadd = Number(Param['ActorHPGuageBase_Ypadd']) || 0; 

const Enemy_HPGuageBar_Xpadd = Number(Param['Enemy_HPGuageBar_Xpadd']) || 0; 
const Enemy_HPGuageBar_Ypadd = Number(Param['Enemy_HPGuageBar_Ypadd']) || 0; 
const Actor_HPGuageBar_Xpadd = Number(Param['Actor_HPGuageBar_Xpadd']) || 0; 
const Actor_HPGuageBar_Ypadd = Number(Param['Actor_HPGuageBar_Ypadd']) || 0; 

const Enable_HPDigits = Number(Param['Enable_HPDigits']) || 0;
const Alignment_HPDigits = Number(Param['Alignment_HPDigits']) || 0;

const HPDigitsEnemy_Xpadd = Number(Param['HPDigitsEnemy_Xpadd']) || 0;
const HPDigitsEnemy_Ypadd = Number(Param['HPDigitsEnemy_Ypadd']) || 0;
const HPDigitsActor_Xpadd = Number(Param['HPDigitsActor_Xpadd']) || 0;
const HPDigitsActor_Ypadd = Number(Param['HPDigitsActor_Ypadd']) || 0;

//v1.01
const Max_HUDStorage = Number(Param['Max_HUDStorage']) || 0;
const IsIgnoreActor = HPGaugeBase_Actor == "" || HPGaugeColor_Actor == "";

ImageManager.loadBattleHudSprite = function(filename) {
    return this.loadBitmap('img/SoRBatHUD/', filename, 0, true);
}


const SoR_BTH_SB_createSpriteset = Scene_Battle.prototype.createSpriteset;
Scene_Battle.prototype.createSpriteset = function() { 
	SoR_BTH_SB_createSpriteset.call(this);
	if (!this._SoRImgField) this.createSubImgField();
    this.create_SoRHPGauge();
	this.sort_SubImgFieldLayer();
}

Scene_Battle.prototype.createSubImgField = function() {
	this._SoRImgField = new Sprite();
	this._SoRImgField.z = 10;
	this.addChild(this._SoRImgField);
}
Scene_Battle.prototype.sort_SubImgFieldLayer = function() {
    this._SoRImgField.children.sort(function(a, b){return a.mz-b.mz});
}
 
Scene_Battle.prototype.create_SoRHPGauge = function() {
    this._SoR_HPGauge = new SoR_BattleHPGauge();
    this._SoR_HPGauge.mz = 10;
	this._SoRImgField.addChild(this._SoR_HPGauge);
}


//activate, show a hp gauge
const SoR_BTH_SB_startEnemySelection = Scene_Battle.prototype.startEnemySelection;
Scene_Battle.prototype.startEnemySelection = function() {
	SoR_BTH_SB_startEnemySelection.call(this);
    this.prepare_targetHPgauge();
}



Scene_Battle.prototype.prepare_targetHPgauge = function() {
    this._SoR_HPGauge.clearGauge();

    if( !this._actorWindow || !this._enemyWindow) return;
    if( !this._actorWindow.active && !this._enemyWindow.active) return;

    //enemy
        const ntr = $gameTroop.members().length;
        for(let i=0; i<ntr; i++){
            const battler = $gameTroop.members()[i];
            if(battler.isSelected()){
                this._SoR_HPGauge.setGauge(battler);
            }
        }

    //ally
        const nact = $gameParty.battleMembers().length;
        for(let i=0; i<nact; i++){
            const battler = $gameParty.battleMembers()[i];
            if(battler.isSelected()){
                this._SoR_HPGauge.setGauge(battler);
            }
        }
}


const SoR_BTH_SB_startActorSelection = Scene_Battle.prototype.startActorSelection;
Scene_Battle.prototype.startActorSelection = function() {
	SoR_BTH_SB_startActorSelection.call(this);
    this.prepare_targetHPgauge();
}
const SoR_BTH_WBE_select = Window_BattleEnemy.prototype.select;
Window_BattleEnemy.prototype.select = function(index) {
    SoR_BTH_WBE_select.call(this, index);
    SceneManager._scene.prepare_targetHPgauge();
}
const SoR_BTH_WBA_select = Window_BattleActor.prototype.select;
Window_BattleActor.prototype.select = function(index) {
    SoR_BTH_WBA_select.call(this, index);
    SceneManager._scene.prepare_targetHPgauge();
}





/////////////////////////////////////////
//ターゲット選択中断
const SoR_BTH_SB_onActorCancel = Scene_Battle.prototype.onActorCancel;
Scene_Battle.prototype.onActorCancel = function() {
	SoR_BTH_SB_onActorCancel.call(this);
	this._SoR_HPGauge.clearGauge();
}
const SoR_BTH_SB_onEnemyCancel = Scene_Battle.prototype.onEnemyCancel;
Scene_Battle.prototype.onEnemyCancel = function() {
	SoR_BTH_SB_onEnemyCancel.call(this);
	this._SoR_HPGauge.clearGauge();
}
//選択完了
const SoR_BTH_SB_endCommandSelection = Scene_Battle.prototype.endCommandSelection
Scene_Battle.prototype.endCommandSelection = function() {
	SoR_BTH_SB_endCommandSelection.call(this);
    this._SoR_HPGauge.clearGauge();
}



Scene_Battle.prototype.prepare_HPgaugeForVariedTargets = function() {

    //enemy
        const ntr = $gameTroop.members().length;
        for(let i=0; i<ntr; i++){
            const battler = $gameTroop.members()[i];
            if(battler.isSelected()){
                this._SoR_HPGauge.setGauge(battler);
            }
        }

    //ally
        const nact = $gameParty.battleMembers().length;
        for(let i=0; i<nact; i++){
            const battler = $gameParty.battleMembers()[i];
            if(battler.isSelected()){
                this._SoR_HPGauge.setGauge(battler);
            }
        }
}



//////////////////////////////////////////////////////////////////
//on damages
const SoR_BTH_GA_executeHpDamage = Game_Action.prototype.executeHpDamage;
Game_Action.prototype.executeHpDamage = function(target, value) {
    if($gameParty.inBattle() && SceneManager._scene._SoR_HPGauge.IsBattlerNotFocused(target)){
        SceneManager._scene._SoR_HPGauge.setGauge(target,100); //Scene_Battle
    }
    SoR_BTH_GA_executeHpDamage.call(this, ...arguments);
}





//////////////////////////////////////////////////////////////////////
function SoR_BattleHPGauge() {
    this.initialize.apply(this, arguments);
}
SoR_BattleHPGauge.prototype = Object.create(Sprite.prototype);
SoR_BattleHPGauge.prototype.constructor = SoR_BattleHPGauge;

SoR_BattleHPGauge.prototype.initialize = function(){
     Sprite.prototype.initialize.call(this);
     this.n_usingActor = 0;
     this.n_usingEnemy = 0;
     this.ActorGuage = [];
     this.EnemyGuage = [];
     this.CreateGuages();
}

SoR_BattleHPGauge.prototype.CreateGuages = function(){

    if(!IsIgnoreActor && $gameSystem.isSideView()){
    for(let i=0; i<Max_HUDStorage;i++){
        this.ActorGuage[i] = new Sprite(ImageManager.loadBattleHudSprite(HPGaugeBase_Actor));
        this.ActorGuage[i].anchor.x = 0;
        this.ActorGuage[i].anchor.y = 0.5;
        this.ActorGuage[i].visible = false;
        this.addChild(this.ActorGuage[i]);
        
        const bmp = ImageManager.loadBattleHudSprite(HPGaugeColor_Actor);
        bmp.addLoadListener(function() {
            this.ActorGuage[i].colorspr = new Sprite(bmp);
            const w = this.ActorGuage[i].colorspr.bitmap.width;
            const h = this.ActorGuage[i].colorspr.bitmap.height *0.5;
            this.ActorGuage[i].colorspr.setFrame(0, 0, w, h);
            this.ActorGuage[i].colorspr.x = Actor_HPGuageBar_Xpadd;
            this.ActorGuage[i].colorspr.anchor.x = 0;
            this.ActorGuage[i].colorspr.anchor.y = 0.5;
            //this.ActorGuage[i].colorspr.visible = false;
            
            this.ActorGuage[i].colordecspr = new Sprite(bmp);
            this.ActorGuage[i].colordecspr.setFrame(0, h+1, w, h);
            this.ActorGuage[i].colordecspr.x = Actor_HPGuageBar_Xpadd;
            this.ActorGuage[i].colordecspr.anchor.x = 0;
            this.ActorGuage[i].colordecspr.anchor.y = 0.5;
            this.ActorGuage[i].battler = null;
            //this.ActorGuage[i].colordecspr.visible = false;
            this.ActorGuage[i].addChild(this.ActorGuage[i].colordecspr);
            this.ActorGuage[i].addChild(this.ActorGuage[i].colorspr);

            this.ActorGuage[i].HPvalue = new GuageHPDigits();
            this.ActorGuage[i].addChild(this.ActorGuage[i].HPvalue);
        }.bind(this));
    }
    }

    for(let i=0; i<Max_HUDStorage;i++){
        this.EnemyGuage[i] = new Sprite(ImageManager.loadBattleHudSprite(HPGaugeBase_Enemy));
        this.EnemyGuage[i].anchor.x = 0;
        this.EnemyGuage[i].anchor.y = 0.5;
        this.EnemyGuage[i].visible = false;
        this.addChild(this.EnemyGuage[i]);

        const bmp = ImageManager.loadBattleHudSprite(HPGaugeColor_Enemy);
        bmp.addLoadListener(function() {
            this.EnemyGuage[i].colorspr = new Sprite(bmp);
            const w = this.EnemyGuage[i].colorspr.bitmap.width;
            const h = this.EnemyGuage[i].colorspr.bitmap.height *0.5;
            this.EnemyGuage[i].colorspr.setFrame(0, 0, w, h);
            this.EnemyGuage[i].colorspr.x = Enemy_HPGuageBar_Xpadd;
            this.EnemyGuage[i].colorspr.anchor.x = 0;
            this.EnemyGuage[i].colorspr.anchor.y = 0.5;
            this.EnemyGuage[i].battler = null;
            //this.EnemyGuage[i].colorspr.visible = false;
            
            this.EnemyGuage[i].colordecspr = new Sprite(bmp);
            this.EnemyGuage[i].colordecspr.setFrame(0, h+1, w, h);
            this.EnemyGuage[i].colordecspr.x = Enemy_HPGuageBar_Xpadd;
            this.EnemyGuage[i].colordecspr.anchor.x = 0;
            this.EnemyGuage[i].colordecspr.anchor.y = 0.5;
            //this.EnemyGuage[i].colordecspr.visible = false;
            this.EnemyGuage[i].addChild(this.EnemyGuage[i].colordecspr);
            this.EnemyGuage[i].addChild(this.EnemyGuage[i].colorspr);

            this.EnemyGuage[i].HPvalue = new GuageHPDigits(0);
            this.EnemyGuage[i].addChild(this.EnemyGuage[i].HPvalue);
        }.bind(this));

    }
}

SoR_BattleHPGauge.prototype.IsBattlerNotFocused = function(battler) {
    if(battler.isActor()) return this.ActorGuage.every((b) => b.battler == null || (b.battler != null && battler._actorId != b.battler._actorId));
    else return this.EnemyGuage.every((b) => b.battler == null || (b.battler != null && isUniqueTarget(b, battler)));
} 

function isUniqueTarget(b, battler){
    if(battler._enemyId != b.battler._enemyId) return true;
    if(battler._letter != b.battler._letter) return true;
    return false;
}



SoR_BattleHPGauge.prototype.setGauge = function(battler, d) {
    const isact = battler.isActor();
    if(isact && (!$gameSystem.isSideView() || IsIgnoreActor)) return;

    let btl;
    if(isact) btl = this.ActorGuage[this.n_usingActor];
    else btl = this.EnemyGuage[this.n_usingEnemy];
    const spr = battler._sprite();
	
    btl.x = (battler.x ? battler.x : spr.x) - btl.colorspr.width*0.5;
    btl.ybase = (battler.y ? battler.y : spr.y) + (isact? ActorHPGuageBase_Ypadd : EnemyHPGuageBase_Ypadd);
    btl.y = btl.ybase;

    btl.colorspr.y = isact==true ? Actor_HPGuageBar_Ypadd : Enemy_HPGuageBar_Ypadd;
    btl.colordecspr.y = btl.colorspr.y;
    btl.battler = battler;
    btl.duration = !d ? -1 : d;

    const rate = btl.battler.hp/btl.battler.mhp;
    const w = btl.colorspr.bitmap.width *rate;
    const h = btl.colorspr.bitmap.height *0.5;
    btl.initialHP = btl.battler.hp;
    btl.currentDrawHP = btl.initialHP;
    btl.colorspr.setFrame(0, 0, w, h);
    btl.colordecspr.setFrame(0, h, w, h);

    btl.visible = true;
    btl.colorspr.visible = true;
    btl.colordecspr.visible = true;

    if((isact && Enable_HPDigits%2==1) || (!isact && Enable_HPDigits>=2)){ //draw hp digits
        btl.HPvalue.setInitialHP(btl.initialHP,btl.battler);
        btl.HPvalue.setDigits(btl.battler);
    }

    if(isact) this.n_usingActor++;
    else this.n_usingEnemy++;
}



SoR_BattleHPGauge.prototype.update = function() {
    for(let i=0; i<Max_HUDStorage;i++){
        const btl = this.EnemyGuage[i];
        if(btl.battler == null) break;
        if(btl.duration==-1) continue;

        
        const diff = btl.battler.hp - btl.currentDrawHP;
        if(diff!=0) btl.currentDrawHP += Math.floor(diff*0.1);
        const rate = btl.currentDrawHP/btl.battler.mhp;
        const w = btl.colorspr.bitmap.width *rate;
        const h = btl.colorspr.bitmap.height *0.5;
        const rate2 = btl.initialHP/btl.battler.mhp;
        const w2 = btl.colorspr.bitmap.width *rate2;

        btl.colorspr.setFrame(0, 0, w, h);
        btl.colordecspr.setFrame(0, h, w2, h);
        if(Enable_HPDigits>=2){ //draw hp digits
            btl.HPvalue.refreshDigits(btl.battler,i);
        }
        if(btl.battler.isDead()) btl.duration = 0;
        if(btl.duration==0 && diff==0) this.clear1gauge(btl.battler, i);
        if(BattleManager.isTpbMainPhase() && btl.duration>0) btl.duration--;
    }

    if(!IsIgnoreActor  && $gameSystem.isSideView()){
    for(let i=0; i<Max_HUDStorage;i++){
        const btl = this.ActorGuage[i];
        if(btl.battler == null) break;
        if(btl.duration==-1) continue;

        const diff = btl.battler.hp - btl.currentDrawHP;
        if(diff!=0) btl.currentDrawHP += Math.floor(diff*0.1);
        const rate = btl.currentDrawHP/btl.battler.mhp;
        const w = btl.colorspr.bitmap.width *rate;
        const h = btl.colorspr.bitmap.height *0.5;
        const rate2 = btl.initialHP/btl.battler.mhp;
        const w2 = btl.colorspr.bitmap.width *rate2;

        btl.colorspr.setFrame(0, 0, w, h);
        btl.colordecspr.setFrame(0, h+1, w2, h);
        if(Enable_HPDigits%2==1){ //draw hp digits
            btl.HPvalue.refreshDigits(btl.battler,i);
        }
        if(btl.battler.isDead()) btl.duration = 0;
        if(btl.duration==0) this.clear1gauge(btl.battler, i);
        if(BattleManager.isTpbMainPhase()) btl.duration--;
    }
    }
}

 

SoR_BattleHPGauge.prototype.clearGauge = function() {
    if(!IsIgnoreActor && $gameSystem.isSideView()){
    for(let i=0; i<Max_HUDStorage;i++){
        //this.ActorGuage[i].nameWinclearGaugedow.clearName();
        const ag = this.ActorGuage[i];
        ag.visible = false;
        if(!ag.colorspr) continue;
        ag.colorspr.visible = false;
        ag.colordecspr.visible = false;
        if(Enable_HPDigits%2==1){ //draw hp digits
            ag.HPvalue.clearDigits();
        }
        ag.battler = null;
        //this.ActorGuage[i].ymove = -32;
    }
    this.n_usingActor = 0;
    }
    
    for(let i=0; i<Max_HUDStorage;i++){
        //this.EnemyGuage[i].nameWindow.clearName();
        const eg = this.EnemyGuage[i];
        eg.visible = false;
        if(!eg.colorspr) continue;
        eg.colorspr.visible = false;
        eg.colordecspr.visible = false;
        if(Enable_HPDigits>=2){ //draw hp digits
            eg.HPvalue.clearDigits();
        }
        eg.battler = null;
        //this.EnemyGuage[i].ymove = -32;
    }
    this.n_usingEnemy = 0;
}

SoR_BattleHPGauge.prototype.clear1gauge = function(bat,i) {

    if(bat.isActor()){
        const ag = this.ActorGuage[i];
        ag.visible = false;
        if(!ag.colorspr) return;
        ag.colorspr.visible = false;
        ag.colordecspr.visible = false;
        if(Enable_HPDigits%2==1){ //draw hp digits
            ag.HPvalue.clearDigits();
        }
        ag.battler = null;
        const emp = this.ActorGuage.splice(i, 1);
        this.ActorGuage.push(emp.shift());
        this.n_usingActor--;
    }
    else{
        const eg = this.EnemyGuage[i];
        eg.visible = false;
        if(!eg.colorspr) return;
        eg.colorspr.visible = false;
        eg.colordecspr.visible = false;
        if(Enable_HPDigits>=2){ //draw hp digits
            eg.HPvalue.clearDigits();
        }
        eg.battler = null;
        const emp = this.EnemyGuage.splice(i, 1);
        this.EnemyGuage.push(emp.shift());
        this.n_usingEnemy--;
    }
}

　

///////////////////////////////////////////////////////////////////////////
function GuageHPDigits() {
    this.initialize.apply(this, arguments);
}
GuageHPDigits.prototype = Object.create(Sprite.prototype);
GuageHPDigits.prototype.constructor = GuageHPDigits;
GuageHPDigits.prototype.initialize = function(idx) {
    Sprite.prototype.initialize.call(this);
    this._currentHP = -1;

    this._image = idx==0 ? ImageManager.loadBattleHudSprite(HPNumber_Enemy) : ImageManager.loadBattleHudSprite(HPNumber_Actor);
    this._digits = [];
}

GuageHPDigits.prototype.setDigits = function(battler) {
    const diff =  battler.hp - this._currentHP; 
    this._currentHP = Math.floor(this._currentHP+diff*0.25);   
    const isact = battler.isActor();
    const align_R = (!isact && Alignment_HPDigits >=2) || (isact && Alignment_HPDigits %2==1);

    this._image.addLoadListener(function() {
		const Numimg = this._image;
		const wd = Numimg.width / 11;//10 + ? x1
		const ht = Numimg.height;
        let numarr = Math.abs(this._currentHP).toString().split("");
        
        if(!isact && battler.enemy().meta.MaskHPDigits) numarr = ["?","?","?"];

            const nrl = numarr.length;
            for (let i = 0; i < nrl; i++){
                const ndigit = numarr[0]=="?" ? 10 : Number(numarr[i]);
                    this._digits[i] = new Sprite(Numimg);
                    this._digits[i].setFrame(ndigit * wd, 0, wd, ht);
                    this._digits[i].x = this.x + this.xpadd + ( align_R ? (i*(wd-2))-nrl*(wd-2) :  i*(wd-2) );
                    this._digits[i].y = this.y + this.ypadd;
                    this._digits[i].anchor.x = 0.5;
                    this._digits[i].anchor.y = 0.5;
                    this._digits[i].scale.x = 1.0;
                    this._digits[i].scale.y = 1.0;
                    this._digits[i].opacity = 255;
                    this._digits[i].wd = wd; //width one digit
                    this.addChild(this._digits[i]);
            }//digits composition
    }.bind(this));
}


GuageHPDigits.prototype.setInitialHP = function(ini,battler) {
    this._currentHP = ini;
    this.xpadd = battler.isActor() ? HPDigitsActor_Xpadd : HPDigitsEnemy_Xpadd;
    this.ypadd = battler.isActor() ? HPDigitsActor_Ypadd : HPDigitsEnemy_Ypadd;
}

GuageHPDigits.prototype.initializeDigits = function() {
	const nd = this._digits.length;
    for (let i = 0; i < nd; i++) this.removeChild(this._digits[i]);
    this._digits = [];
}

GuageHPDigits.prototype.clearDigits = function() {
	const nd = this._digits.length;
    for (let i = 0; i < nd; i++) this.removeChild(this._digits[i]);
    this._digits = [];
    this._currentHP = -1;
}

GuageHPDigits.prototype.refreshDigits = function(battler,i) {
    if(this._currentHP != -1 && battler.hp == this._currentHP) return;
    this.initializeDigits(battler, i);
    this.setDigits(battler);
}

//map: battler object -> battler sprite
Game_Battler.prototype._sprite = function() {
    return BattleManager._spriteset.findTargetSprite(this);
}

}());