//=============================================================================
// SoR_BattleTargetCursor_MZ.js
// SoR License inherited from MIT License (C) 2020 蒼竜
// http://dragonflare.blue/dcave/license.php
// ----------------------------------------------------------------------------
// Latest version v1.00 (2020/10/28)
//=============================================================================
/*:ja
@plugindesc ＜ターゲット選択カーソル＞ v1.00
@author 蒼竜
@target MZ
@help 戦闘中の行動対象選択時に，対象候補の頭上に
カーソル画像(および名前ウィンドウ)を表示する機能を付加します。

今後の予定(別プラグインとの兼ね合い)として、敵増援・複数対象にも対応します。

※サイドビュー戦闘での使用を想定しています。
フロントビュー戦闘では、敵選択時のみカーソルが作動します。

@url http://dragonflare.blue/dcave/
@param ----全般----
@param TargetName_Window
@desc ターゲット頭上の名前表示
@type select
@option 標準スキンによるウィンドウ
@value 0
@option 無背景・名前のみ
@value 2
@option 名前を表示しない
@value 3
@default 0

@param Cursor_EnemyTarget
@desc 敵対象カーソル画像
@type file
@dir img/SoRBatHUD/
@default 
@param Cursor_ActorTarget
@desc 味方対象カーソル画像
@type file
@dir img/SoRBatHUD/
@default 

@param Cursor_Ypadd
@desc カーソル位置y座標補正 (default: -16)
@default -16
@type number
@min -9999
@param NameWindow_Ypadd
@desc 名前表示有効時のウィンドウ位置y座標補正 (default: -64)
@default -64
@type number
@min -9999

@param ----特殊系----
@param Dismiss_EnemySelection
@desc エネミー選択ウィンドウを画面上、見えなくします。
@default false
@type boolean
@param Loop_SelectionCursors
@desc 左右キー入力により、選択カーソルがループするようになります。
@default false
@type boolean
@param Modify_UpDownCursors
@desc Loop_SelectionCursorsに加え、上下キーでカーソルが先頭・末尾エネミーへ移動。デフォルト選択ウィンドウ不使用を想定。
@default false
@type boolean
*/
/*:
@plugindesc <Target Battler Selection Cursors> v1.00
@author Soryu
@target MZ
@help When players are to select targets of a speicifed action during battle scenes,
cursors generated by prepares images (and name window) are displayed on targets.

This plugin will be applied to the situation that multiple enemies selection and
backup enemies during a battle (with future coming plugins).

Note that this plugin mainly assumes to be used for side-view battles.
For front-view battles, the cursor is only activated for enemy selection.

@url http://dragonflare.blue/dcave/
@param ----General Settings----
@param TargetName_Window
@desc Style of showing target name
@type select
@option Default window
@value 0
@option No window (just the target name)
@value 2
@option Disabled
@value 3
@default 0

@param Cursor_EnemyTarget
@desc Cursor image to point enemies
@type file
@dir img/SoRBatHUD/
@default 
@param Cursor_ActorTarget
@desc Cursor image to point allies
@type file
@dir img/SoRBatHUD/
@default 

@param Cursor_Ypadd
@desc Padding for y-coordinate of cursor position (default: -16)
@default -16
@type number
@min -9999
@param NameWindow_Ypadd
@desc Padding for y-coordinate of name window position, if it is enabled (default: -64)
@default -64
@type number
@min -9999

@param ----!!SPECIAL!!----
@param Dismiss_EnemySelection
@desc Conceal the enemy selection window in the game screen.
@default false
@type boolean
@param Loop_SelectionCursors
@desc With left/right keys, the cursor is looped at both ends of targets.
@default false
@type boolean
@param Modify_UpDownCursors
@desc In addition to Loop_SelectionCursors, with up/down keyes, the cursor is moved to first/last targets (Assume no selection windows). 
@default false
@type boolean
*/


(function() {

const pluginName = "SoR_Battle_TargetCursor_MZ";
const Param = PluginManager.parameters(pluginName);
const TargetName_Window = Number(Param['TargetName_Window']) || 0;
const Cursor_EnemyTarget = String(Param['Cursor_EnemyTarget']) || '';
const Cursor_ActorTarget = String(Param['Cursor_ActorTarget']) || '';
const Cursor_Ypadd = Number(Param['Cursor_Ypadd']) || 0;
const NameWindow_Ypadd = Number(Param['NameWindow_Ypadd']) || 0;

const Dismiss_EnemySelection = Boolean(Param['Dismiss_EnemySelection'] === 'true') || false;
const Loop_SelectionCursors = Boolean(Param['Loop_SelectionCursors'] === 'true') || false;
const Modify_UpDownCursors = Boolean(Param['Modify_UpDownCursors'] === 'true') || false; 


ImageManager.loadBattleHudSprite = function(filename) {
    return this.loadBitmap('img/SoRBatHUD/', filename, 0, true);
}


const SoR_BTC_SB_createSpriteset = Scene_Battle.prototype.createSpriteset;
Scene_Battle.prototype.createSpriteset = function() { 
	SoR_BTC_SB_createSpriteset.call(this);
	if (!this._SoRImgField) this.createSubImgField();
    this.create_SoRBcursor();
	this.sort_SubImgFieldLayer();
}

Scene_Battle.prototype.createSubImgField = function() {
	this._SoRImgField = new Sprite();
	this._SoRImgField.z = 10;
	this.addChild(this._SoRImgField);
}
Scene_Battle.prototype.sort_SubImgFieldLayer = function() {
    this._SoRImgField.children.sort(function(a, b){return a.mz-b.mz});
}
 
Scene_Battle.prototype.create_SoRBcursor = function() {
    this._SoR_battleCursor = new SoR_BattleCursor();
    this._SoR_battleCursor.mz = 50;
	this._SoRImgField.addChild(this._SoR_battleCursor); 
}


//activate, show a cursor
const SoR_BTC_SB_startEnemySelection = Scene_Battle.prototype.startEnemySelection;
Scene_Battle.prototype.startEnemySelection = function() {
	SoR_BTC_SB_startEnemySelection.call(this);
    this.prepare_battleCusor();
}

Scene_Battle.prototype.prepare_battleCusor = function() {
    this._SoR_battleCursor.clearcursor();

    if( !this._actorWindow || !this._enemyWindow) return;
    if( !this._actorWindow.active && !this._enemyWindow.active) return;
 
    //enemy
        const ntr = $gameTroop.members().length;
        for(let i=0; i<ntr; i++){
            const battler = $gameTroop.members()[i];
            if(battler.isSelected()){
                this._SoR_battleCursor.setcursor(battler);
            }
        }

    //ally
        const nact = $gameParty.battleMembers().length;
        for(let i=0; i<nact; i++){
            const battler = $gameParty.battleMembers()[i];
            if(battler.isSelected()){
                this._SoR_battleCursor.setcursor(battler);
            }
        }
}


const SoR_BTC_SB_startActorSelection = Scene_Battle.prototype.startActorSelection;
Scene_Battle.prototype.startActorSelection = function() {
	SoR_BTC_SB_startActorSelection.call(this);
    this.prepare_battleCusor();
}

const SoR_BTC_WBE_select = Window_BattleEnemy.prototype.select;
Window_BattleEnemy.prototype.select = function(index) {
    SoR_BTC_WBE_select.call(this, index);
    SceneManager._scene.prepare_battleCusor();
};
const SoR_BTC_WBA_select = Window_BattleActor.prototype.select;
Window_BattleActor.prototype.select = function(index) {
    SoR_BTC_WBA_select.call(this, index);
    SceneManager._scene.prepare_battleCusor();
};





/////////////////////////////////////////
//ターゲット選択中断
const SoR_BTC_SB_onActorCancel = Scene_Battle.prototype.onActorCancel;
Scene_Battle.prototype.onActorCancel = function() {
	SoR_BTC_SB_onActorCancel.call(this);
	this._SoR_battleCursor.clearcursor();
}
const SoR_BTC_SB_onEnemyCancel = Scene_Battle.prototype.onEnemyCancel;
Scene_Battle.prototype.onEnemyCancel = function() {
	SoR_BTC_SB_onEnemyCancel.call(this);
	this._SoR_battleCursor.clearcursor();
}

//選択完了
const SoR_BTC_SB_endCommandSelection = Scene_Battle.prototype.endCommandSelection
Scene_Battle.prototype.endCommandSelection = function() {
	SoR_BTC_SB_endCommandSelection.call(this);
    this._SoR_battleCursor.clearcursor();
};








function SoR_BattleCursor() {
    this.initialize.apply(this, arguments);
}
SoR_BattleCursor.prototype = Object.create(Sprite.prototype);
SoR_BattleCursor.prototype.constructor = SoR_BattleCursor;

SoR_BattleCursor.prototype.initialize = function(){
     Sprite.prototype.initialize.call(this);
     this.n_usingActor = 0;
     this.n_usingEnemy = 0;
     this.ActorCursor = [];
     this.EnemyCursor = [];
     this.CreateCursor();
}

SoR_BattleCursor.prototype.CreateCursor = function(){
    for(let i=0; i<8;i++){
        this.ActorCursor[i] = new Sprite(ImageManager.loadBattleHudSprite(Cursor_ActorTarget));
        this.ActorCursor[i].anchor.x = 0.5;
        this.ActorCursor[i].anchor.y = 0.5;
        this.ActorCursor[i].visible = false;
        this.ActorCursor[i].ymove = -32;
        this.addChild(this.ActorCursor[i]);
        
        this.ActorCursor[i].nameWindow = new Window_BattleCursorName();
        this.addChild(this.ActorCursor[i].nameWindow);
    }
    
    for(let i=0; i<8;i++){
        this.EnemyCursor[i] = new Sprite(ImageManager.loadBattleHudSprite(Cursor_EnemyTarget));
        this.EnemyCursor[i].anchor.x = 0.5;
        this.EnemyCursor[i].anchor.y = 0.5;
        this.EnemyCursor[i].visible = false;
        this.EnemyCursor[i].ymove = -32;
        this.addChild(this.EnemyCursor[i]);
        
        this.EnemyCursor[i].nameWindow = new Window_BattleCursorName();
        this.addChild(this.EnemyCursor[i].nameWindow);
    }
}


SoR_BattleCursor.prototype.setcursor = function(battler) {
	if(battler.isActor() && !$gameSystem.isSideView()) return;
	
    let btl;
    if(battler.isActor()) btl = this.ActorCursor[this.n_usingActor];
    else btl = this.EnemyCursor[this.n_usingEnemy];
	const spr = battler._sprite();

    btl.x = battler.x ? battler.x : spr.x;
    btl.ybase = (battler.y ? battler.y : spr.y) - (battler.height ? battler.height : spr.height)  + Cursor_Ypadd;
    btl.y = btl.ybase + btl.ymove;
 
    if(TargetName_Window<3){
        btl.nameWindow.setName(battler.name());
        btl.nameWindow.x = (battler.x ? battler.x : spr.x) - btl.nameWindow.width*0.5;
        btl.nameWindow.y = btl.ybase + NameWindow_Ypadd;
    }
    btl.visible = true;
	
    if(battler.isActor()) this.n_usingActor++;
    else this.n_usingEnemy++;
}

SoR_BattleCursor.prototype.clearcursor = function() {
    for(let i=0; i<8;i++){
        this.ActorCursor[i].nameWindow.clearName();
        this.ActorCursor[i].visible = false;
        this.ActorCursor[i].ymove = -32;
    }
    for(let i=0; i<8;i++){
        this.EnemyCursor[i].nameWindow.clearName();
        this.EnemyCursor[i].visible = false;
        this.EnemyCursor[i].ymove = -32;
    }
    this.n_usingActor = 0;
    this.n_usingEnemy = 0;
};

SoR_BattleCursor.prototype.update = function() {
    for(let i=0; i<this.n_usingActor;i++){
        const btl = this.ActorCursor[i];
        btl.y = btl.ybase + btl.ymove;
        btl.ymove++;
        if(btl.ymove>0) btl.ymove = -32;
    }
    for(let i=0; i<this.n_usingEnemy;i++){
        const btl = this.EnemyCursor[i];
        btl.y = btl.ybase + btl.ymove;
        btl.ymove++;
        if(btl.ymove>0) btl.ymove = -32;
    }
};


///////////////////////////////////////////////////////////////////////////

function Window_BattleCursorName() {
    this.initialize.apply(this, arguments);
}
Window_BattleCursorName.prototype = Object.create(Window_Base.prototype);
Window_BattleCursorName.prototype.constructor = Window_BattleCursorName;


Window_BattleCursorName.prototype.initialize = function() {
	this._text = '';	
    Window_Base.prototype.initialize.call(this, new Rectangle(0,0, Graphics.width, Graphics.height));
    this.visible=false;
    this.padding = 2;
	this.setBackgroundType(TargetName_Window);
};

Window_BattleCursorName.prototype.setName = function(name) {
    this.writeContents(name);
	this.visible = true;
    this.open();
};

Window_BattleCursorName.prototype.clearName = function() {
    this.contents.clear();
	this.visible = false;
    this.close();
};


Window_BattleCursorName.prototype.writeContents = function(name) {
    this.contents.clear(); 

    this._text = name; //action._actions[0]._item.object().name;   
	this.contents.fontSize = 18;    
    const textState = this.createTextState(this._text, this.padding+24, 7, this.textWidth(this._text));
    this.processAllText(textState);

    this.width = textState.outputWidth + this.padding*2 +48 +4;
    this.height = 44;
};



//map: battler object -> battler sprite
Game_Battler.prototype._sprite = function() {
    return BattleManager._spriteset.findTargetSprite(this);
}









///////////////////////////////////////////////////////////////////
// options
///////////////////////////////////////////////////////////////////
if(Dismiss_EnemySelection){
    const SoR_BTC_BS_show = Window_BattleEnemy.prototype.show;
    Window_BattleEnemy.prototype.show = function() {
        this.x = -10000;
        SoR_BTC_BS_show.call(this);
    }
}
if(Loop_SelectionCursors){
    Window_BattleEnemy.prototype.cursorRight = function(wrap) {
        const index = this.index();
        const maxItems = this.maxItems();
        const maxCols = this.maxCols();
        const horizontal = this.isHorizontal();
        this.smoothSelect((index + 1) % maxItems);
    }

    Window_BattleEnemy.prototype.cursorLeft = function(wrap) {
        const index = Math.max(0, this.index());
        const maxItems = this.maxItems();
        const maxCols = this.maxCols();
        const horizontal = this.isHorizontal();
        this.smoothSelect((index - 1 + maxItems) % maxItems);
    }

    if(Modify_UpDownCursors){
        Window_BattleEnemy.prototype.cursorDown = function(wrap) { this.smoothSelect(0); }
        Window_BattleEnemy.prototype.cursorUp = function(wrap) { this.smoothSelect(this.maxItems()-1); }
    }    
}

}());