//=============================================================================
// SVActorPosition.js (Ver1.1.0)
//=============================================================================
// [Update History]
// 2015.Nov.XX Ver.1.0.0 First Release as KADOKAWA RMMV Plugin
// 2019.Dec.29 Ver.1.1.0 Enable formulae, >4 actors

/*:
 * @plugindesc Change actors' position on screen at sideview battle.
 * @author Sasuke KANNAZUKI
 * 
 * @param actor1 Xpos
 * @desc X position formula of actor1's center. 
 * (default:600)
 * @type text
 * @default 600
 *
 * @param actor1 Ypos
 * @desc Y position formula of actor1's bottom. 
 * (default:280)
 * @type text
 * @default 280
 * 
 * @param actor2 Xpos
 * @desc X position formula of actor2's center. 
 * (default:600 + 32) =632
 * @type text
 * @default 600 + 32
 *
 * @param actor2 Ypos
 * @desc Y position formula of actor2's bottom. 
 * (default:280 + 48) =328
 * @type text
 * @default 280 + 48
 * 
 * @param actor3 Xpos
 * @desc X position formula of actor3's center. 
 * (default:600 + 32 * 2) =664
 * @type text
 * @default 600 + 32 * 2
 *
 * @param actor3 Ypos
 * @desc Y position formula of actor3's bottom. 
 * (default:280 + 48 * 2) =376
 * @type text
 * @default 280 + 48 * 2
 * 
 * @param actor4 Xpos
 * @desc X position formula of actor4's center. 
 * (default:600 + 32 * 3) =696
 * @type text
 * @default 600 + 32 * 3
 *
 * @param actor4 Ypos
 * @desc Y position formula of actor4's bottom. 
 * (default:280 + 48 * 3) =424
 * @type text
 * @default 280 + 48 * 3
 * 
 * @help 
 * This plugin runs under RPG Maker MV.
 *
 * This plugin enables to change the positions of sideview actors.
 *
 * [Summary]
 * By option, you can set the position not only number but also formula.
 * (ex. 200 + $gameVarables.value(1) )
 * If your system's battle attend actor's number > 4,
 * then, set by plugin command.
 *
 * This plugin also assumes the use of diffrent (from specified) size
 * SV actor graphics.
 * 
 * [Plugin Command]
 * SVActorPosition arg0 arg1 arg2
 * arg0 must be the number > 0 and < 100.
 * arg1 must be 'X' or 'Y'.
 * arg2 must be the value or formula of coordinate position.
 *  If you use formula, never use white space in the formula.
 * 
 * ex.
 * SVActorPosition 1 X 640    # set sideview actor 1's X position 640.
 * SVActorPosition 4 Y 472    # set sideview actor 4's Y position 472.
 * You can also be able to following notation:
 * SVActorPosition 2 X $gameVariables.value(20)
 * SVActorPosition 3 Y 320+48*2   # you shouldn't use white space in formula.
 * SVActorPosition 5 X 640    # if your system attends >4 actors at battle.
 * 
 *
 * [configuration at Actor's note]
 * <SVWeaponHeight:12>
 * Weapon animation's height of the sideview actor.
 * In this case, Y position is heigher 12px by the defalut.
 * - It also accepts minus value,
 *   because it assumes when you make smaller actor.
 * - If this isn't written, default value 0 is used.
 * 
 * Weapon animation's X position is automatically corrected
 *   according to the actor graphics size.
 * If you feel it isn't natural, you can optimize the X position.
 * <SVWeaponRight:20>
 * In this case weapon animation moves right 20 pixels.
 * If the value is minus, animation moves left.
 *
 *
 * [License]
 * this plugin is released under MIT license.
 * http://opensource.org/licenses/mit-license.php
 *
 */
/*:ja
 * @plugindesc サイドビュー戦闘においてアクター達の画面表示位置を設定します。
 * @author 神無月サスケ
 * 
 * @param actor1 Xpos
 * @desc アクター1の中心のX座標の式です。
 * (初期値:600)
 * @type text
 * @default 600
 *
 * @param actor1 Ypos
 * @desc アクター1の足元のY座標の式です。
 * (初期値:280)
 * @type text
 * @default 280
 * 
 * @param actor2 Xpos
 * @desc アクター2の中心のX座標の式です。
 * (初期値:600 + 32) =632
 * @type text
 * @default 600 + 32
 *
 * @param actor2 Ypos
 * @desc アクター2の足元のY座標の式です。
 * (初期値:280 + 48) =328
 * @type text
 * @default 280 + 48
 * 
 * @param actor3 Xpos
 * @desc アクター3の中心のX座標の式です。
 * (初期値:600 + 32 * 2) =664
 * @type text
 * @default 600 + 32 * 2
 *
 * @param actor3 Ypos
 * @desc アクター3の足元のY座標の式です。
 * (初期値:280 + 48 * 2) =376
 * @type text
 * @default 280 + 48 * 2
 * 
 * @param actor4 Xpos
 * @desc アクター4の中心のX座標の式です。
 * (初期値:600 + 32 * 3) =696
 * @type text
 * @default 600 + 32 * 3
 *
 * @param actor4 Ypos
 * @desc アクター4の足元のY座標の式です。
 * (初期値:280 + 48 * 3) =424
 * @type text
 * @default 280 + 48 * 3
 * 
 * @help 
 * このプラグインは、サイドビュー戦闘でのアクターの座標を変更可能です。
 *
 * ■概要
 * 位置をオプションで指定する場合、数値の他に、数式での指定も可能です。
 *
 * また、プラグインコマンドでの変更も可能で、
 * 仮に５人以上のアクターがいるシステムでは、こちらで設定が出来ます。
 *
 * このプラグインは、標準素材とは異なったサイズのSVアクター画像での使用も
 * 想定しています。
 *
 * ■プラグインコマンドの書式
 * SVActorPosition arg0 arg1 arg2
 * arg0 は 1～4の数値にします。5人以上のアクターがいる場合、99まで指定可です
 * arg1 は 'X' か 'Y' にします。
 * arg2 は 座標の値か式にします。式には空白を入れないでください。
 * 例：
 * SVActorPosition 1 X 640    # SV画面のアクター1のX座標を640にします。
 * SVActorPosition 4 Y 472    # SV画面のアクター4のY座標を472にします。
 * 以下のような指定も可能です：
 * SVActorPosition 2 X $gameVariables.value(20)
 * SVActorPosition 3 Y 320+48*2   # 式には空白を入れないことに注意
 * SVActorPosition 5 X 640    # 5人以上が登場するシステムの場合


 * 
 * ■アクターのメモによる設定
 * <SVWeaponHeight:12>
 * サイドビューアクターの武器アニメの表示Y座標の高さを設定します。
 * この例では、通常より12ピクセル高い位置に表示されます。
 * - 標準より小さなアクター画像の作成を想定して、マイナス値も受け付けます。
 * - 記述を省略した場合、デフォルトの0が採用されます。
 * 
 * 武器アニメのX座標は、アクター画像のサイズによって自動的に補正されます。
 * もしそれで不自然な場合は、以下の書式でメモに書いてください。
 * <SVWeaponRight:20>
 * サイドビューアクターの武器アニメの表示X座標を右寄りに補正します。
 * この例では、通常より20ピクセル右位置に表示されます。
 * マイナス値にすることで、左寄りの表示も可能です。
 *
 *
 * ■ライセンス表記
 * このプラグインは MIT ライセンスで配布されます。
 * ご自由にお使いください。
 * http://opensource.org/licenses/mit-license.php
 *
 */

(function() {

  var parameters = PluginManager.parameters('SVActorPosition');
  var SVActorX = new Array(4);
  var SVActorY = new Array(4);
  SVActorX[0] = eval(parameters['actor1 Xpos'] || '600');
  SVActorX[1] = eval(parameters['actor2 Xpos'] || '632');
  SVActorX[2] = eval(parameters['actor3 Xpos'] || '664');
  SVActorX[3] = eval(parameters['actor4 Xpos'] || '696');
  SVActorY[0] = eval(parameters['actor1 Ypos'] || '280');
  SVActorY[1] = eval(parameters['actor2 Ypos'] || '328');
  SVActorY[2] = eval(parameters['actor3 Ypos'] || '376');
  SVActorY[3] = eval(parameters['actor4 Ypos'] || '424');
  // --------------------
  // process plugin commands
  // --------------------
  var _Game_Interpreter_pluginCommand =
   Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    if (command === 'SVActorPosition') {
      // check whether sv array is already defined or not
      if(!$gameSystem.svActorArrayDefined()){
        $gameSystem.defineSvActorArray();
      }
      // inspect and process parameters
      var value = eval(args[2]);
      var pos = Number(args[0]);
      if(value && pos >= 1 && pos <100){
        switch (args[1]) {
        case 'x':
        case 'X':
          $gameSystem.svActorX[pos-1] = value;
          break;
        case 'y':
        case 'Y':
          $gameSystem.svActorY[pos-1] = value;
          break;
        }
      }
    }
  };

  // --------------------
  // define arrays for save sv actors' position
  // --------------------
  var _Game_System_initialize = Game_System.prototype.initialize;
  Game_System.prototype.initialize = function() {
    _Game_System_initialize.call(this);
    this.defineSvActorArray();
  };

  Game_System.prototype.defineSvActorArray = function() {
    this.svActorX = new Array(4);
    this.svActorY = new Array(4);
  };

  Game_System.prototype.svActorArrayDefined = function() {
    return !!this.svActorX;
  };

  // --------------------
  // set actors' position (overwrited)
  // --------------------
  Sprite_Actor.prototype.setActorHome = function(index) {
    // check whether sv array is already defined or not
    if(!$gameSystem.svActorArrayDefined()){
      $gameSystem.defineSvActorArray();
    }
    // set default values
    var x = 600 + index * 32;
    var y = 280 + index * 48;
    // apply option values
    if (index < 4) {
      x = $gameSystem.svActorX[index] || SVActorX[index];
      y = $gameSystem.svActorY[index] || SVActorY[index];
    } else if (index < 100 && !!$gameSystem.svActorX[index]) {
      x = $gameSystem.svActorX[index];
      if (!!$gameSystem.svActorY[index]) {
        y = $gameSystem.svActorY[index];
      }
    }
    // set position
    this.setHome(x, y);
  };

  // --------------------
  // set weapon animation's position
  // --------------------
  var _Sprite_Weapon_setup = Sprite_Weapon.prototype.setup;
  Sprite_Weapon.prototype.setup = function(weaponImageId) {
    _Sprite_Weapon_setup.call(this, weaponImageId);
    this.setPosition();
  };

  Sprite_Weapon.prototype.setPosition = function() {
    // set X position by actor sprite size
    var actorBitmap = this.parent._mainSprite.bitmap;
    var actorSpriteWidth = actorBitmap ? actorBitmap.width / 9 : 64;
    this.x = -16 - (actorSpriteWidth - 64) / 2;
    // set Y default position
    this.y = 0;
    // change X,Y position by actor's note
    var battler = this.parent._battler;
    if(battler){
      this.x += (Number(battler.actor().meta.SVWeaponRight) || 0);
      this.y -= (Number(battler.actor().meta.SVWeaponHeight) || 0);
    }
  };

})();
